/*
 * Decompiled with CFR 0.152.
 */
package com.jadarstudios.developercapes;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.stream.MalformedJsonException;
import com.jadarstudios.developercapes.HDImageBuffer;
import com.jadarstudios.developercapes.user.DefaultUser;
import com.jadarstudios.developercapes.user.GroupUser;
import com.jadarstudios.developercapes.user.IUser;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class DevCapes {
    private static DevCapes instance;
    public static final Logger logger;
    private HashMap<String, IUser> users;
    private HashMap<String, ITextureObject> groups = new HashMap();

    public static DevCapes getInstance() {
        if (instance == null) {
            instance = new DevCapes();
        }
        return instance;
    }

    private DevCapes() {
        this.users = new HashMap();
    }

    public void addGroup(String groupName, ITextureObject texture) {
        this.groups.put(groupName, texture);
    }

    public void addGroup(String groupName, String capeUrl) {
        this.addGroup(groupName, (ITextureObject)new ThreadDownloadImageData(capeUrl, null, (IImageBuffer)new HDImageBuffer()));
    }

    public void addGroupUser(String username, String group) {
        IUser user = this.users.get(username);
        if (user == null) {
            user = new GroupUser(username, group);
            this.users.put(username, user);
            this.loadCape(username);
        }
    }

    public void addSingleUser(String username, String capeUrl) {
        IUser user = this.users.get(username);
        if (user == null) {
            user = new DefaultUser(username, capeUrl);
            this.users.put(username, user);
            this.loadCape(username);
        }
    }

    public ITextureObject getGroupTexture(String group) {
        return this.groups.get(group);
    }

    public IUser getUser(String username) {
        return this.users.get(username);
    }

    public String getUserGroup(String username) {
        return this.isPlayerInGroup(username) ? ((GroupUser)this.users.get((Object)username)).group : null;
    }

    protected ITextureObject getUserTexture(String username) {
        return this.getUser(username).getTexture();
    }

    public boolean isPlayerInGroup(String username) {
        return this.users.containsKey(username) && this.users.get(username) instanceof GroupUser;
    }

    public boolean loadCape(String username) {
        IUser user = this.users.get(username);
        return Minecraft.func_71410_x().field_71446_o.func_110579_a(user.getResource(), user.getTexture());
    }

    public void registerConfig(File jsonFile, String identifier) {
        try {
            this.registerConfig(new FileInputStream(jsonFile), identifier);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void registerConfig(InputStream input, String identifier) {
        try {
            String data = new String(ByteStreams.toByteArray((InputStream)input));
            input.close();
            Map groups = (Map)new Gson().fromJson(data, Map.class);
            for (Map.Entry e : groups.entrySet()) {
                String nodeName = (String)e.getKey();
                Object obj = e.getValue();
                if (obj instanceof Map) {
                    String groupName = nodeName + identifier;
                    Map group = (Map)obj;
                    String capeUrl = (String)group.get("capeUrl");
                    this.addGroup(groupName, capeUrl);
                    ArrayList users = (ArrayList)group.get("users");
                    if (users == null) continue;
                    for (String username : users) {
                        this.addGroupUser(username, groupName);
                    }
                    continue;
                }
                if (!(obj instanceof String)) continue;
                this.addSingleUser(nodeName, (String)obj);
            }
        }
        catch (MalformedJsonException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerConfig(URL jsonUrl, String identifier) {
        try {
            this.registerConfig(jsonUrl.openStream(), identifier);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerConfig(String jsonUrl, String identifier) {
        try {
            this.registerConfig(new URL(jsonUrl), identifier);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    static {
        logger = LogManager.getLogger((String)"DevCapes");
    }
}

