/*
 * Decompiled with CFR 0.152.
 */
package proximitydetector;

import java.util.ArrayList;
import java.util.HashMap;
import proximitydetector.Entity;
import proximitydetector.ProximityDetector;
import proximitydetector.ProximityDetector2MinecraftProxy;

public class ProximityDetectorCalculator {
    private static ProximityDetectorCalculator calculator = null;
    private HashMap<String, Entity> entities = new HashMap();

    public static ProximityDetectorCalculator getInstance() {
        if (calculator == null) {
            calculator = new ProximityDetectorCalculator();
        }
        return calculator;
    }

    public HashMap<String, Entity> getEntities() {
        return this.entities;
    }

    public void mapCalcDetector(ProximityDetector detector) {
        try {
            this.entities = new HashMap();
            ArrayList<Entity> allEntities = ProximityDetector2MinecraftProxy.getAllEntities();
            for (Entity ent : allEntities) {
                if (ent == null) continue;
                int entDistXZ = (int)Math.sqrt(Math.pow(ent.getX() - ProximityDetector2MinecraftProxy.xCoord(), 2.0) + Math.pow(ent.getZ() - ProximityDetector2MinecraftProxy.zCoord(), 2.0));
                ent.setDistanceXZ(entDistXZ);
                int entDist = (int)Math.sqrt(Math.pow(entDistXZ, 2.0) + Math.pow(ent.getY() - ProximityDetector2MinecraftProxy.yCoord(), 2.0));
                if (entDist <= 0) continue;
                if (detector.getDistanceFilter() != 200) {
                    if (entDist >= detector.getDistanceFilter()) continue;
                    this.entities.put(ent.getKey(), ent);
                    continue;
                }
                this.entities.put(ent.getKey(), ent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

