/*
 * Decompiled with CFR 0.152.
 */
package proximitydetector;

import org.lwjgl.opengl.GL11;
import proximitydetector.Entity;
import proximitydetector.ProximityDetector;
import proximitydetector.ProximityDetector2MinecraftProxy;
import proximitydetector.ProximityDetectorCalculator;

public class ProximityDetectorRenderer {
    public static final int ENTITIESDISP_ALL = 1;
    public static final int ENTITIESDISP_MOBS_HOST = 4;
    public static final int ENTITIESDISP_MOBS_NEUTPASS = 3;
    public static final int ENTITIESDISP_MOBSONLY = 2;
    public static final int ENTITIESDISP_PLAYERSONLY = 5;
    private static ProximityDetectorRenderer renderer = null;
    private float direction;
    private float directionV;
    private int entityTypeDisplayed = 1;
    private int q = 0;
    private int scHeight;
    private int scWidth;

    public static ProximityDetectorRenderer getInstance() {
        if (renderer == null) {
            renderer = new ProximityDetectorRenderer();
        }
        return renderer;
    }

    private void displayCurrentSettings(ProximityDetector detector) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        ProximityDetector2MinecraftProxy.write("ProximityDetector:", 10, this.scHeight * 2 - 30, 0xFFFFFF);
        if (detector.getDistanceFilter() == 200) {
            ProximityDetector2MinecraftProxy.write("-Distance: ALL", 10, this.scHeight * 2 - 20, 0xFFFFFF);
        } else if (detector.getDistanceFilter() == 100) {
            ProximityDetector2MinecraftProxy.write("-Distance: FAR", 10, this.scHeight * 2 - 20, 0xFFFFFF);
        } else if (detector.getDistanceFilter() == 50) {
            ProximityDetector2MinecraftProxy.write("-Distance: CLOSE", 10, this.scHeight * 2 - 20, 0xFFFFFF);
        } else if (detector.getDistanceFilter() == 30) {
            ProximityDetector2MinecraftProxy.write("-Distance: NEARBY", 10, this.scHeight * 2 - 20, 0xFFFFFF);
        } else if (detector.getDistanceFilter() == 0) {
            ProximityDetector2MinecraftProxy.write("-Distance: HIDDEN", 10, this.scHeight * 2 - 20, 0xFFFFFF);
        }
        if (this.entityTypeDisplayed == 2) {
            ProximityDetector2MinecraftProxy.write("-Entities: MOBS ONLY", 10, this.scHeight * 2 - 10, 0xFFFFFF);
        } else if (this.entityTypeDisplayed == 3) {
            ProximityDetector2MinecraftProxy.write("-Entities: MOBS NEUTRAL&PASSIVE", 10, this.scHeight * 2 - 10, 0xFFFFFF);
        } else if (this.entityTypeDisplayed == 4) {
            ProximityDetector2MinecraftProxy.write("-Entities: MOBS HOSTILE", 10, this.scHeight * 2 - 10, 0xFFFFFF);
        } else if (this.entityTypeDisplayed == 5) {
            ProximityDetector2MinecraftProxy.write("-Entities: PLAYERS ONLY", 10, this.scHeight * 2 - 10, 0xFFFFFF);
        } else if (this.entityTypeDisplayed == 1) {
            ProximityDetector2MinecraftProxy.write("-Entities: ALL", 10, this.scHeight * 2 - 10, 0xFFFFFF);
        }
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public int getEntityTypeDisplayed() {
        return this.entityTypeDisplayed;
    }

    private float getScale(Entity ent, ProximityDetector detector) {
        float scale = 1.0f;
        if (ent.getDistanceXZ() > 100) {
            scale = 0.3f;
        } else if (ent.getDistanceXZ() > 70) {
            scale = 0.4f;
        } else if (ent.getDistanceXZ() > 50) {
            scale = 0.5f;
        } else if (ent.getDistanceXZ() > 40) {
            scale = 0.6f;
        } else if (ent.getDistanceXZ() > 30) {
            scale = 0.7f;
        } else if (ent.getDistanceXZ() > 20) {
            scale = 0.8f;
        } else if (ent.getDistanceXZ() > 10) {
            scale = 0.9f;
        }
        return scale;
    }

    private boolean isEntityInNotFront(float angle, float dir, float delta) {
        boolean displayEntity = true;
        float minAngle1 = dir - delta;
        float minAngle2 = dir;
        float maxAngle1 = dir;
        float maxAngle2 = dir + delta;
        if (dir < delta) {
            minAngle1 = 0.0f;
            minAngle2 = dir + delta;
            maxAngle1 = 360.0f + dir - delta;
            maxAngle2 = 360.0f;
        } else if (dir > 360.0f - delta) {
            minAngle1 = 0.0f;
            minAngle2 = dir + delta - 360.0f;
            maxAngle1 = dir - delta;
            maxAngle2 = 360.0f;
        }
        if (!(angle > minAngle1 && angle < minAngle2 || angle > maxAngle1 && angle < maxAngle2)) {
            displayEntity = false;
        }
        return displayEntity;
    }

    private boolean isEntityTypeToDisplay(Entity entity) {
        boolean displayEntity = true;
        if (this.entityTypeDisplayed == 2) {
            if (entity.getType() == Entity.PLAYER) {
                displayEntity = false;
            }
        } else if (this.entityTypeDisplayed == 3) {
            if (entity.getType() == Entity.PLAYER || entity.getType() == Entity.MOB_HOSTILE) {
                displayEntity = false;
            }
        } else if (this.entityTypeDisplayed == 4) {
            if (entity.getType() == Entity.PLAYER || entity.getType() == Entity.MOB_NEUTRAL || entity.getType() == Entity.MOB_PASSIVE) {
                displayEntity = false;
            }
        } else if (this.entityTypeDisplayed == 5 && (entity.getType() == Entity.MOB_HOSTILE || entity.getType() == Entity.MOB_NEUTRAL || entity.getType() == Entity.MOB_PASSIVE)) {
            displayEntity = false;
        }
        return displayEntity;
    }

    public void refreshWindowSize() {
        this.scWidth = ProximityDetector2MinecraftProxy.getWidth();
        this.scHeight = ProximityDetector2MinecraftProxy.getHeight();
        this.scWidth -= 5;
    }

    public void renderRadar(ProximityDetector detector) {
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!detector.isHidden()) {
            if (this.q != 0) {
                ProximityDetector2MinecraftProxy.deleteTex(this.q);
            }
            this.displayCurrentSettings(detector);
            for (Entity entity : ProximityDetectorCalculator.getInstance().getEntities().values()) {
                if (!this.isEntityTypeToDisplay(entity)) continue;
                int wayX = ProximityDetector2MinecraftProxy.xCoord() - entity.getX();
                int wayY = ProximityDetector2MinecraftProxy.yCoord() - entity.getY();
                int wayZ = ProximityDetector2MinecraftProxy.zCoord() - entity.getZ();
                float locate = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
                locate = this.updateAngle(locate);
                float locateV = (float)Math.toDegrees(Math.atan2(entity.getDistanceXZ(), wayY));
                locateV = this.updateAngle(locateV);
                if (!this.isEntityInNotFront(locate, this.direction, 90.0f) || !this.isEntityInNotFront(locateV, this.directionV, 40.0f)) continue;
                double sinH = Math.sin(Math.toRadians(this.direction - locate));
                double sinV = Math.sin(Math.toRadians(this.directionV - locateV));
                float x = (int)((double)this.scWidth * 0.5 + (double)this.scWidth * 0.3 * sinH);
                float y = (int)((double)this.scHeight * 0.5) + (int)((double)this.scHeight * 0.3 * sinV);
                try {
                    GL11.glPushMatrix();
                    float scale = this.getScale(entity, detector);
                    GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                    String name = entity.getName();
                    if ((double)scale < 0.9 && name.length() > 3) {
                        name = name.substring(0, 3);
                    }
                    ProximityDetector2MinecraftProxy.write(name, (int)(x / scale), (int)(y / scale), entity.getType().color);
                    GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                }
                catch (Exception localException) {
                    localException.printStackTrace();
                }
            }
        }
    }

    public void setDirection(float direction) {
        this.direction = this.updateAngle(direction + 180.0f);
    }

    public void setDirectionV(float directionV) {
        this.directionV = this.updateAngle(directionV + 90.0f);
    }

    public void setEntityTypeDisplayed(int entityTypeDisplayed) {
        this.entityTypeDisplayed = entityTypeDisplayed;
    }

    public void setScHeight(int scHeight) {
        this.scHeight = scHeight;
    }

    public void setScWidth(int scWidth) {
        this.scWidth = scWidth;
    }

    private float updateAngle(float locate) {
        if (locate >= 360.0f) {
            while (locate >= 360.0f) {
                locate -= 360.0f;
            }
        }
        if (locate < 0.0f) {
            while (locate < 0.0f) {
                locate += 360.0f;
            }
        }
        return locate;
    }
}

