/*
 * Decompiled with CFR 0.152.
 */
package proximitydetector;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import proximitydetector.ProximityDetector;
import proximitydetector.ProximityDetector2MinecraftProxy;
import proximitydetector.ProximityDetectorCalculator;
import proximitydetector.ProximityDetectorConfiguration;
import proximitydetector.ProximityDetectorRenderer;

public class ProximityDetectorRunner {
    private ProximityDetector detector = null;
    private int distanceKey = 33;
    private boolean enabled = true;
    private int entityTypeKey = 34;
    private String error = "";
    private int fudge = 0;
    private boolean isPressed = false;
    private int refreshTimer = 200;
    private int timer = 0;
    private int ztimer = 0;

    public ProximityDetectorRunner() {
        try {
            this.detector = new ProximityDetector();
            ProximityDetectorConfiguration.initDetector(this, this.detector);
            ProximityDetectorConfiguration.loadEntities();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void calcMap() {
        ProximityDetectorCalculator.getInstance().mapCalcDetector(this.detector);
    }

    private void changeDisplayedEntityType() {
        if (this.fudge > 0) {
            return;
        }
        if (ProximityDetectorRenderer.getInstance().getEntityTypeDisplayed() == 1) {
            ProximityDetectorRenderer.getInstance().setEntityTypeDisplayed(2);
            this.error = "Type of entity displayed: All Mobs";
        } else if (ProximityDetectorRenderer.getInstance().getEntityTypeDisplayed() == 2) {
            ProximityDetectorRenderer.getInstance().setEntityTypeDisplayed(3);
            this.error = "Type of entity displayed: Neutral and passive mobs only";
        } else if (ProximityDetectorRenderer.getInstance().getEntityTypeDisplayed() == 3) {
            ProximityDetectorRenderer.getInstance().setEntityTypeDisplayed(4);
            this.error = "Type of entity displayed: Hostile mobs only";
        } else if (ProximityDetectorRenderer.getInstance().getEntityTypeDisplayed() == 4) {
            ProximityDetectorRenderer.getInstance().setEntityTypeDisplayed(5);
            this.error = "Type of entity displayed: Players only";
        } else if (ProximityDetectorRenderer.getInstance().getEntityTypeDisplayed() == 5) {
            ProximityDetectorRenderer.getInstance().setEntityTypeDisplayed(1);
            this.error = "Type of entity displayed: All entities (players and mobs)";
        }
        ProximityDetectorConfiguration.writeCurrentConf(this.detector);
        this.fudge = 20;
    }

    private void changeDistanceFilter() {
        if (this.fudge > 0) {
            return;
        }
        if (this.detector.getDistanceFilter() == 200) {
            this.detector.setDistanceFilter(100);
            this.error = "Distance filter: Far entities (distance < 100)";
        } else if (this.detector.getDistanceFilter() == 100) {
            this.detector.setDistanceFilter(50);
            this.error = "Distance filter: Close entities (distance < 50)";
        } else if (this.detector.getDistanceFilter() == 50) {
            this.detector.setDistanceFilter(30);
            this.error = "Distance filter: Nearby entities (distance < 30)";
        } else if (this.detector.getDistanceFilter() == 30) {
            this.detector.setDistanceFilter(0);
            this.error = "Distance filter: Detector hidden";
        } else if (this.detector.getDistanceFilter() == 0) {
            this.detector.setDistanceFilter(200);
            this.error = "Distance filter: All entities (no distance filter)";
        }
        ProximityDetectorConfiguration.writeCurrentConf(this.detector);
        this.fudge = 20;
    }

    private boolean isMenuShowing() {
        return ProximityDetector2MinecraftProxy.getMenu() != null;
    }

    public boolean OnTickInGame() {
        if (this.enabled && !this.detector.isHidden() && (this.timer > this.refreshTimer || this.detector.isDirectionChanged())) {
            this.calcMap();
        }
        if (!this.isMenuShowing()) {
            if (Keyboard.isKeyDown((int)this.distanceKey) && !this.isPressed) {
                this.changeDistanceFilter();
                this.isPressed = true;
            } else if (Keyboard.isKeyDown((int)this.entityTypeKey) && !this.isPressed) {
                this.changeDisplayedEntityType();
                this.isPressed = true;
            } else {
                this.isPressed = false;
            }
        }
        this.enabled = !this.isMenuShowing();
        ProximityDetectorRenderer.getInstance().refreshWindowSize();
        this.detector.refreshDirection();
        if (!this.error.equals("") && this.ztimer == 0) {
            this.ztimer = 500;
        }
        if (this.ztimer > 0) {
            --this.ztimer;
        }
        if (this.fudge > 0) {
            --this.fudge;
        }
        if (this.ztimer == 0 && !this.error.equals("")) {
            this.error = "";
        }
        if (this.enabled) {
            this.renderMap();
            if (this.ztimer > 0) {
                ProximityDetector2MinecraftProxy.write(this.error, 20, 20, 0xFFFFFF);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    private synchronized void renderMap() {
        ProximityDetectorRenderer.getInstance().renderRadar(this.detector);
    }

    public void setDistanceKey(int distanceKey) {
        this.distanceKey = distanceKey;
    }

    public void setEntityTypeKey(int entityTypeKey) {
        this.entityTypeKey = entityTypeKey;
    }
}

