/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.eventhandler.world;

import biomesoplenty.common.world.decoration.BOPWorldFeatures;
import biomesoplenty.common.world.decoration.ForcedDecorators;
import biomesoplenty.common.world.decoration.IBOPDecoration;
import biomesoplenty.common.world.generation.ForcedBOPWorldGenerators;
import biomesoplenty.common.world.generation.IWorldGeneratorBOP;
import biomesoplenty.common.world.generation.WorldGenFieldAssociation;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class DecorateBiomeEventHandler {
    @SubscribeEvent
    public void onBiomeDecorate(DecorateBiomeEvent.Pre event) {
        World world = event.world;
        int chunkX = event.chunkX;
        int chunkZ = event.chunkZ;
        Random random = event.rand;
        int x = chunkX;
        int z = chunkZ;
        BiomeGenBase biome = world.getBiomeGenForCoordsBody(x + 8, z + 8);
        IBOPDecoration bopDecoration = null;
        if (biome instanceof IBOPDecoration) {
            bopDecoration = (IBOPDecoration)biome;
        } else if (ForcedDecorators.biomeHasForcedDecorator(biome.field_76756_M)) {
            bopDecoration = ForcedDecorators.getForcedDecorator(biome.field_76756_M);
        }
        if (bopDecoration != null) {
            for (Field worldGeneratorField : BOPWorldFeatures.class.getFields()) {
                try {
                    WorldGenerator worldGenerator = null;
                    worldGenerator = worldGeneratorField.getName().equals("bopFlowersPerChunk") && TerrainGen.decorate((World)world, (Random)random, (int)chunkX, (int)chunkZ, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS) ? bopDecoration.getRandomWorldGenForBOPFlowers(random) : WorldGenFieldAssociation.getAssociatedWorldGenerator(worldGeneratorField.getName());
                    if (worldGenerator == null) continue;
                    IWorldGeneratorBOP worldGeneratorBOP = null;
                    if (worldGenerator instanceof IWorldGeneratorBOP) {
                        worldGeneratorBOP = (IWorldGeneratorBOP)worldGenerator;
                    } else if (ForcedBOPWorldGenerators.hasForcedGenerator(worldGenerator.getClass())) {
                        worldGeneratorBOP = ForcedBOPWorldGenerators.getForcedGenerator(worldGenerator.getClass());
                    }
                    if (worldGeneratorBOP == null) continue;
                    worldGeneratorBOP.doGeneration(world, random, worldGeneratorField, worldGenerator, biome, bopDecoration, x, z);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void decorate(World world, Random random, BiomeGenBase biome, int x, int z) {
        BiomeDecorator biomeDecorator = biome.field_76760_I;
        if (biomeDecorator.field_76815_a != null) {
            return;
        }
        biomeDecorator.field_76815_a = world;
        biomeDecorator.field_76813_b = random;
        biomeDecorator.field_76814_c = x;
        biomeDecorator.field_76811_d = z;
        try {
            ReflectionHelper.findMethod(BiomeDecorator.class, (Object)biomeDecorator, (String[])new String[]{"func_150513_a"}, (Class[])new Class[]{BiomeGenBase.class}).invoke((Object)biomeDecorator, biome);
        }
        catch (Exception e) {
            // empty catch block
        }
        biomeDecorator.field_76815_a = null;
        biomeDecorator.field_76813_b = null;
    }
}

