/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.registry;

import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ToolRegistry;
import bspkrs.treecapitator.registry.TreeRegistry;
import net.minecraft.nbt.NBTTagCompound;

public class RegistryNBTManager {
    private NBTTagCompound localTCSettings;
    private NBTTagCompound localTreeRegistry;
    private NBTTagCompound localToolRegistry;
    private NBTTagCompound remoteTCSettings;
    private NBTTagCompound remoteTreeRegistry;
    private NBTTagCompound remoteToolRegistry;

    public RegistryNBTManager(NBTTagCompound tcSettingsNBT, NBTTagCompound treeRegistryNBT, NBTTagCompound toolRegistryNBT) {
        this();
        this.setRemoteTCSettings(tcSettingsNBT);
        this.setRemoteTreeRegistry(treeRegistryNBT);
        this.setRemoteToolRegistry(toolRegistryNBT);
    }

    public RegistryNBTManager() {
        this.saveCurrentTCSettingsToLocal();
        this.saveCurrentTreeRegistryToLocal();
        this.saveCurrentToolRegistryToLocal();
        this.setRemoteTCSettings(this.localTCSettings);
        this.setRemoteTreeRegistry(this.localTreeRegistry);
        this.setRemoteToolRegistry(this.localToolRegistry);
    }

    protected RegistryNBTManager saveCurrentTCSettingsToLocal() {
        this.localTCSettings = new NBTTagCompound();
        TCSettings.instance().writeToNBT(this.localTCSettings);
        return this;
    }

    protected RegistryNBTManager saveCurrentTreeRegistryToLocal() {
        this.localTreeRegistry = new NBTTagCompound();
        TreeRegistry.instance().writeToNBT(this.localTreeRegistry);
        return this;
    }

    protected RegistryNBTManager saveCurrentToolRegistryToLocal() {
        this.localToolRegistry = new NBTTagCompound();
        ToolRegistry.instance().writeToNBT(this.localToolRegistry);
        return this;
    }

    public RegistryNBTManager setRemoteTCSettings(NBTTagCompound ntc) {
        this.remoteTCSettings = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteTreeRegistry(NBTTagCompound ntc) {
        this.remoteTreeRegistry = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteToolRegistry(NBTTagCompound ntc) {
        this.remoteToolRegistry = ntc;
        return this;
    }

    public RegistryNBTManager setRemoteNBTs(NBTTagCompound set, NBTTagCompound tree, NBTTagCompound tool) {
        return this.setRemoteTCSettings(set).setRemoteTreeRegistry(tree).setRemoteToolRegistry(tool);
    }

    public void registerLocalInstances() {
        TCSettings.instance().readFromNBT(this.localTCSettings);
        TreeRegistry.instance().readFromNBT(this.localTreeRegistry);
        ToolRegistry.instance().readFromNBT(this.localToolRegistry);
    }

    public void registerRemoteInstances() {
        TCSettings.instance().readFromNBT(this.remoteTCSettings);
        TreeRegistry.instance().readFromNBT(this.remoteTreeRegistry);
        ToolRegistry.instance().readFromNBT(this.remoteToolRegistry);
    }

    public NBTTagCompound[] getPacketArray() {
        return new NBTTagCompound[]{this.localTCSettings, this.localTreeRegistry, this.localToolRegistry};
    }
}

