/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.registry;

import bspkrs.helpers.nbt.NBTTagCompoundHelper;
import bspkrs.helpers.nbt.NBTTagListHelper;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.TreeDefinition;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BlockID;
import bspkrs.util.Coord;
import bspkrs.util.ListUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class TreeRegistry {
    private Map<String, TreeDefinition> treeDefs;
    private Map<BlockID, String> logToStringMap;
    private TreeDefinition masterDefinition;
    private Map<String, TreeDefinition> vanTrees;
    private List<BlockID> blacklist;
    private Set<Coord> blocksBeingChopped;
    private static TreeRegistry instance;

    public static TreeRegistry instance() {
        if (instance == null) {
            new TreeRegistry();
        }
        return instance;
    }

    protected TreeRegistry() {
        instance = this;
        this.initMapsAndLists();
        this.initVanillaTreeDefs();
    }

    protected void initMapsAndLists() {
        this.treeDefs = new HashMap<String, TreeDefinition>();
        this.logToStringMap = new HashMap<BlockID, String>();
        this.masterDefinition = new TreeDefinition();
        this.blacklist = new ArrayList<BlockID>();
        this.blocksBeingChopped = new HashSet<Coord>();
    }

    protected void initVanillaTreeDefs() {
        this.vanTrees = new TreeMap<String, TreeDefinition>();
        this.vanTrees.put("vanilla_oak", new TreeDefinition().addLogID(new BlockID(Blocks.field_150364_r, 0)).addLogID(new BlockID(Blocks.field_150364_r, 4)).addLogID(new BlockID(Blocks.field_150364_r, 8)).addLogID(new BlockID(Blocks.field_150364_r, 12)).addLeafID(new BlockID((Block)Blocks.field_150362_t, 0)).addLeafID(new BlockID((Block)Blocks.field_150362_t, 8)));
        this.vanTrees.put("vanilla_spruce", new TreeDefinition().addLogID(new BlockID(Blocks.field_150364_r, 1)).addLogID(new BlockID(Blocks.field_150364_r, 5)).addLogID(new BlockID(Blocks.field_150364_r, 9)).addLogID(new BlockID(Blocks.field_150364_r, 13)).addLeafID(new BlockID((Block)Blocks.field_150362_t, 1)).addLeafID(new BlockID((Block)Blocks.field_150362_t, 9)));
        this.vanTrees.put("vanilla_birch", new TreeDefinition().addLogID(new BlockID(Blocks.field_150364_r, 2)).addLogID(new BlockID(Blocks.field_150364_r, 6)).addLogID(new BlockID(Blocks.field_150364_r, 10)).addLogID(new BlockID(Blocks.field_150364_r, 14)).addLeafID(new BlockID((Block)Blocks.field_150362_t, 2)).addLeafID(new BlockID((Block)Blocks.field_150362_t, 10)));
        this.vanTrees.put("vanilla_jungle", new TreeDefinition().addLogID(new BlockID(Blocks.field_150364_r, 3)).addLogID(new BlockID(Blocks.field_150364_r, 7)).addLogID(new BlockID(Blocks.field_150364_r, 11)).addLogID(new BlockID(Blocks.field_150364_r, 15)).addLeafID(new BlockID((Block)Blocks.field_150362_t, 3)).addLeafID(new BlockID((Block)Blocks.field_150362_t, 11)).addLeafID(new BlockID((Block)Blocks.field_150362_t, 0)).addLeafID(new BlockID((Block)Blocks.field_150362_t, 8)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false).setUseAdvancedTopLogLogic(true));
        this.vanTrees.put("vanilla_acacia", new TreeDefinition().addLogID(new BlockID(Blocks.field_150363_s, 0)).addLogID(new BlockID(Blocks.field_150363_s, 4)).addLogID(new BlockID(Blocks.field_150363_s, 8)).addLogID(new BlockID(Blocks.field_150363_s, 12)).addLeafID(new BlockID((Block)Blocks.field_150361_u, 0)).addLeafID(new BlockID((Block)Blocks.field_150361_u, 8)).setUseAdvancedTopLogLogic(true));
        this.vanTrees.put("vanilla_dark_oak", new TreeDefinition().addLogID(new BlockID(Blocks.field_150363_s, 1)).addLogID(new BlockID(Blocks.field_150363_s, 5)).addLogID(new BlockID(Blocks.field_150363_s, 9)).addLogID(new BlockID(Blocks.field_150363_s, 13)).addLeafID(new BlockID((Block)Blocks.field_150361_u, 1)).addLeafID(new BlockID((Block)Blocks.field_150361_u, 9)).setUseAdvancedTopLogLogic(true));
        this.vanTrees.put("vanilla_future_tree_1", new TreeDefinition().addLogID(new BlockID(Blocks.field_150363_s, 2)).addLogID(new BlockID(Blocks.field_150363_s, 6)).addLogID(new BlockID(Blocks.field_150363_s, 10)).addLogID(new BlockID(Blocks.field_150363_s, 14)).addLeafID(new BlockID((Block)Blocks.field_150361_u, 2)).addLeafID(new BlockID((Block)Blocks.field_150361_u, 10)));
        this.vanTrees.put("vanilla_future_tree_2", new TreeDefinition().addLogID(new BlockID(Blocks.field_150363_s, 3)).addLogID(new BlockID(Blocks.field_150363_s, 7)).addLogID(new BlockID(Blocks.field_150363_s, 11)).addLogID(new BlockID(Blocks.field_150363_s, 15)).addLeafID(new BlockID((Block)Blocks.field_150361_u, 3)).addLeafID(new BlockID((Block)Blocks.field_150361_u, 11)));
        this.vanTrees.put("vanilla_huge_brown_mushroom", new TreeDefinition().addLogID(new BlockID(Blocks.field_150420_aW, 10)).addLogID(new BlockID(Blocks.field_150420_aW, 15)).addLeafID(new BlockID(Blocks.field_150420_aW, 1)).addLeafID(new BlockID(Blocks.field_150420_aW, 2)).addLeafID(new BlockID(Blocks.field_150420_aW, 3)).addLeafID(new BlockID(Blocks.field_150420_aW, 4)).addLeafID(new BlockID(Blocks.field_150420_aW, 5)).addLeafID(new BlockID(Blocks.field_150420_aW, 6)).addLeafID(new BlockID(Blocks.field_150420_aW, 7)).addLeafID(new BlockID(Blocks.field_150420_aW, 8)).addLeafID(new BlockID(Blocks.field_150420_aW, 9)).addLeafID(new BlockID(Blocks.field_150420_aW, 14)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false));
        this.vanTrees.put("vanilla_huge_red_mushroom", new TreeDefinition().addLogID(new BlockID(Blocks.field_150419_aX, 10)).addLogID(new BlockID(Blocks.field_150419_aX, 15)).addLeafID(new BlockID(Blocks.field_150419_aX, 1)).addLeafID(new BlockID(Blocks.field_150419_aX, 2)).addLeafID(new BlockID(Blocks.field_150419_aX, 3)).addLeafID(new BlockID(Blocks.field_150419_aX, 4)).addLeafID(new BlockID(Blocks.field_150419_aX, 5)).addLeafID(new BlockID(Blocks.field_150419_aX, 6)).addLeafID(new BlockID(Blocks.field_150419_aX, 7)).addLeafID(new BlockID(Blocks.field_150419_aX, 8)).addLeafID(new BlockID(Blocks.field_150419_aX, 9)).addLeafID(new BlockID(Blocks.field_150419_aX, 14)).setMaxHorLeafBreakDist(6).setRequireLeafDecayCheck(false));
    }

    protected void registerVanillaTreeDefs() {
        for (Map.Entry<String, TreeDefinition> e : this.vanTrees.entrySet()) {
            this.registerTree(e.getKey(), e.getValue());
        }
    }

    public void registerTree(String newKey, TreeDefinition newTD) {
        if (newTD != null) {
            LinkedList<String> sharedLogTrees = new LinkedList<String>();
            HashMap<BlockID, String> toAdd = new HashMap<BlockID, String>();
            for (BlockID blockID : newTD.getLogList()) {
                if (!this.isRegistered(blockID) && !this.blacklist.contains(blockID)) {
                    toAdd.put(blockID, newKey);
                    continue;
                }
                if (!this.logToStringMap.containsKey(blockID) || sharedLogTrees.contains(this.logToStringMap.get(blockID))) continue;
                sharedLogTrees.add(this.logToStringMap.get(blockID));
            }
            if (!newKey.trim().isEmpty() && !this.isRegistered(newKey) && sharedLogTrees.size() == 0) {
                TCLog.debug("Tree Definition \"%s\" is new.  Proceeding to insert new key.", newKey);
                this.treeDefs.put(newKey, newTD);
                TCLog.debug("    New key %s added with values: %s", newKey, newTD.toString());
                this.logToStringMap.putAll(toAdd);
            } else if (!newKey.trim().isEmpty()) {
                if (sharedLogTrees.size() > 0) {
                    for (String existingKey : sharedLogTrees) {
                        TCLog.debug("Tree Definition \"%s\" contains a log that is registered with an existing tree (%s).  The existing definition will be merged with the new tree.", newKey, existingKey);
                        newTD.appendWithSettings(this.treeDefs.remove(existingKey));
                    }
                    this.treeDefs.put(newKey, newTD);
                    TCLog.debug("    New key %s added with values: %s", newKey, newTD.toString());
                    for (BlockID blockID : newTD.getLogList()) {
                        this.logToStringMap.put(blockID, newKey);
                    }
                } else {
                    TCLog.debug("\"%s\" is already registered.  The new definition will be appended to the existing entry.", newKey);
                    this.treeDefs.get(newKey).appendWithSettings(newTD);
                    TCLog.debug("    Key %s appended with values: %s", newKey, newTD.toString());
                    this.logToStringMap.putAll(toAdd);
                }
            } else if (sharedLogTrees.size() == 1) {
                String existingTree = (String)sharedLogTrees.remove(0);
                this.treeDefs.get(existingTree).appendWithSettings(newTD);
                TCLog.debug("    Blank key tree appended with values: %s", newTD.toString());
                for (BlockID log : newTD.getLogList()) {
                    if (this.logToStringMap.containsKey(log)) continue;
                    this.logToStringMap.put(log, existingTree);
                }
                this.masterDefinition.append(newTD);
            } else {
                TCLog.warning("TreeDefinition cannot be registered with an empty Key.", new Object[0]);
                return;
            }
            if (!newKey.trim().isEmpty()) {
                this.masterDefinition.append(this.treeDefs.get(newKey));
            }
        } else {
            TCLog.warning("TreeDefinition cannot be null when registering a tree!", new Object[0]);
        }
    }

    public boolean trackTreeChopEventAt(Coord c) {
        if (!this.blocksBeingChopped.contains(c)) {
            this.blocksBeingChopped.add(c);
            return true;
        }
        return false;
    }

    public void endTreeChopEventAt(Coord c) {
        if (this.blocksBeingChopped.contains(c)) {
            this.blocksBeingChopped.remove(c);
        }
    }

    public String getMultiMineExclusionString() {
        String r = "";
        HashSet<String> processed = new HashSet<String>();
        for (BlockID log : this.masterDefinition.logBlocks) {
            if (processed.contains(log.id)) continue;
            processed.add(log.id);
            r = r + "," + log.id;
        }
        return r.replaceFirst(",", "");
    }

    public TreeDefinition masterDefinition() {
        return this.masterDefinition;
    }

    public boolean isRegistered(String key) {
        return this.treeDefs.containsKey(key);
    }

    public boolean isRegistered(BlockID log) {
        if (!this.blacklist.contains(log)) {
            return this.masterDefinition.isLogBlock(log);
        }
        return false;
    }

    public TreeDefinition get(String key) {
        if (this.isRegistered(key)) {
            return this.treeDefs.get(key);
        }
        return null;
    }

    public TreeDefinition get(BlockID blockID) {
        if (this.isRegistered(blockID)) {
            if (TCSettings.useStrictBlockPairing) {
                String treeKey = this.logToStringMap.get(blockID);
                TreeDefinition treeDef = this.get(this.logToStringMap.get(blockID));
                if (treeDef != null) {
                    return treeDef;
                }
                if (blockID.metadata > -1) {
                    treeKey = this.logToStringMap.get(new BlockID(blockID.id));
                    return this.get(treeKey);
                }
            }
            return this.masterDefinition;
        }
        return null;
    }

    public List<BlockID> masterLogList() {
        return this.masterDefinition.getLogList();
    }

    public List<BlockID> masterLeafList() {
        return this.masterDefinition.getLeafList();
    }

    public Map<String, TreeDefinition> vanillaTrees() {
        return new TreeMap<String, TreeDefinition>(this.vanTrees);
    }

    public List<BlockID> blacklist() {
        return new ArrayList<BlockID>(this.blacklist);
    }

    public void readBlacklistFromDelimitedString(String dList) {
        this.blacklist = ListUtils.getDelimitedStringAsBlockIDList((String)dList, (String)";");
    }

    protected void readFromNBT(NBTTagCompound ntc) {
        int i;
        this.treeDefs = new HashMap<String, TreeDefinition>();
        NBTTagList l = NBTTagCompoundHelper.getTagList((NBTTagCompound)ntc, (String)"treeDefs", (Byte)10);
        for (i = 0; i < l.func_74745_c(); ++i) {
            NBTTagCompound treeNBT = NBTTagListHelper.getCompoundTagAt((NBTTagList)l, (int)i);
            this.treeDefs.put(treeNBT.func_74779_i("treeName"), new TreeDefinition(treeNBT));
        }
        this.logToStringMap = new HashMap<BlockID, String>();
        l = NBTTagCompoundHelper.getTagList((NBTTagCompound)ntc, (String)"logToStringMap", (Byte)8);
        for (i = 0; i < l.func_74745_c(); ++i) {
            String s = NBTTagListHelper.getStringTagAt((NBTTagList)l, (int)i);
            String[] t = s.split("=");
            this.logToStringMap.put(new BlockID(t[0], ","), t[1]);
        }
        this.masterDefinition = new TreeDefinition(ntc.func_74775_l("masterDefinition"));
        this.blacklist = ListUtils.getDelimitedStringAsBlockIDList((String)ntc.func_74779_i("blacklist"), (String)";");
    }

    public void writeToNBT(NBTTagCompound ntc) {
        NBTTagList trees = new NBTTagList();
        for (Map.Entry<String, TreeDefinition> e : this.treeDefs.entrySet()) {
            NBTTagCompound tree = new NBTTagCompound();
            e.getValue().writeToNBT(tree);
            tree.func_74778_a("treeName", e.getKey());
            trees.func_74742_a((NBTBase)tree);
        }
        ntc.func_74782_a("treeDefs", (NBTBase)trees);
        NBTTagList entries = new NBTTagList();
        for (Map.Entry<BlockID, String> e : this.logToStringMap.entrySet()) {
            NBTTagString s = new NBTTagString(e.getKey() + "=" + e.getValue());
            entries.func_74742_a((NBTBase)s);
        }
        ntc.func_74782_a("logToStringMap", (NBTBase)entries);
        NBTTagCompound md = new NBTTagCompound();
        this.masterDefinition.writeToNBT(md);
        ntc.func_74782_a("masterDefinition", (NBTBase)md);
        ntc.func_74778_a("blacklist", ListUtils.getListAsDelimitedString(this.blacklist, (String)";"));
    }
}

