/*
 * Decompiled with CFR 0.152.
 */
package karabin.backpack;

import java.util.ArrayList;
import java.util.Scanner;
import karabin.backpack.Data;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;

class Backpack {
    private static ItemStack BackpackItemStack;
    private static ItemMeta BackpackItemMeta;

    Backpack() {
    }

    protected static void addRecipe(Server server) {
        BackpackItemStack = new ItemStack(Material.LEATHER);
        BackpackItemMeta = BackpackItemStack.getItemMeta();
        BackpackItemMeta.setDisplayName(String.valueOf(Data.getBackpackColor()) + Data.getBackpackName());
        BackpackItemStack.setItemMeta(BackpackItemMeta);
        BackpackItemStack.setDurability(Data.getBackpackDurability());
    }

    static ItemStack getItemStack() {
        return BackpackItemStack;
    }

    static void setRecipe(Scanner scanner, Server server) {
        String line;
        String allChars = "";
        ShapedRecipe backpackRecipe = new ShapedRecipe(new ItemStack(BackpackItemStack));
        ArrayList<String> al = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            al.add(scanner.nextLine());
        }
        scanner.close();
        String[] data = al.toArray(new String[0]);
        int craftingIndex = 0;
        int i = 0;
        while (i < data.length) {
            line = data[i];
            if (!line.contains("=")) {
                craftingIndex = i;
                break;
            }
            ++i;
        }
        al = new ArrayList();
        if (craftingIndex == 0) {
            System.out.println("[BACKPACK] Recipe could not be created.");
            return;
        }
        i = craftingIndex;
        while (i < data.length) {
            String s = data[i];
            al.add(s);
            allChars = String.valueOf(allChars) + s;
            ++i;
        }
        backpackRecipe.shape(al.toArray(new String[0]));
        i = 0;
        while (i < craftingIndex) {
            line = data[i];
            String[] buf = line.split("=");
            String letter = buf[0].trim();
            String material = buf[1].trim();
            Material m = null;
            m = Material.matchMaterial((String)material);
            if (m == null) {
                try {
                    m = Material.getMaterial((int)Integer.parseInt(material));
                }
                catch (Exception e) {
                    System.out.println("[BACKPACK] Material \"" + material + "\" could not be found.");
                }
            }
            if (m == null) {
                System.out.println("[BACKPACK] Recipe could not be created.");
                return;
            }
            char c = letter.toCharArray()[0];
            if (letter.length() != 1) {
                System.out.println("[BACKPACK] WARNING: You should only use one character instead of multiple ones. \"" + c + "\" will be used instead of \"" + letter + "\".");
            }
            if (allChars.contains(String.valueOf(c))) {
                backpackRecipe.setIngredient(c, m);
            } else {
                System.out.println("[BACKPACK] WARNING: " + c + "(" + m.toString() + ") is unused.");
            }
            ++i;
        }
        server.addRecipe((Recipe)backpackRecipe);
    }
}

