/*
 * Decompiled with CFR 0.152.
 */
package karabin.backpack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import karabin.backpack.Backpack;
import karabin.backpack.BackpackHandler;
import karabin.backpack.Data;
import karabin.backpack.ItemHandler;
import karabin.backpack.Main;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EventListener
implements Listener {
    private FileConfiguration config;
    private Map<UUID, BackpackHandler> backpacks = new HashMap<UUID, BackpackHandler>();
    private ItemHandler ih;
    private Main main;

    public EventListener(FileConfiguration config, Main main) {
        this.main = main;
        this.config = config;
        this.ih = new ItemHandler(config);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCloseInventory(InventoryCloseEvent event) {
        if (event.getInventory().getSize() != 9 * Data.getRows()) {
            return;
        }
        if (!event.getInventory().getTitle().contains(Data.getBackpackName())) {
            return;
        }
        Player p = (Player)event.getPlayer();
        if (!this.backpacks.containsKey(p.getUniqueId())) {
            return;
        }
        this.ih.saveItemStackArray(p.getUniqueId(), this.backpacks.get(p.getUniqueId()).getInventory().getContents());
        this.main.saveInventorys();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerUse(PlayerInteractEvent event) {
        if (event.getItem() == null) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!event.getItem().hasItemMeta()) {
            return;
        }
        if (event.getItem().getItemMeta().getDisplayName() == null || !event.getItem().getItemMeta().getDisplayName().contains(Data.getBackpackColor()) || event.getItem().getDurability() != Backpack.getItemStack().getDurability()) {
            return;
        }
        Player player = event.getPlayer();
        this.openInventory(player);
        this.ih.saveItemStackArray(player.getUniqueId(), this.backpacks.get(player.getUniqueId()).getInventory().getContents());
        this.main.saveInventorys();
    }

    void openInventory(Player p) {
        if (!this.backpacks.containsKey(p.getUniqueId())) {
            this.loadBackpack(p);
        }
        p.openInventory(this.backpacks.get(p.getUniqueId()).getInventory());
    }

    private void loadBackpack(Player p) {
        ArrayList<ItemStack> al;
        Inventory inv = BackpackHandler.getCleanBackpack(p, Data.getRows());
        ItemStack[] content = new ItemStack[]{};
        if (this.config.contains(p.getUniqueId().toString())) {
            content = this.ih.loadItemStackArray(p.getUniqueId());
        } else if (this.config.contains(p.getName())) {
            content = this.ih.loadItemStackArray(p.getName());
            this.config.set(p.getName(), null);
        }
        if (content.length > inv.getSize()) {
            al = new ArrayList<ItemStack>(content.length);
            boolean stopDeletingNull = false;
            int i = content.length - 1;
            while (i >= 0) {
                if (content[i] != null || stopDeletingNull) {
                    stopDeletingNull = true;
                    al.add(content[i]);
                }
                --i;
            }
            content = new ItemStack[al.size()];
            i = 0;
            while (i < content.length) {
                content[i] = (ItemStack)al.get(content.length - i - 1);
                ++i;
            }
        }
        if (content.length > inv.getSize()) {
            al = new ArrayList(content.length);
            ItemStack[] itemStackArray = content;
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack is = itemStackArray[n2];
                if (is != null) {
                    al.add(is);
                }
                ++n2;
            }
            content = al.toArray(new ItemStack[0]);
        }
        if (content.length > inv.getSize()) {
            p.sendMessage("There were more item in your backpack that possible. If items could not fit into your inventory they have been dropped in front of you.");
            HashMap tooMuch = inv.addItem(content);
            tooMuch = p.getInventory().addItem(tooMuch.values().toArray(new ItemStack[0]));
            for (ItemStack is : tooMuch.values()) {
                p.getWorld().dropItem(p.getLocation(), is);
            }
        } else {
            inv.setContents(content);
        }
        this.backpacks.put(p.getUniqueId(), new BackpackHandler().setInventory(inv));
    }

    void save() {
        for (UUID u : this.backpacks.keySet()) {
            this.ih.saveItemStackArray(u, this.backpacks.get(u).getInventory().getContents());
        }
        this.main.saveInventorys();
    }
}

