/*
 * Decompiled with CFR 0.152.
 */
package net.cardinalcraft.firstconnect;

import net.cardinalcraft.firstconnect.DBHandler;
import net.cardinalcraft.firstconnect.FCMain;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CmdExec
implements CommandExecutor {
    private FCMain plugin;

    public CmdExec(FCMain plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("firstconnect")) {
            if (!sender.hasPermission("fc.lu")) {
                sender.sendMessage("No permission to lookup players!");
                return false;
            }
            if (args.length > 0) {
                String[] data;
                String playerName = args[0];
                try {
                    data = DBHandler.lookup(playerName);
                }
                catch (Exception e) {
                    this.plugin.getLogger().info("Something went wrong running a lookup.");
                    return false;
                }
                DateTime date = new DateTime();
                if (data.length > 0) {
                    String firstConnect = data[0];
                    String lastSeen = data[1];
                    String uuid = data[2];
                    String namechanges = data[3];
                    DateTimeFormatter formatter = DateTimeFormat.forPattern("dd/MM/yyyy HH:mm:ss");
                    if (firstConnect != null && !firstConnect.isEmpty()) {
                        DateTime firstConnectDate = formatter.parseDateTime(firstConnect);
                        int daysOld = Days.daysBetween(firstConnectDate.withTimeAtStartOfDay(), date.withTimeAtStartOfDay()).getDays();
                        sender.sendMessage(ChatColor.GRAY + "------- " + ChatColor.AQUA + data[4] + ChatColor.GRAY + " -------");
                        sender.sendMessage(ChatColor.DARK_GRAY + "Days since first connect: " + ChatColor.AQUA + "" + daysOld + ChatColor.DARK_GRAY + "");
                        sender.sendMessage(ChatColor.DARK_GRAY + "First connected: " + ChatColor.AQUA + firstConnect + "");
                        if (this.plugin.getServer().getPlayer(data[4]) != null) {
                            sender.sendMessage(ChatColor.DARK_GRAY + "Last seen: " + ChatColor.DARK_GREEN + "NOW");
                        } else {
                            sender.sendMessage(ChatColor.DARK_GRAY + "Last seen: " + ChatColor.AQUA + lastSeen);
                        }
                        if (!data[3].equalsIgnoreCase("0")) {
                            sender.sendMessage(ChatColor.DARK_GRAY + "Has changed name " + ChatColor.AQUA + namechanges + ChatColor.DARK_GRAY + " time(s)");
                        }
                        sender.sendMessage(ChatColor.DARK_GRAY + "UUID is " + ChatColor.AQUA + uuid + ChatColor.DARK_GRAY);
                        sender.sendMessage(ChatColor.GRAY + "------- " + ChatColor.AQUA + data[4] + ChatColor.GRAY + " -------");
                        return true;
                    }
                    sender.sendMessage("Player not found!");
                    return true;
                }
                sender.sendMessage("Player not found!");
                return true;
            }
            sender.sendMessage("Please enter the name of a player to lookup!");
            return false;
        }
        return false;
    }
}

