/*
 * Decompiled with CFR 0.152.
 */
package net.cardinalcraft.firstconnect;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.cardinalcraft.firstconnect.FCMain;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DBHandler {
    private static FCMain plugin = null;
    private static String CONNECTION = null;
    private static Properties p = new Properties();
    private static Boolean MySQL = false;

    public static boolean hasConnected(String uuid) throws Exception {
        Connection conn;
        if (!MySQL.booleanValue()) {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + "/FirstConnect.db");
        } else {
            conn = new DBHandler().Connect();
        }
        if (conn == null) {
            throw new Exception("Connection could not be opened.");
        }
        PreparedStatement stat = conn.prepareStatement("select * from " + DBHandler.plugin.table + " where uuid = ? LIMIT 1");
        stat.setString(1, uuid);
        ResultSet rs = stat.executeQuery();
        if (rs.next()) {
            rs.close();
            stat.close();
            conn.close();
            return true;
        }
        rs.close();
        stat.close();
        conn.close();
        return false;
    }

    public static String[] lookup(String name) throws Exception {
        PreparedStatement stat;
        Connection conn;
        if (!MySQL.booleanValue()) {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + "/FirstConnect.db");
        } else {
            conn = new DBHandler().Connect();
        }
        if (conn == null) {
            throw new Exception("Connection could not be opened.");
        }
        if (MySQL.booleanValue()) {
            stat = conn.prepareStatement("select * from " + DBHandler.plugin.table + " where LOWER(name) LIKE LOWER(?) LIMIT 1");
            stat.setString(1, "%" + name + "%");
        } else {
            stat = conn.prepareStatement("select * from " + DBHandler.plugin.table + " where name = ? COLLATE NOCASE LIMIT 1");
            stat.setString(1, name);
        }
        ResultSet rs = stat.executeQuery();
        String[] data = new String[]{"", "", "", "", ""};
        while (rs.next()) {
            data[0] = rs.getString("firstConnect");
            data[1] = rs.getString("lastSeen");
            data[2] = rs.getString("uuid");
            data[3] = "" + rs.getInt("namechanges");
            data[4] = rs.getString("name");
        }
        stat.close();
        rs.close();
        conn.close();
        return data;
    }

    public static String[] UUIDlookup(String uuid) throws Exception {
        Connection conn;
        if (!MySQL.booleanValue()) {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + "/FirstConnect.db");
        } else {
            conn = new DBHandler().Connect();
        }
        if (conn == null) {
            throw new Exception("Connection could not be opened.");
        }
        PreparedStatement stat = conn.prepareStatement("select * from " + DBHandler.plugin.table + " where uuid = ? LIMIT 1");
        stat.setString(1, uuid);
        ResultSet rs = stat.executeQuery();
        String[] data = new String[]{"", "", ""};
        while (rs.next()) {
            data[0] = rs.getString("firstConnect");
            data[1] = rs.getString("lastSeen");
            data[2] = rs.getString("name");
        }
        stat.close();
        rs.close();
        conn.close();
        return data;
    }

    public static void firstConnect(String name, String uuid, DateTime date) throws Exception {
        Connection conn;
        if (!MySQL.booleanValue()) {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + "/FirstConnect.db");
        } else {
            conn = new DBHandler().Connect();
        }
        if (conn == null) {
            throw new Exception("Connection could not be opened.");
        }
        PreparedStatement prep = conn.prepareStatement("insert into " + DBHandler.plugin.table + "(name, firstConnect, lastSeen, uuid, namechanges) values (?, ?, ?, ?, ?)");
        DateTimeFormatter formatter = DateTimeFormat.forPattern("dd/MM/yyyy HH:mm:ss");
        String firstConnect = formatter.print(date);
        prep.setString(1, name);
        prep.setString(2, firstConnect);
        prep.setString(3, firstConnect);
        prep.setString(4, uuid);
        prep.setInt(5, 0);
        prep.addBatch();
        conn.setAutoCommit(false);
        prep.executeBatch();
        conn.setAutoCommit(true);
        prep.close();
        conn.close();
    }

    public static void updateLastSeen(String name, String UUID, DateTime date) throws Exception {
        Connection conn;
        if (!MySQL.booleanValue()) {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + "/FirstConnect.db");
        } else {
            conn = new DBHandler().Connect();
        }
        if (conn == null) {
            throw new Exception("Connection could not be opened.");
        }
        PreparedStatement prep = conn.prepareStatement("update " + DBHandler.plugin.table + " set lastSeen = ? where uuid = ?");
        DateTimeFormatter formatter = DateTimeFormat.forPattern("dd/MM/yyyy HH:mm:ss");
        String lastSeen = formatter.print(date);
        prep.setString(1, lastSeen);
        prep.setString(2, UUID);
        prep.executeUpdate();
        conn.setAutoCommit(false);
        conn.commit();
        conn.setAutoCommit(true);
        prep.close();
        conn.close();
    }

    public static void importPlayer(String name, String uuid, String lastSeen, String firstConnect) throws Exception {
        Connection conn;
        if (!MySQL.booleanValue()) {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + "/FirstConnect.db");
        } else {
            conn = new DBHandler().Connect();
        }
        if (conn == null) {
            throw new Exception("Connection could not be opened.");
        }
        PreparedStatement prep = conn.prepareStatement("insert into " + DBHandler.plugin.table + "(name, firstConnect, lastSeen, uuid, namechanges) values (?, ?, ?, ?, ?)");
        prep.setString(1, name);
        prep.setString(2, firstConnect);
        prep.setString(3, lastSeen);
        prep.setString(4, uuid);
        prep.setInt(5, 0);
        prep.addBatch();
        conn.setAutoCommit(false);
        prep.executeBatch();
        conn.setAutoCommit(true);
        prep.close();
        conn.close();
    }

    public static List<String> getPlayers(String searchTerm) throws Exception {
        PreparedStatement stat;
        Connection conn;
        if (!MySQL.booleanValue()) {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + "/FirstConnect.db");
        } else {
            conn = new DBHandler().Connect();
        }
        if (conn == null) {
            throw new Exception("Connection could not be opened.");
        }
        if (searchTerm.isEmpty()) {
            stat = conn.prepareStatement("select * from " + DBHandler.plugin.table + "");
        } else {
            stat = conn.prepareStatement("select * from " + DBHandler.plugin.table + " where name like ?");
            stat.setString(1, "%" + searchTerm + "%");
        }
        ArrayList<String> playerReturn = new ArrayList<String>();
        ResultSet rs = stat.executeQuery();
        while (rs.next()) {
            playerReturn.add(rs.getString("name") + "," + rs.getString("lastSeen") + "," + rs.getString("firstConnect"));
        }
        stat.close();
        rs.close();
        conn.close();
        return playerReturn;
    }

    public static String[] getPlayersName() throws Exception {
        Connection conn;
        if (!MySQL.booleanValue()) {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + "/FirstConnect.db");
        } else {
            conn = new DBHandler().Connect();
        }
        if (conn == null) {
            throw new Exception("Connection could not be opened.");
        }
        PreparedStatement stat = conn.prepareStatement("select * from " + DBHandler.plugin.table + "");
        ArrayList<String> playerReturn = new ArrayList<String>();
        ResultSet rs = stat.executeQuery();
        while (rs.next()) {
            playerReturn.add(rs.getString("name"));
        }
        stat.close();
        rs.close();
        conn.close();
        return playerReturn.toArray(new String[playerReturn.size()]);
    }

    public static void updateUUID(String name, String UUID) throws Exception {
        Connection conn;
        if (!MySQL.booleanValue()) {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + "/FirstConnect.db");
        } else {
            conn = new DBHandler().Connect();
        }
        if (conn == null) {
            throw new Exception("Connection could not be opened.");
        }
        PreparedStatement prep = conn.prepareStatement("update " + DBHandler.plugin.table + " set uuid = ? where name = ?");
        prep.setString(1, UUID);
        prep.setString(2, name);
        prep.addBatch();
        conn.setAutoCommit(false);
        prep.executeBatch();
        conn.setAutoCommit(true);
        prep.close();
        conn.close();
    }

    public static void updateName(String name, String UUID) throws Exception {
        Connection conn;
        if (!MySQL.booleanValue()) {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:" + plugin.getDataFolder().getAbsolutePath() + "/FirstConnect.db");
        } else {
            conn = new DBHandler().Connect();
        }
        if (conn == null) {
            throw new Exception("Connection could not be opened.");
        }
        PreparedStatement prep = conn.prepareStatement("update " + DBHandler.plugin.table + " set name = ? where uuid = ?");
        prep.setString(1, name);
        prep.setString(2, UUID);
        prep.addBatch();
        conn.setAutoCommit(false);
        prep.executeBatch();
        conn.setAutoCommit(true);
        prep.close();
        prep = conn.prepareStatement("update " + DBHandler.plugin.table + " set namechanges = namechanges+1 where uuid = ?");
        prep.setString(1, UUID);
        prep.executeUpdate();
        prep.close();
        conn.close();
    }

    public Connection Connect() throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.jdbc.Driver");
        Connection c = DriverManager.getConnection(CONNECTION, p);
        return c;
    }

    public static void initiate(FCMain pl) {
        plugin = pl;
        if (pl.MySQL) {
            MySQL = pl.MySQL;
            p.put("user", DBHandler.plugin.user);
            p.put("password", DBHandler.plugin.pass);
            CONNECTION = "jdbc:mysql://" + DBHandler.plugin.host + "/" + DBHandler.plugin.db + "";
        }
    }
}

