/*
 * Decompiled with CFR 0.152.
 */
package net.cardinalcraft.firstconnect;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import net.cardinalcraft.firstconnect.AccountsClient.profiles.HttpProfileRepository;
import net.cardinalcraft.firstconnect.AccountsClient.profiles.Profile;
import net.cardinalcraft.firstconnect.CmdExec;
import net.cardinalcraft.firstconnect.DBHandler;
import net.cardinalcraft.firstconnect.FirstTabComplete;
import net.cardinalcraft.firstconnect.LoginListener;
import net.cardinalcraft.firstconnect.mcstats.Metrics;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class FCMain
extends JavaPlugin {
    private final LoginListener listen = new LoginListener(this);
    boolean MySQL = false;
    protected String host;
    protected String user;
    protected String pass;
    protected String db;
    protected String table = "players";
    protected boolean freshDB = false;
    protected Metrics metrics;

    public void onEnable() {
        boolean firstRun = false;
        this.getServer().getPluginManager().registerEvents((Listener)this.listen, (Plugin)this);
        this.getCommand("firstconnect").setExecutor((CommandExecutor)new CmdExec(this));
        this.getCommand("firstconnect").setTabCompleter((TabCompleter)new FirstTabComplete(this));
        PluginDescriptionFile pdfFile = this.getDescription();
        this.getLogger().info("enabled. (version " + pdfFile.getVersion() + ")");
        this.loadConfig();
        DBHandler.initiate(this);
        if (this.MySQL) {
            this.getLogger().info("Attempting to connect to MySQL server.");
            try {
                Connection x = new DBHandler().Connect();
                this.getLogger().info("Success!");
            }
            catch (Exception e) {
                this.getLogger().info("Problem contacting database, check config!");
                this.getPluginLoader().disablePlugin((Plugin)this);
            }
        }
        try {
            File file;
            if (!this.getDataFolder().exists() && !this.getDataFolder().mkdir()) {
                this.getLogger().info("Error making plugin directory!");
                this.getPluginLoader().disablePlugin((Plugin)this);
            }
            if (!this.MySQL && !(file = new File(this.getDataFolder(), "FirstConnect.db")).isFile()) {
                this.getLogger().info("Database not found, generating empty file.");
                firstRun = true;
            }
            this.prepareDB();
        }
        catch (Exception e) {
            this.getLogger().info("Something went wrong trying to find the database.");
            this.getPluginLoader().disablePlugin((Plugin)this);
        }
        if (firstRun || this.freshDB) {
            try {
                this.getLogger().info("Importing players from world. This may take a while.");
                this.findExistingPlayers();
            }
            catch (Exception e) {
                this.getLogger().info("Something went wrong trying to import old players.");
            }
        }
        try {
            this.metrics = new Metrics((Plugin)this);
            Metrics.Graph pluginVer = this.metrics.createGraph("MySQL Enabled");
            if (this.MySQL) {
                pluginVer.addPlotter(new Metrics.Plotter("True"){

                    @Override
                    public int getValue() {
                        return 1;
                    }
                });
            } else {
                pluginVer.addPlotter(new Metrics.Plotter("False"){

                    @Override
                    public int getValue() {
                        return 1;
                    }
                });
            }
            this.metrics.start();
        }
        catch (IOException e) {
            this.getLogger().info("Something went wrong sending metric data. You can probably ignore this.");
        }
    }

    public void onDisable() {
        HandlerList.unregisterAll();
        this.getCommand("firstconnect").setExecutor(null);
        try {
            this.metrics.disable();
        }
        catch (IOException e) {
            // empty catch block
        }
        PluginDescriptionFile pdfFile = this.getDescription();
        this.getLogger().info("disabled. (version " + pdfFile.getVersion() + ")");
    }

    private void loadConfig() {
        this.getConfig().options().copyDefaults(true);
        this.getConfig().options().header("Do not mess with the 'freshdb' field unless you know what it does.");
        this.getConfig().options().copyHeader();
        this.saveConfig();
        this.MySQL = this.getConfig().getBoolean("mysql.enabled");
        if (this.MySQL) {
            this.host = this.getConfig().getString("mysql.host");
            this.db = this.getConfig().getString("mysql.database");
            this.user = this.getConfig().getString("mysql.username");
            this.pass = this.getConfig().getString("mysql.password");
            this.table = this.getConfig().getString("mysql.tablename");
            this.freshDB = this.getConfig().getBoolean("mysql.freshdb");
        }
    }

    private void prepareDB() throws Exception {
        Connection conn;
        if (!this.MySQL) {
            Class.forName("org.sqlite.JDBC");
            conn = DriverManager.getConnection("jdbc:sqlite:" + this.getDataFolder().getAbsolutePath() + "/FirstConnect.db");
        } else {
            conn = new DBHandler().Connect();
        }
        Statement stat = conn.createStatement();
        if (!this.MySQL) {
            stat.executeUpdate("create table if not exists players (_id INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT, uuid TEXT, namechanges NUMERIC, firstConnect TEXT, lastSeen TEXT);");
        } else {
            stat.executeUpdate("CREATE TABLE IF NOT EXISTS `" + this.table + "` (" + "  `id` int(8) NOT NULL AUTO_INCREMENT," + "  `name` varchar(32) NOT NULL," + "  `uuid` varchar(64) NOT NULL," + "  `namechanges` int(8) NOT NULL," + "  `firstConnect` varchar(32) NOT NULL," + "  `lastSeen` varchar(32) NOT NULL," + "  PRIMARY KEY (`id`)" + ") ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;");
        }
        stat.close();
        if (!this.MySQL) {
            ResultSet x;
            try {
                x = stat.executeQuery("select uuid from players");
            }
            catch (Exception e) {
                this.getLogger().info("UUID Column does not exist, adding.");
                stat.executeUpdate("ALTER TABLE players ADD uuid TEXT");
                this.getLogger().info("Attempting to match players to their ID, this may take a while.");
                this.matchUUIDs();
            }
            try {
                x = stat.executeQuery("select namechanges from players");
            }
            catch (Exception e) {
                this.getLogger().info("Namechange column does not exist, adding.");
                stat.executeUpdate("ALTER TABLE players ADD namechanges INTEGER DEFAULT 0");
            }
        }
        stat.close();
        conn.close();
    }

    private void findExistingPlayers() throws Exception {
        String iPlayers = "";
        String[] names = new String[this.getServer().getOfflinePlayers().length];
        int i = 0;
        int j = 0;
        for (OfflinePlayer q : this.getServer().getOfflinePlayers()) {
            names[j] = q.getName();
            ++j;
        }
        HttpProfileRepository v = new HttpProfileRepository("minecraft");
        Profile[] x = v.findProfilesByNames(names);
        this.getLogger().info(x.length + " profiles returned from Mojang UUID API.");
        for (OfflinePlayer p : this.getServer().getOfflinePlayers()) {
            DateTimeFormatter formatter = DateTimeFormat.forPattern("dd/MM/yyyy HH:mm:ss");
            DateTime firstPlayed = new DateTime(p.getFirstPlayed());
            DateTime lastSeen = new DateTime(p.getLastPlayed());
            String firstPlayedOut = formatter.print(firstPlayed);
            String lastSeenOut = formatter.print(lastSeen);
            for (Profile z : x) {
                if (!z.getName().equalsIgnoreCase(p.getName())) continue;
                String uuid = z.getId();
                try {
                    DBHandler.importPlayer(p.getName(), uuid, lastSeenOut, firstPlayedOut);
                    if (iPlayers.isEmpty()) {
                        iPlayers = p.getName();
                        ++i;
                        continue;
                    }
                    iPlayers = iPlayers + ", " + p.getName();
                    ++i;
                }
                catch (Exception e) {
                    this.getLogger().info("There was a problem importing existing players");
                    this.getPluginLoader().disablePlugin((Plugin)this);
                }
            }
        }
        if (i > 50) {
            this.getLogger().info("Imported: " + i + " players (suppressed big output)");
        } else {
            this.getLogger().info("Imported: " + iPlayers);
        }
        if (this.MySQL) {
            this.getConfig().set("mysql.freshdb", (Object)false);
            this.saveConfig();
            this.freshDB = false;
        }
    }

    private void matchUUIDs() {
        int i = 0;
        try {
            String[] players = DBHandler.getPlayersName();
            HttpProfileRepository v = new HttpProfileRepository("minecraft");
            Profile[] x = v.findProfilesByNames(players);
            this.getLogger().info(x.length + " profiles returned from Mojang UUID API.");
            for (Profile p : x) {
                try {
                    DBHandler.updateUUID(p.getName(), p.getId());
                }
                catch (Exception e) {
                    this.getLogger().info("Problem importing UUID");
                    this.getPluginLoader().disablePlugin((Plugin)this);
                }
                ++i;
            }
            this.getLogger().info(i + " uuids updated.");
        }
        catch (Exception e) {
            this.getLogger().info("Problem getting players");
            this.getPluginLoader().disablePlugin((Plugin)this);
        }
    }
}

