/*
 * Decompiled with CFR 0.152.
 */
package net.cardinalcraft.firstconnect;

import net.cardinalcraft.firstconnect.AccountsClient.profiles.HttpProfileRepository;
import net.cardinalcraft.firstconnect.AccountsClient.profiles.Profile;
import net.cardinalcraft.firstconnect.DBHandler;
import net.cardinalcraft.firstconnect.FCMain;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.joda.time.DateTime;

public class LoginListener
implements Listener {
    private FCMain plugin;

    public LoginListener(FCMain instance) {
        this.plugin = instance;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        String playerName = event.getPlayer().getName();
        String uuid = "";
        try {
            HttpProfileRepository v = new HttpProfileRepository("minecraft");
            Profile[] x = v.findProfilesByNames(playerName);
            uuid = x[0].getId();
            uuid = uuid.replace("-", "");
        }
        catch (Exception e) {
            this.plugin.getLogger().info("Failed to get UUID from Mojang!");
            uuid = event.getPlayer().getUniqueId().toString();
            this.plugin.getLogger().info("UUID from Bukkit: " + uuid);
            uuid = uuid.replace("-", "");
        }
        DateTime now = new DateTime();
        try {
            if (uuid.isEmpty()) {
                this.plugin.getLogger().info("Error getting UUID");
                return;
            }
            if (DBHandler.hasConnected(uuid)) {
                DBHandler.updateLastSeen(playerName, uuid, now);
                String[] q = DBHandler.UUIDlookup(uuid);
                if (!q[2].equalsIgnoreCase(playerName)) {
                    this.plugin.getLogger().info(playerName + " has connected before with a different name, updating.");
                    DBHandler.updateName(playerName, uuid);
                }
            } else {
                DBHandler.firstConnect(playerName, uuid, now);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().info("Failed to check database!");
            this.plugin.getPluginLoader().disablePlugin((Plugin)this.plugin);
        }
    }

    @EventHandler
    public void onPlayerDisconnect(PlayerQuitEvent event) {
        DateTime now = new DateTime();
        String playerName = event.getPlayer().getName();
        String uuid = "";
        try {
            HttpProfileRepository v = new HttpProfileRepository("minecraft");
            Profile[] x = v.findProfilesByNames(playerName);
            uuid = x[0].getId();
            uuid = uuid.replace("-", "");
        }
        catch (Exception e) {
            this.plugin.getLogger().info("Failed to get UUID from Mojang!");
            uuid = event.getPlayer().getUniqueId().toString();
            this.plugin.getLogger().info("UUID from Bukkit: " + uuid);
            uuid = uuid.replace("-", "");
        }
        if (uuid.isEmpty()) {
            this.plugin.getLogger().info("Error getting UUID");
            return;
        }
        try {
            if (DBHandler.hasConnected(uuid)) {
                DBHandler.updateLastSeen(playerName, uuid, now);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().info("Failed to check database!");
            this.plugin.getPluginLoader().disablePlugin((Plugin)this.plugin);
        }
    }
}

