/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.error;

import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.reflect.PrettyPrinter;
import java.io.PrintStream;
import org.bukkit.plugin.Plugin;

public class BasicErrorReporter
implements ErrorReporter {
    private final PrintStream output;

    public BasicErrorReporter() {
        this(System.err);
    }

    public BasicErrorReporter(PrintStream output) {
        this.output = output;
    }

    @Override
    public void reportMinimal(Plugin sender, String methodName, Throwable error) {
        this.output.println("Unhandled exception occured in " + methodName + " for " + sender.getName());
        error.printStackTrace(this.output);
    }

    @Override
    public void reportMinimal(Plugin sender, String methodName, Throwable error, Object ... parameters) {
        this.reportMinimal(sender, methodName, error);
        this.printParameters(parameters);
    }

    @Override
    public void reportDebug(Object sender, Report report) {
    }

    @Override
    public void reportDebug(Object sender, Report.ReportBuilder builder) {
    }

    @Override
    public void reportWarning(Object sender, Report report) {
        this.output.println("[" + sender.getClass().getSimpleName() + "] " + report.getReportMessage());
        if (report.getException() != null) {
            report.getException().printStackTrace(this.output);
        }
        this.printParameters(report.getCallerParameters());
    }

    @Override
    public void reportWarning(Object sender, Report.ReportBuilder reportBuilder) {
        this.reportWarning(sender, reportBuilder.build());
    }

    @Override
    public void reportDetailed(Object sender, Report report) {
        this.reportWarning(sender, report);
    }

    @Override
    public void reportDetailed(Object sender, Report.ReportBuilder reportBuilder) {
        this.reportWarning(sender, reportBuilder);
    }

    private void printParameters(Object[] parameters) {
        if (parameters != null && parameters.length > 0) {
            this.output.println("Parameters: ");
            try {
                for (Object parameter : parameters) {
                    if (parameter == null) {
                        this.output.println("[NULL]");
                        continue;
                    }
                    this.output.println(PrettyPrinter.printObject(parameter));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

