/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketOutputHandler;
import com.comphenix.protocol.utility.ByteBufferInputStream;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.StreamSerializer;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;

public abstract class NetworkMarker {
    private PriorityQueue<PacketOutputHandler> outputHandlers;
    private ByteBuffer inputBuffer;
    private final ConnectionSide side;
    private final PacketType type;
    private StreamSerializer serializer;

    public NetworkMarker(@Nonnull ConnectionSide side, ByteBuffer inputBuffer, PacketType type) {
        this.side = (ConnectionSide)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"side cannot be NULL."));
        this.inputBuffer = inputBuffer;
        this.type = type;
    }

    public NetworkMarker(@Nonnull ConnectionSide side, byte[] inputBuffer, PacketType type) {
        this.side = (ConnectionSide)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"side cannot be NULL."));
        this.type = type;
        if (inputBuffer != null) {
            this.inputBuffer = ByteBuffer.wrap(inputBuffer);
        }
    }

    public ConnectionSide getSide() {
        return this.side;
    }

    public StreamSerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new StreamSerializer();
        }
        return this.serializer;
    }

    public ByteBuffer getInputBuffer() {
        return this.getInputBuffer(true);
    }

    public ByteBuffer getInputBuffer(boolean excludeHeader) {
        if (this.side.isForServer()) {
            throw new IllegalStateException("Server-side packets have no input buffer.");
        }
        if (this.inputBuffer != null) {
            ByteBuffer result = this.inputBuffer.asReadOnlyBuffer();
            try {
                result = excludeHeader ? this.skipHeader(result) : this.addHeader(result, this.type);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot skip packet header.", e);
            }
            return result;
        }
        return null;
    }

    public DataInputStream getInputStream() {
        return this.getInputStream(true);
    }

    public DataInputStream getInputStream(boolean excludeHeader) {
        if (this.side.isForServer()) {
            throw new IllegalStateException("Server-side packets have no input buffer.");
        }
        if (this.inputBuffer == null) {
            return null;
        }
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.inputBuffer.array()));
        try {
            input = excludeHeader ? this.skipHeader(input) : this.addHeader(input, this.type);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot skip packet header.", e);
        }
        return input;
    }

    public boolean requireOutputHeader() {
        return MinecraftReflection.isUsingNetty();
    }

    public boolean addOutputHandler(@Nonnull PacketOutputHandler handler) {
        this.checkServerSide();
        Preconditions.checkNotNull((Object)handler, (Object)"handler cannot be NULL.");
        if (this.outputHandlers == null) {
            this.outputHandlers = new PriorityQueue<PacketOutputHandler>(10, new Comparator<PacketOutputHandler>(){

                @Override
                public int compare(PacketOutputHandler o1, PacketOutputHandler o2) {
                    return Ints.compare((int)o1.getPriority().getSlot(), (int)o2.getPriority().getSlot());
                }
            });
        }
        return this.outputHandlers.add(handler);
    }

    public boolean removeOutputHandler(@Nonnull PacketOutputHandler handler) {
        this.checkServerSide();
        Preconditions.checkNotNull((Object)handler, (Object)"handler cannot be NULL.");
        if (this.outputHandlers != null) {
            return this.outputHandlers.remove(handler);
        }
        return false;
    }

    @Nonnull
    public Collection<PacketOutputHandler> getOutputHandlers() {
        if (this.outputHandlers != null) {
            return this.outputHandlers;
        }
        return Collections.emptyList();
    }

    private void checkServerSide() {
        if (this.side.isForClient()) {
            throw new IllegalStateException("Must be a server side packet.");
        }
    }

    protected ByteBuffer skipHeader(ByteBuffer buffer) throws IOException {
        this.skipHeader(new DataInputStream(new ByteBufferInputStream(buffer)));
        return buffer;
    }

    protected abstract DataInputStream skipHeader(DataInputStream var1) throws IOException;

    protected abstract ByteBuffer addHeader(ByteBuffer var1, PacketType var2);

    protected abstract DataInputStream addHeader(DataInputStream var1, PacketType var2);

    public static boolean hasOutputHandlers(NetworkMarker marker) {
        return marker != null && !marker.getOutputHandlers().isEmpty();
    }

    public static byte[] getByteBuffer(NetworkMarker marker) {
        ByteBuffer buffer;
        if (marker != null && (buffer = marker.getInputBuffer()) != null) {
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data, 0, data.length);
            return data;
        }
        return null;
    }

    public static NetworkMarker getNetworkMarker(PacketEvent event) {
        return event.networkMarker;
    }

    public static class EmptyBufferMarker
    extends NetworkMarker {
        public EmptyBufferMarker(@Nonnull ConnectionSide side) {
            super(side, (byte[])null, null);
        }

        @Override
        protected DataInputStream skipHeader(DataInputStream input) throws IOException {
            throw new IllegalStateException("Buffer is empty.");
        }

        @Override
        protected ByteBuffer addHeader(ByteBuffer buffer, PacketType type) {
            throw new IllegalStateException("Buffer is empty.");
        }

        @Override
        protected DataInputStream addHeader(DataInputStream input, PacketType type) {
            throw new IllegalStateException("Buffer is empty.");
        }
    }
}

