/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.concurrency.IntegerSet;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import org.bukkit.Bukkit;

class LoginPackets {
    private IntegerSet clientSide = new IntegerSet(256);
    private IntegerSet serverSide = new IntegerSet(256);

    public LoginPackets(MinecraftVersion version) {
        this.clientSide.add(2);
        this.serverSide.add(253);
        this.clientSide.add(252);
        this.serverSide.add(252);
        this.clientSide.add(205);
        this.serverSide.add(1);
        this.clientSide.add(254);
        if (version.compareTo(MinecraftVersion.HORSE_UPDATE) >= 0) {
            this.clientSide.add(250);
        }
        this.serverSide.add(255);
        if (LoginPackets.isMCPC()) {
            this.clientSide.add(250);
        }
    }

    private static boolean isMCPC() {
        return Bukkit.getServer().getVersion().contains("MCPC-Plus");
    }

    @Deprecated
    public boolean isLoginPacket(int packetId, ConnectionSide side) {
        switch (side) {
            case CLIENT_SIDE: {
                return this.clientSide.contains(packetId);
            }
            case SERVER_SIDE: {
                return this.serverSide.contains(packetId);
            }
            case BOTH: {
                return this.clientSide.contains(packetId) || this.serverSide.contains(packetId);
            }
        }
        throw new IllegalArgumentException("Unknown connection side: " + (Object)((Object)side));
    }

    public boolean isLoginPacket(PacketType type) {
        if (!MinecraftReflection.isUsingNetty()) {
            return this.isLoginPacket(type.getLegacyId(), type.getSender().toSide());
        }
        return PacketType.Login.Client.getInstance().hasMember(type) || PacketType.Login.Server.getInstance().hasMember(type) || PacketType.Status.Client.getInstance().hasMember(type) || PacketType.Status.Server.getInstance().hasMember(type);
    }
}

