/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.net.sf.cglib.proxy.Enhancer;
import com.comphenix.net.sf.cglib.proxy.MethodInterceptor;
import com.comphenix.net.sf.cglib.proxy.MethodProxy;
import com.comphenix.protocol.AsynchronousManager;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.async.AsyncFilterManager;
import com.comphenix.protocol.async.AsyncMarker;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.DelayedSingleTask;
import com.comphenix.protocol.injector.EntityUtilities;
import com.comphenix.protocol.injector.GamePhase;
import com.comphenix.protocol.injector.InternalManager;
import com.comphenix.protocol.injector.ListenerInvoker;
import com.comphenix.protocol.injector.LoginPackets;
import com.comphenix.protocol.injector.PacketConstructor;
import com.comphenix.protocol.injector.PacketFilterBuilder;
import com.comphenix.protocol.injector.PluginVerifier;
import com.comphenix.protocol.injector.SortedPacketListenerList;
import com.comphenix.protocol.injector.netty.NettyProtocolInjector;
import com.comphenix.protocol.injector.packet.InterceptWritePacket;
import com.comphenix.protocol.injector.packet.PacketInjector;
import com.comphenix.protocol.injector.packet.PacketInjectorBuilder;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.injector.player.PlayerInjectionHandler;
import com.comphenix.protocol.injector.player.PlayerInjector;
import com.comphenix.protocol.injector.player.PlayerInjectorBuilder;
import com.comphenix.protocol.injector.spigot.SpigotPacketInjector;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.utility.EnhancerFactory;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class PacketFilterManager
implements ProtocolManager,
ListenerInvoker,
InternalManager {
    public static final ReportType REPORT_CANNOT_LOAD_PACKET_LIST = new ReportType("Cannot load server and client packet list.");
    public static final ReportType REPORT_CANNOT_INITIALIZE_PACKET_INJECTOR = new ReportType("Unable to initialize packet injector");
    public static final ReportType REPORT_PLUGIN_DEPEND_MISSING = new ReportType("%s doesn't depend on ProtocolLib. Check that its plugin.yml has a 'depend' directive.");
    public static final ReportType REPORT_UNSUPPORTED_SERVER_PACKET_ID = new ReportType("[%s] Unsupported server packet ID in current Minecraft version: %s");
    public static final ReportType REPORT_UNSUPPORTED_CLIENT_PACKET_ID = new ReportType("[%s] Unsupported client packet ID in current Minecraft version: %s");
    public static final ReportType REPORT_CANNOT_UNINJECT_PLAYER = new ReportType("Unable to uninject net handler for player.");
    public static final ReportType REPORT_CANNOT_UNINJECT_OFFLINE_PLAYER = new ReportType("Unable to uninject logged off player.");
    public static final ReportType REPORT_CANNOT_INJECT_PLAYER = new ReportType("Unable to inject player.");
    public static final ReportType REPORT_CANNOT_UNREGISTER_PLUGIN = new ReportType("Unable to handle disabled plugin.");
    public static final ReportType REPORT_PLUGIN_VERIFIER_ERROR = new ReportType("Verifier error: %s");
    public static final int TICKS_PER_SECOND = 20;
    private static final int UNHOOK_DELAY = 100;
    private DelayedSingleTask unhookTask;
    private Set<PacketListener> packetListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private PacketInjector packetInjector;
    private PlayerInjectionHandler playerInjection;
    private InterceptWritePacket interceptWritePacket;
    private volatile Set<PacketType> inputBufferedPackets = Sets.newHashSet();
    private SortedPacketListenerList recievedListeners;
    private SortedPacketListenerList sendingListeners;
    private volatile boolean hasClosed;
    private ClassLoader classLoader;
    private ErrorReporter reporter;
    private Server server;
    private AsyncFilterManager asyncFilterManager;
    private boolean knowsServerPackets;
    private boolean knowsClientPackets;
    private AtomicInteger phaseLoginCount = new AtomicInteger(0);
    private AtomicInteger phasePlayingCount = new AtomicInteger(0);
    private AtomicBoolean packetCreation = new AtomicBoolean();
    private SpigotPacketInjector spigotInjector;
    private NettyProtocolInjector nettyInjector;
    private PluginVerifier pluginVerifier;
    private boolean hasRecycleDistance = true;
    private MinecraftVersion minecraftVersion;
    private LoginPackets loginPackets;
    private boolean debug;

    public PacketFilterManager(PacketFilterBuilder builder) {
        Predicate<GamePhase> isInjectionNecessary = new Predicate<GamePhase>(){

            public boolean apply(@Nullable GamePhase phase) {
                boolean result = true;
                if (phase.hasLogin()) {
                    result &= PacketFilterManager.this.getPhaseLoginCount() > 0;
                }
                if (phase.hasPlaying()) {
                    result &= PacketFilterManager.this.getPhasePlayingCount() > 0 || PacketFilterManager.this.unhookTask.isRunning();
                }
                return result;
            }
        };
        this.recievedListeners = new SortedPacketListenerList();
        this.sendingListeners = new SortedPacketListenerList();
        this.unhookTask = builder.getUnhookTask();
        this.server = builder.getServer();
        this.classLoader = builder.getClassLoader();
        this.reporter = builder.getReporter();
        try {
            this.pluginVerifier = new PluginVerifier(builder.getLibrary());
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_PLUGIN_VERIFIER_ERROR).messageParam(e.getMessage()).error(e));
        }
        this.minecraftVersion = builder.getMinecraftVersion();
        this.loginPackets = new LoginPackets(this.minecraftVersion);
        this.interceptWritePacket = new InterceptWritePacket(this.reporter);
        if (MinecraftReflection.isUsingNetty()) {
            this.nettyInjector = new NettyProtocolInjector(builder.getLibrary(), this, this.reporter);
            this.playerInjection = this.nettyInjector.getPlayerInjector();
            this.packetInjector = this.nettyInjector.getPacketInjector();
        } else if (builder.isNettyEnabled()) {
            this.spigotInjector = new SpigotPacketInjector(this.reporter, this, this.server);
            this.playerInjection = this.spigotInjector.getPlayerHandler();
            this.packetInjector = this.spigotInjector.getPacketInjector();
            this.spigotInjector.setProxyPacketInjector(PacketInjectorBuilder.newBuilder().invoker(this).reporter(this.reporter).playerInjection(this.playerInjection).buildInjector());
        } else {
            this.playerInjection = PlayerInjectorBuilder.newBuilder().invoker(this).server(this.server).reporter(this.reporter).packetListeners(this.packetListeners).injectionFilter(isInjectionNecessary).version(builder.getMinecraftVersion()).buildHandler();
            this.packetInjector = PacketInjectorBuilder.newBuilder().invoker(this).reporter(this.reporter).playerInjection(this.playerInjection).buildInjector();
        }
        this.asyncFilterManager = builder.getAsyncManager();
        try {
            this.knowsServerPackets = PacketRegistry.getClientPacketTypes() != null;
            this.knowsClientPackets = PacketRegistry.getServerPacketTypes() != null;
        }
        catch (FieldAccessException e) {
            this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_LOAD_PACKET_LIST).error(e));
        }
    }

    public static PacketFilterBuilder newBuilder() {
        return new PacketFilterBuilder();
    }

    @Override
    public MinecraftVersion getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Override
    public AsynchronousManager getAsynchronousManager() {
        return this.asyncFilterManager;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
        if (this.nettyInjector != null) {
            this.nettyInjector.setDebug(debug);
        }
    }

    @Override
    public PlayerInjectHooks getPlayerHook() {
        return this.playerInjection.getPlayerHook();
    }

    @Override
    public void setPlayerHook(PlayerInjectHooks playerHook) {
        this.playerInjection.setPlayerHook(playerHook);
    }

    @Override
    public ImmutableSet<PacketListener> getPacketListeners() {
        return ImmutableSet.copyOf(this.packetListeners);
    }

    @Override
    public InterceptWritePacket getInterceptWritePacket() {
        return this.interceptWritePacket;
    }

    private void printPluginWarnings(Plugin plugin) {
        if (this.pluginVerifier == null) {
            return;
        }
        try {
            switch (this.pluginVerifier.verify(plugin)) {
                case NO_DEPEND: {
                    this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_PLUGIN_DEPEND_MISSING).messageParam(plugin.getName()));
                }
            }
        }
        catch (Exception e) {
            this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_PLUGIN_VERIFIER_ERROR).messageParam(e.getMessage()));
        }
    }

    @Override
    public void addPacketListener(PacketListener listener) {
        boolean hasReceiving;
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be NULL.");
        }
        if (this.packetListeners.contains(listener)) {
            return;
        }
        this.printPluginWarnings(listener.getPlugin());
        ListeningWhitelist sending = listener.getSendingWhitelist();
        ListeningWhitelist receiving = listener.getReceivingWhitelist();
        boolean hasSending = sending != null && sending.isEnabled();
        boolean bl = hasReceiving = receiving != null && receiving.isEnabled();
        if (hasSending || hasReceiving) {
            if (hasSending) {
                if (sending.getOptions().contains((Object)ListenerOptions.INTERCEPT_INPUT_BUFFER)) {
                    throw new IllegalArgumentException("Sending whitelist cannot require input bufferes to be intercepted.");
                }
                PacketFilterManager.verifyWhitelist(listener, sending);
                this.sendingListeners.addListener(listener, sending);
                this.enablePacketFilters(listener, sending.getTypes());
                this.playerInjection.checkListener(listener);
            }
            if (hasSending) {
                this.incrementPhases(this.processPhase(sending, ConnectionSide.SERVER_SIDE));
            }
            if (hasReceiving) {
                PacketFilterManager.verifyWhitelist(listener, receiving);
                this.recievedListeners.addListener(listener, receiving);
                this.enablePacketFilters(listener, receiving.getTypes());
            }
            if (hasReceiving) {
                this.incrementPhases(this.processPhase(receiving, ConnectionSide.CLIENT_SIDE));
            }
            this.packetListeners.add(listener);
            this.updateRequireInputBuffers();
        }
    }

    private GamePhase processPhase(ListeningWhitelist whitelist, ConnectionSide side) {
        if (!whitelist.getGamePhase().hasLogin() && !whitelist.getOptions().contains((Object)ListenerOptions.DISABLE_GAMEPHASE_DETECTION)) {
            for (PacketType type : whitelist.getTypes()) {
                if (!this.loginPackets.isLoginPacket(type)) continue;
                return GamePhase.BOTH;
            }
        }
        return whitelist.getGamePhase();
    }

    private void updateRequireInputBuffers() {
        HashSet updated = Sets.newHashSet();
        for (PacketListener listener : this.packetListeners) {
            ListeningWhitelist whitelist = listener.getReceivingWhitelist();
            if (!whitelist.getOptions().contains((Object)ListenerOptions.INTERCEPT_INPUT_BUFFER)) continue;
            for (PacketType type : whitelist.getTypes()) {
                updated.add(type);
            }
        }
        this.inputBufferedPackets = updated;
        this.packetInjector.inputBuffersChanged(updated);
    }

    private void incrementPhases(GamePhase phase) {
        if (phase.hasLogin()) {
            this.phaseLoginCount.incrementAndGet();
        }
        if (phase.hasPlaying() && this.phasePlayingCount.incrementAndGet() == 1) {
            if (this.unhookTask.isRunning()) {
                this.unhookTask.cancel();
            } else {
                this.initializePlayers(this.server.getOnlinePlayers());
            }
        }
    }

    private void decrementPhases(GamePhase phase) {
        if (phase.hasLogin()) {
            this.phaseLoginCount.decrementAndGet();
        }
        if (phase.hasPlaying() && this.phasePlayingCount.decrementAndGet() == 0) {
            this.unhookTask.schedule(100L, new Runnable(){

                @Override
                public void run() {
                    PacketFilterManager.this.uninitializePlayers(PacketFilterManager.this.server.getOnlinePlayers());
                }
            });
        }
    }

    public static void verifyWhitelist(PacketListener listener, ListeningWhitelist whitelist) {
        for (PacketType type : whitelist.getTypes()) {
            if (type != null) continue;
            throw new IllegalArgumentException(String.format("Packet type in in listener %s was NULL.", PacketAdapter.getPluginName(listener)));
        }
    }

    @Override
    public void removePacketListener(PacketListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be NULL");
        }
        List<PacketType> sendingRemoved = null;
        List<PacketType> receivingRemoved = null;
        ListeningWhitelist sending = listener.getSendingWhitelist();
        ListeningWhitelist receiving = listener.getReceivingWhitelist();
        if (!this.packetListeners.remove(listener)) {
            return;
        }
        if (sending != null && sending.isEnabled()) {
            sendingRemoved = this.sendingListeners.removeListener(listener, sending);
            this.decrementPhases(this.processPhase(sending, ConnectionSide.SERVER_SIDE));
        }
        if (receiving != null && receiving.isEnabled()) {
            receivingRemoved = this.recievedListeners.removeListener(listener, receiving);
            this.decrementPhases(this.processPhase(receiving, ConnectionSide.CLIENT_SIDE));
        }
        if (sendingRemoved != null && sendingRemoved.size() > 0) {
            this.disablePacketFilters(ConnectionSide.SERVER_SIDE, sendingRemoved);
        }
        if (receivingRemoved != null && receivingRemoved.size() > 0) {
            this.disablePacketFilters(ConnectionSide.CLIENT_SIDE, receivingRemoved);
        }
        this.updateRequireInputBuffers();
    }

    @Override
    public void removePacketListeners(Plugin plugin) {
        for (PacketListener listener : this.packetListeners) {
            if (!Objects.equal((Object)listener.getPlugin(), (Object)plugin)) continue;
            this.removePacketListener(listener);
        }
        this.asyncFilterManager.unregisterAsyncHandlers(plugin);
    }

    @Override
    public void invokePacketRecieving(PacketEvent event) {
        if (!this.hasClosed) {
            this.handlePacket(this.recievedListeners, event, false);
        }
    }

    @Override
    public void invokePacketSending(PacketEvent event) {
        if (!this.hasClosed) {
            this.handlePacket(this.sendingListeners, event, true);
        }
    }

    @Override
    public boolean requireInputBuffer(int packetId) {
        return this.inputBufferedPackets.contains(PacketType.findLegacy(packetId));
    }

    private void handlePacket(SortedPacketListenerList packetListeners, PacketEvent event, boolean sending) {
        if (this.asyncFilterManager.hasAsynchronousListeners(event)) {
            event.setAsyncMarker(this.asyncFilterManager.createAsyncMarker());
        }
        if (sending) {
            packetListeners.invokePacketSending(this.reporter, event);
        } else {
            packetListeners.invokePacketRecieving(this.reporter, event);
        }
        if (!event.isCancelled() && !this.hasAsyncCancelled(event.getAsyncMarker())) {
            this.asyncFilterManager.enqueueSyncPacket(event, event.getAsyncMarker());
            event.setReadOnly(false);
            event.setCancelled(true);
        }
    }

    private boolean hasAsyncCancelled(AsyncMarker marker) {
        return marker == null || marker.isAsyncCancelled();
    }

    private void enablePacketFilters(PacketListener listener, Iterable<PacketType> packets) {
        for (PacketType type : packets) {
            if (type.getSender() == PacketType.Sender.SERVER) {
                if (!this.knowsServerPackets || PacketRegistry.getServerPacketTypes().contains(type)) {
                    this.playerInjection.addPacketHandler(type, listener.getSendingWhitelist().getOptions());
                } else {
                    this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_UNSUPPORTED_SERVER_PACKET_ID).messageParam(PacketAdapter.getPluginName(listener), type));
                }
            }
            if (type.getSender() != PacketType.Sender.CLIENT || this.packetInjector == null) continue;
            if (!this.knowsClientPackets || PacketRegistry.getClientPacketTypes().contains(type)) {
                this.packetInjector.addPacketHandler(type, listener.getReceivingWhitelist().getOptions());
                continue;
            }
            this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_UNSUPPORTED_CLIENT_PACKET_ID).messageParam(PacketAdapter.getPluginName(listener), type));
        }
    }

    private void disablePacketFilters(ConnectionSide side, Iterable<PacketType> packets) {
        if (side == null) {
            throw new IllegalArgumentException("side cannot be NULL.");
        }
        for (PacketType type : packets) {
            if (side.isForServer()) {
                this.playerInjection.removePacketHandler(type);
            }
            if (!side.isForClient() || this.packetInjector == null) continue;
            this.packetInjector.removePacketHandler(type);
        }
    }

    @Override
    public void broadcastServerPacket(PacketContainer packet) {
        Preconditions.checkNotNull((Object)packet, (Object)"packet cannot be NULL.");
        this.broadcastServerPacket(packet, Arrays.asList(this.server.getOnlinePlayers()));
    }

    @Override
    public void broadcastServerPacket(PacketContainer packet, Entity entity, boolean includeTracker) {
        Preconditions.checkNotNull((Object)packet, (Object)"packet cannot be NULL.");
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be NULL.");
        List<Player> trackers = this.getEntityTrackers(entity);
        if (includeTracker && entity instanceof Player) {
            trackers.add((Player)entity);
        }
        this.broadcastServerPacket(packet, trackers);
    }

    @Override
    public void broadcastServerPacket(PacketContainer packet, Location origin, int maxObserverDistance) {
        try {
            int maxDistance = maxObserverDistance * maxObserverDistance;
            World world = origin.getWorld();
            Location recycle = origin.clone();
            for (Player player : this.server.getOnlinePlayers()) {
                if (!world.equals(player.getWorld()) || !(this.getDistanceSquared(origin, recycle, player) <= (double)maxDistance)) continue;
                this.sendServerPacket(player, packet);
            }
        }
        catch (InvocationTargetException e) {
            throw new FieldAccessException("Unable to send server packet.", e);
        }
    }

    private double getDistanceSquared(Location origin, Location recycle, Player player) {
        if (this.hasRecycleDistance) {
            try {
                return player.getLocation(recycle).distanceSquared(origin);
            }
            catch (Error e) {
                this.hasRecycleDistance = false;
            }
        }
        return player.getLocation().distanceSquared(origin);
    }

    private void broadcastServerPacket(PacketContainer packet, Iterable<Player> players) {
        try {
            for (Player player : players) {
                this.sendServerPacket(player, packet);
            }
        }
        catch (InvocationTargetException e) {
            throw new FieldAccessException("Unable to send server packet.", e);
        }
    }

    @Override
    public void sendServerPacket(Player reciever, PacketContainer packet) throws InvocationTargetException {
        this.sendServerPacket(reciever, packet, null, true);
    }

    @Override
    public void sendServerPacket(Player reciever, PacketContainer packet, boolean filters) throws InvocationTargetException {
        this.sendServerPacket(reciever, packet, null, filters);
    }

    @Override
    public void sendServerPacket(Player receiver, PacketContainer packet, NetworkMarker marker, boolean filters) throws InvocationTargetException {
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be NULL.");
        }
        if (packet == null) {
            throw new IllegalArgumentException("packet cannot be NULL.");
        }
        if (this.packetCreation.compareAndSet(false, true)) {
            this.incrementPhases(GamePhase.PLAYING);
        }
        if (!filters) {
            PacketEvent event = PacketEvent.fromServer(this, packet, marker, receiver);
            this.sendingListeners.invokePacketSending(this.reporter, event, ListenerPriority.MONITOR);
            marker = NetworkMarker.getNetworkMarker(event);
        }
        this.playerInjection.sendServerPacket(receiver, packet, marker, filters);
    }

    @Override
    public void recieveClientPacket(Player sender, PacketContainer packet) throws IllegalAccessException, InvocationTargetException {
        this.recieveClientPacket(sender, packet, null, true);
    }

    @Override
    public void recieveClientPacket(Player sender, PacketContainer packet, boolean filters) throws IllegalAccessException, InvocationTargetException {
        this.recieveClientPacket(sender, packet, null, filters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void recieveClientPacket(Player sender, PacketContainer packet, NetworkMarker marker, boolean filters) throws IllegalAccessException, InvocationTargetException {
        Object mcPacket;
        boolean cancelled;
        if (sender == null) {
            throw new IllegalArgumentException("sender cannot be NULL.");
        }
        if (packet == null) {
            throw new IllegalArgumentException("packet cannot be NULL.");
        }
        if (this.packetCreation.compareAndSet(false, true)) {
            this.incrementPhases(GamePhase.PLAYING);
        }
        if (cancelled = this.packetInjector.isCancelled(mcPacket = packet.getHandle())) {
            this.packetInjector.setCancelled(mcPacket, false);
        }
        if (filters) {
            byte[] data = NetworkMarker.getByteBuffer(marker);
            PacketEvent event = this.packetInjector.packetRecieved(packet, sender, data);
            if (event.isCancelled()) return;
            mcPacket = event.getPacket().getHandle();
        } else {
            this.recievedListeners.invokePacketSending(this.reporter, PacketEvent.fromClient(this, packet, marker, sender), ListenerPriority.MONITOR);
        }
        this.playerInjection.recieveClientPacket(sender, mcPacket);
        if (!cancelled) return;
        this.packetInjector.setCancelled(mcPacket, true);
    }

    @Override
    @Deprecated
    public PacketContainer createPacket(int id) {
        return this.createPacket(PacketType.findLegacy(id), true);
    }

    @Override
    public PacketContainer createPacket(PacketType type) {
        return this.createPacket(type, true);
    }

    @Override
    @Deprecated
    public PacketContainer createPacket(int id, boolean forceDefaults) {
        return this.createPacket(PacketType.findLegacy(id), forceDefaults);
    }

    @Override
    public PacketContainer createPacket(PacketType type, boolean forceDefaults) {
        PacketContainer packet = new PacketContainer(type);
        if (forceDefaults) {
            try {
                packet.getModifier().writeDefaults();
            }
            catch (FieldAccessException e) {
                throw new RuntimeException("Security exception.", e);
            }
        }
        return packet;
    }

    @Override
    @Deprecated
    public PacketConstructor createPacketConstructor(int id, Object ... arguments) {
        return PacketConstructor.DEFAULT.withPacket(id, arguments);
    }

    @Override
    public PacketConstructor createPacketConstructor(PacketType type, Object ... arguments) {
        return PacketConstructor.DEFAULT.withPacket(type, arguments);
    }

    @Override
    @Deprecated
    public Set<Integer> getSendingFilters() {
        return PacketRegistry.toLegacy(this.playerInjection.getSendingFilters());
    }

    @Override
    public Set<Integer> getReceivingFilters() {
        return PacketRegistry.toLegacy(this.packetInjector.getPacketHandlers());
    }

    @Override
    public Set<PacketType> getSendingFilterTypes() {
        return Collections.unmodifiableSet(this.playerInjection.getSendingFilters());
    }

    @Override
    public Set<PacketType> getReceivingFilterTypes() {
        return Collections.unmodifiableSet(this.packetInjector.getPacketHandlers());
    }

    @Override
    public void updateEntity(Entity entity, List<Player> observers) throws FieldAccessException {
        EntityUtilities.updateEntity(entity, observers);
    }

    @Override
    public Entity getEntityFromID(World container, int id) throws FieldAccessException {
        return EntityUtilities.getEntityFromID(container, id);
    }

    @Override
    public List<Player> getEntityTrackers(Entity entity) throws FieldAccessException {
        return EntityUtilities.getEntityTrackers(entity);
    }

    public void initializePlayers(Player[] players) {
        for (Player player : players) {
            this.playerInjection.injectPlayer(player, PlayerInjectionHandler.ConflictStrategy.OVERRIDE);
        }
    }

    public void uninitializePlayers(Player[] players) {
        for (Player player : players) {
            this.playerInjection.uninjectPlayer(player);
        }
    }

    @Override
    public void registerEvents(PluginManager manager, final Plugin plugin) {
        if (this.spigotInjector != null && !this.spigotInjector.register(plugin)) {
            throw new IllegalArgumentException("Spigot has already been registered.");
        }
        if (this.nettyInjector != null) {
            this.nettyInjector.inject();
        }
        try {
            manager.registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.LOWEST)
                public void onPlayerLogin(PlayerLoginEvent event) {
                    PacketFilterManager.this.onPlayerLogin(event);
                }

                @EventHandler(priority=EventPriority.LOWEST)
                public void onPrePlayerJoin(PlayerJoinEvent event) {
                    PacketFilterManager.this.onPrePlayerJoin(event);
                }

                @EventHandler(priority=EventPriority.MONITOR)
                public void onPlayerJoin(PlayerJoinEvent event) {
                    PacketFilterManager.this.onPlayerJoin(event);
                }

                @EventHandler(priority=EventPriority.MONITOR)
                public void onPlayerQuit(PlayerQuitEvent event) {
                    PacketFilterManager.this.onPlayerQuit(event);
                }

                @EventHandler(priority=EventPriority.MONITOR)
                public void onPluginDisabled(PluginDisableEvent event) {
                    PacketFilterManager.this.onPluginDisabled(event, plugin);
                }
            }, plugin);
        }
        catch (NoSuchMethodError e) {
            this.registerOld(manager, plugin);
        }
    }

    private void onPlayerLogin(PlayerLoginEvent event) {
        this.playerInjection.updatePlayer(event.getPlayer());
    }

    private void onPrePlayerJoin(PlayerJoinEvent event) {
        this.playerInjection.updatePlayer(event.getPlayer());
    }

    private void onPlayerJoin(PlayerJoinEvent event) {
        try {
            this.playerInjection.uninjectPlayer(event.getPlayer().getAddress());
            this.playerInjection.injectPlayer(event.getPlayer(), PlayerInjectionHandler.ConflictStrategy.OVERRIDE);
        }
        catch (PlayerInjector.ServerHandlerNull e) {
        }
        catch (Exception e) {
            this.reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_INJECT_PLAYER).callerParam(event).error(e));
        }
    }

    private void onPlayerQuit(PlayerQuitEvent event) {
        try {
            Player player = event.getPlayer();
            this.asyncFilterManager.removePlayer(player);
            this.playerInjection.handleDisconnect(player);
            this.playerInjection.uninjectPlayer(player);
        }
        catch (Exception e) {
            this.reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_UNINJECT_OFFLINE_PLAYER).callerParam(event).error(e));
        }
    }

    private void onPluginDisabled(PluginDisableEvent event, Plugin protocolLibrary) {
        try {
            if (event.getPlugin() != protocolLibrary) {
                this.removePacketListeners(event.getPlugin());
            }
        }
        catch (Exception e) {
            this.reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_CANNOT_UNREGISTER_PLUGIN).callerParam(event).error(e));
        }
    }

    private int getPhasePlayingCount() {
        return this.phasePlayingCount.get();
    }

    private int getPhaseLoginCount() {
        return this.phaseLoginCount.get();
    }

    @Override
    @Deprecated
    public int getPacketID(Object packet) {
        return PacketRegistry.getPacketID(packet.getClass());
    }

    @Override
    public PacketType getPacketType(Object packet) {
        if (packet == null) {
            throw new IllegalArgumentException("Packet cannot be NULL.");
        }
        if (!MinecraftReflection.isPacketClass(packet)) {
            throw new IllegalArgumentException("The given object " + packet + " is not a packet.");
        }
        PacketType type = PacketRegistry.getPacketType(packet.getClass());
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Unable to find associated packet of " + packet + ": Lookup returned NULL.");
    }

    @Override
    @Deprecated
    public void registerPacketClass(Class<?> clazz, int packetID) {
        PacketRegistry.getPacketToID().put(clazz, packetID);
    }

    @Override
    @Deprecated
    public void unregisterPacketClass(Class<?> clazz) {
        PacketRegistry.getPacketToID().remove(clazz);
    }

    @Override
    @Deprecated
    public Class<?> getPacketClassFromID(int packetID, boolean forceVanilla) {
        return PacketRegistry.getPacketClassFromID(packetID, forceVanilla);
    }

    private void registerOld(PluginManager manager, final Plugin plugin) {
        try {
            ClassLoader loader = manager.getClass().getClassLoader();
            Class<?> eventTypes = loader.loadClass("org.bukkit.event.Event$Type");
            Class<?> eventPriority = loader.loadClass("org.bukkit.event.Event$Priority");
            Object priorityLowest = Enum.valueOf(eventPriority, "Lowest");
            Object priorityMonitor = Enum.valueOf(eventPriority, "Monitor");
            Object playerJoinType = Enum.valueOf(eventTypes, "PLAYER_JOIN");
            Object playerQuitType = Enum.valueOf(eventTypes, "PLAYER_QUIT");
            Object pluginDisabledType = Enum.valueOf(eventTypes, "PLUGIN_DISABLE");
            Class<?> playerListener = loader.loadClass("org.bukkit.event.player.PlayerListener");
            Class<?> serverListener = loader.loadClass("org.bukkit.event.server.ServerListener");
            Method registerEvent = FuzzyReflection.fromObject(manager).getMethodByParameters("registerEvent", eventTypes, Listener.class, eventPriority, Plugin.class);
            Enhancer playerLow = EnhancerFactory.getInstance().createEnhancer();
            Enhancer playerEx = EnhancerFactory.getInstance().createEnhancer();
            Enhancer serverEx = EnhancerFactory.getInstance().createEnhancer();
            playerLow.setSuperclass(playerListener);
            playerLow.setClassLoader(this.classLoader);
            playerLow.setCallback(new MethodInterceptor(){

                @Override
                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    Object event;
                    if (args.length == 1 && (event = args[0]) instanceof PlayerJoinEvent) {
                        PacketFilterManager.this.onPrePlayerJoin((PlayerJoinEvent)event);
                    }
                    return null;
                }
            });
            playerEx.setSuperclass(playerListener);
            playerEx.setClassLoader(this.classLoader);
            playerEx.setCallback(new MethodInterceptor(){

                @Override
                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    if (args.length == 1) {
                        Object event = args[0];
                        if (event instanceof PlayerJoinEvent) {
                            PacketFilterManager.this.onPlayerJoin((PlayerJoinEvent)event);
                        } else if (event instanceof PlayerQuitEvent) {
                            PacketFilterManager.this.onPlayerQuit((PlayerQuitEvent)event);
                        }
                    }
                    return null;
                }
            });
            serverEx.setSuperclass(serverListener);
            serverEx.setClassLoader(this.classLoader);
            serverEx.setCallback(new MethodInterceptor(){

                @Override
                public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                    Object event;
                    if (args.length == 1 && (event = args[0]) instanceof PluginDisableEvent) {
                        PacketFilterManager.this.onPluginDisabled((PluginDisableEvent)event, plugin);
                    }
                    return null;
                }
            });
            Object playerProxyLow = playerLow.create();
            Object playerProxy = playerEx.create();
            Object serverProxy = serverEx.create();
            registerEvent.invoke((Object)manager, playerJoinType, playerProxyLow, priorityLowest, plugin);
            registerEvent.invoke((Object)manager, playerJoinType, playerProxy, priorityMonitor, plugin);
            registerEvent.invoke((Object)manager, playerQuitType, playerProxy, priorityMonitor, plugin);
            registerEvent.invoke((Object)manager, pluginDisabledType, serverProxy, priorityMonitor, plugin);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static Set<Integer> getServerPackets() throws FieldAccessException {
        return PacketRegistry.getServerPackets();
    }

    @Deprecated
    public static Set<Integer> getClientPackets() throws FieldAccessException {
        return PacketRegistry.getClientPackets();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public boolean isClosed() {
        return this.hasClosed;
    }

    @Override
    public void close() {
        if (this.hasClosed) {
            return;
        }
        if (this.packetInjector != null) {
            this.packetInjector.cleanupAll();
        }
        if (this.spigotInjector != null) {
            this.spigotInjector.cleanupAll();
        }
        if (this.nettyInjector != null) {
            this.nettyInjector.close();
        }
        this.playerInjection.close();
        this.hasClosed = true;
        this.packetListeners.clear();
        this.recievedListeners = null;
        this.sendingListeners = null;
        this.interceptWritePacket.cleanup();
        this.asyncFilterManager.cleanupAll();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static enum PlayerInjectHooks {
        NONE,
        NETWORK_MANAGER_OBJECT,
        NETWORK_HANDLER_FIELDS,
        NETWORK_SERVER_OBJECT;

    }
}

