/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.concurrency.AbstractConcurrentListenerMultimap;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.PrioritizedListener;
import com.comphenix.protocol.timing.TimedListenerManager;
import com.comphenix.protocol.timing.TimedTracker;
import java.util.Collection;

public final class SortedPacketListenerList
extends AbstractConcurrentListenerMultimap<PacketListener> {
    private TimedListenerManager timedManager = TimedListenerManager.getInstance();

    public void invokePacketRecieving(ErrorReporter reporter, PacketEvent event) {
        Collection list = this.getListener(event.getPacketType());
        if (list == null) {
            return;
        }
        if (this.timedManager.isTiming()) {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                TimedTracker tracker = this.timedManager.getTracker((PacketListener)prioritizedListener.getListener(), TimedListenerManager.ListenerType.SYNC_CLIENT_SIDE);
                long token = tracker.beginTracking();
                this.invokeReceivingListener(reporter, event, prioritizedListener);
                tracker.endTracking(token, event.getPacketType());
            }
        } else {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                this.invokeReceivingListener(reporter, event, prioritizedListener);
            }
        }
    }

    public void invokePacketRecieving(ErrorReporter reporter, PacketEvent event, ListenerPriority priorityFilter) {
        Collection list = this.getListener(event.getPacketType());
        if (list == null) {
            return;
        }
        if (this.timedManager.isTiming()) {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                if (prioritizedListener.getPriority() != priorityFilter) continue;
                TimedTracker tracker = this.timedManager.getTracker((PacketListener)prioritizedListener.getListener(), TimedListenerManager.ListenerType.SYNC_CLIENT_SIDE);
                long token = tracker.beginTracking();
                this.invokeReceivingListener(reporter, event, prioritizedListener);
                tracker.endTracking(token, event.getPacketType());
            }
        } else {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                if (prioritizedListener.getPriority() != priorityFilter) continue;
                this.invokeReceivingListener(reporter, event, prioritizedListener);
            }
        }
    }

    private final void invokeReceivingListener(ErrorReporter reporter, PacketEvent event, PrioritizedListener<PacketListener> element) {
        try {
            event.setReadOnly(element.getPriority() == ListenerPriority.MONITOR);
            element.getListener().onPacketReceiving(event);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            reporter.reportMinimal(element.getListener().getPlugin(), "onPacketReceiving(PacketEvent)", e, event.getPacket().getHandle());
        }
    }

    public void invokePacketSending(ErrorReporter reporter, PacketEvent event) {
        Collection list = this.getListener(event.getPacketType());
        if (list == null) {
            return;
        }
        if (this.timedManager.isTiming()) {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                TimedTracker tracker = this.timedManager.getTracker((PacketListener)prioritizedListener.getListener(), TimedListenerManager.ListenerType.SYNC_SERVER_SIDE);
                long token = tracker.beginTracking();
                this.invokeSendingListener(reporter, event, prioritizedListener);
                tracker.endTracking(token, event.getPacketType());
            }
        } else {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                this.invokeSendingListener(reporter, event, prioritizedListener);
            }
        }
    }

    public void invokePacketSending(ErrorReporter reporter, PacketEvent event, ListenerPriority priorityFilter) {
        Collection list = this.getListener(event.getPacketType());
        if (list == null) {
            return;
        }
        if (this.timedManager.isTiming()) {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                if (prioritizedListener.getPriority() != priorityFilter) continue;
                TimedTracker tracker = this.timedManager.getTracker((PacketListener)prioritizedListener.getListener(), TimedListenerManager.ListenerType.SYNC_SERVER_SIDE);
                long token = tracker.beginTracking();
                this.invokeSendingListener(reporter, event, prioritizedListener);
                tracker.endTracking(token, event.getPacketType());
            }
        } else {
            for (PrioritizedListener<PacketListener> prioritizedListener : list) {
                if (prioritizedListener.getPriority() != priorityFilter) continue;
                this.invokeSendingListener(reporter, event, prioritizedListener);
            }
        }
    }

    private final void invokeSendingListener(ErrorReporter reporter, PacketEvent event, PrioritizedListener<PacketListener> element) {
        try {
            event.setReadOnly(element.getPriority() == ListenerPriority.MONITOR);
            element.getListener().onPacketSending(event);
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable e) {
            reporter.reportMinimal(element.getListener().getPlugin(), "onPacketSending(PacketEvent)", e, event.getPacket().getHandle());
        }
    }
}

