/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.player;

import com.comphenix.net.sf.cglib.proxy.Factory;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.concurrency.IntegerSet;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.injector.GamePhase;
import com.comphenix.protocol.injector.ListenerInvoker;
import com.comphenix.protocol.injector.PacketFilterManager;
import com.comphenix.protocol.injector.PlayerLoggedOutException;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.injector.player.InjectedServerConnection;
import com.comphenix.protocol.injector.player.NetLoginInjector;
import com.comphenix.protocol.injector.player.NetworkFieldInjector;
import com.comphenix.protocol.injector.player.NetworkObjectInjector;
import com.comphenix.protocol.injector.player.NetworkServerInjector;
import com.comphenix.protocol.injector.player.PlayerInjectionHandler;
import com.comphenix.protocol.injector.player.PlayerInjector;
import com.comphenix.protocol.injector.player.UnsupportedListener;
import com.comphenix.protocol.injector.server.AbstractInputStreamLookup;
import com.comphenix.protocol.injector.server.BukkitSocketInjector;
import com.comphenix.protocol.injector.server.SocketInjector;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import java.io.DataInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Server;
import org.bukkit.entity.Player;

class ProxyPlayerInjectionHandler
implements PlayerInjectionHandler {
    public static final ReportType REPORT_UNSUPPPORTED_LISTENER = new ReportType("Cannot fully register listener for %s: %s");
    public static final ReportType REPORT_PLAYER_HOOK_FAILED = new ReportType("Player hook %s failed.");
    public static final ReportType REPORT_SWITCHED_PLAYER_HOOK = new ReportType("Switching to %s instead.");
    public static final ReportType REPORT_HOOK_CLEANUP_FAILED = new ReportType("Cleaing up after player hook failed.");
    public static final ReportType REPORT_CANNOT_REVERT_HOOK = new ReportType("Unable to fully revert old injector. May cause conflicts.");
    private InjectedServerConnection serverInjection;
    private AbstractInputStreamLookup inputStreamLookup;
    private NetLoginInjector netLoginInjector;
    private WeakReference<PlayerInjector> lastSuccessfulHook;
    private ConcurrentMap<Player, PlayerInjector> dummyInjectors;
    private Map<Player, PlayerInjector> playerInjection;
    private volatile PacketFilterManager.PlayerInjectHooks loginPlayerHook;
    private volatile PacketFilterManager.PlayerInjectHooks playingPlayerHook;
    private ErrorReporter reporter;
    private boolean hasClosed;
    private ListenerInvoker invoker;
    private MinecraftVersion version;
    private IntegerSet sendingFilters;
    private Set<PacketListener> packetListeners;
    private Predicate<GamePhase> injectionFilter;

    /*
     * Exception decompiling
     */
    public ProxyPlayerInjectionHandler(ErrorReporter reporter, Predicate<GamePhase> injectionFilter, ListenerInvoker invoker, Set<PacketListener> packetListeners, Server server, MinecraftVersion version) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public PacketFilterManager.PlayerInjectHooks getPlayerHook() {
        return this.getPlayerHook(GamePhase.PLAYING);
    }

    @Override
    public PacketFilterManager.PlayerInjectHooks getPlayerHook(GamePhase phase) {
        switch (phase) {
            case LOGIN: {
                return this.loginPlayerHook;
            }
            case PLAYING: {
                return this.playingPlayerHook;
            }
        }
        throw new IllegalArgumentException("Cannot retrieve injection hook for both phases at the same time.");
    }

    @Override
    public void setPlayerHook(PacketFilterManager.PlayerInjectHooks playerHook) {
        this.setPlayerHook(GamePhase.PLAYING, playerHook);
    }

    @Override
    public void setPlayerHook(GamePhase phase, PacketFilterManager.PlayerInjectHooks playerHook) {
        if (phase.hasLogin()) {
            this.loginPlayerHook = playerHook;
        }
        if (phase.hasPlaying()) {
            this.playingPlayerHook = playerHook;
        }
        this.checkListener(this.packetListeners);
    }

    @Override
    public void addPacketHandler(PacketType type, Set<ListenerOptions> options) {
        this.sendingFilters.add(type.getLegacyId());
    }

    @Override
    public void removePacketHandler(PacketType type) {
        this.sendingFilters.remove(type.getLegacyId());
    }

    private PlayerInjector getHookInstance(Player player, PacketFilterManager.PlayerInjectHooks hook) throws IllegalAccessException {
        switch (hook) {
            case NETWORK_HANDLER_FIELDS: {
                return new NetworkFieldInjector(this.reporter, player, this.invoker, this.sendingFilters);
            }
            case NETWORK_MANAGER_OBJECT: {
                return new NetworkObjectInjector(this.reporter, player, this.invoker, this.sendingFilters);
            }
            case NETWORK_SERVER_OBJECT: {
                return new NetworkServerInjector(this.reporter, player, this.invoker, this.sendingFilters, this.serverInjection);
            }
        }
        throw new IllegalArgumentException("Cannot construct a player injector.");
    }

    @Override
    public Player getPlayerByConnection(DataInputStream inputStream) {
        SocketInjector injector = this.inputStreamLookup.waitSocketInjector(inputStream);
        if (injector != null) {
            return injector.getPlayer();
        }
        return null;
    }

    private PacketFilterManager.PlayerInjectHooks getInjectorType(PlayerInjector injector) {
        return injector != null ? injector.getHookType() : PacketFilterManager.PlayerInjectHooks.NONE;
    }

    @Override
    public void injectPlayer(Player player, PlayerInjectionHandler.ConflictStrategy strategy) {
        if (this.isInjectionNecessary(GamePhase.PLAYING)) {
            this.injectPlayer(player, player, strategy, GamePhase.PLAYING);
        }
    }

    public boolean isInjectionNecessary(GamePhase phase) {
        return this.injectionFilter.apply((Object)phase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlayerInjector injectPlayer(Player player, Object injectionPoint, PlayerInjectionHandler.ConflictStrategy stategy, GamePhase phase) {
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be NULL.");
        }
        if (injectionPoint == null) {
            throw new IllegalArgumentException("injectionPoint cannot be NULL.");
        }
        if (phase == null) {
            throw new IllegalArgumentException("phase cannot be NULL.");
        }
        Player player2 = player;
        synchronized (player2) {
            return this.injectPlayerInternal(player, injectionPoint, stategy, phase);
        }
    }

    private PlayerInjector injectPlayerInternal(Player player, Object injectionPoint, PlayerInjectionHandler.ConflictStrategy stategy, GamePhase phase) {
        boolean invalidInjector;
        PacketFilterManager.PlayerInjectHooks tempHook;
        PlayerInjector injector = this.playerInjection.get(player);
        PacketFilterManager.PlayerInjectHooks permanentHook = tempHook = this.getPlayerHook(phase);
        boolean bl = injector != null ? !injector.canInject(phase) : (invalidInjector = true);
        if (!this.hasClosed && (tempHook != this.getInjectorType(injector) || invalidInjector)) {
            while (tempHook != PacketFilterManager.PlayerInjectHooks.NONE) {
                boolean hookFailed = false;
                this.cleanupHook(injector);
                try {
                    injector = this.getHookInstance(player, tempHook);
                    if (injector.canInject(phase)) {
                        injector.initialize(injectionPoint);
                        SocketAddress address = injector.getAddress();
                        if (address == null) {
                            return null;
                        }
                        SocketInjector previous = this.inputStreamLookup.peekSocketInjector(address);
                        Socket socket = injector.getSocket();
                        if (previous != null && !(player instanceof Factory)) {
                            switch (stategy) {
                                case OVERRIDE: {
                                    this.uninjectPlayer(previous.getPlayer(), true);
                                    break;
                                }
                                case BAIL_OUT: {
                                    return null;
                                }
                            }
                        }
                        injector.injectManager();
                        this.saveAddressLookup(address, socket, injector);
                        break;
                    }
                }
                catch (PlayerLoggedOutException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_PLAYER_HOOK_FAILED).messageParam(new Object[]{tempHook}).callerParam(new Object[]{player, injectionPoint, phase}).error(e));
                    hookFailed = true;
                }
                tempHook = PacketFilterManager.PlayerInjectHooks.values()[tempHook.ordinal() - 1];
                if (hookFailed) {
                    this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_SWITCHED_PLAYER_HOOK).messageParam(new Object[]{tempHook}));
                }
                if (tempHook == PacketFilterManager.PlayerInjectHooks.NONE) {
                    this.cleanupHook(injector);
                    injector = null;
                    hookFailed = true;
                }
                if (!hookFailed) continue;
                permanentHook = tempHook;
            }
            if (injector != null) {
                this.lastSuccessfulHook = new WeakReference<PlayerInjector>(injector);
            }
            if (permanentHook != this.getPlayerHook(phase)) {
                this.setPlayerHook(phase, tempHook);
            }
            if (injector != null) {
                this.playerInjection.put(player, injector);
            }
        }
        return injector;
    }

    private void saveAddressLookup(SocketAddress address, Socket socket, SocketInjector injector) {
        SocketAddress socketAddress;
        SocketAddress socketAddress2 = socketAddress = socket != null ? socket.getRemoteSocketAddress() : null;
        if (socketAddress != null && !Objects.equal((Object)socketAddress, (Object)address)) {
            this.inputStreamLookup.setSocketInjector(socketAddress, injector);
        }
        this.inputStreamLookup.setSocketInjector(address, injector);
    }

    private void cleanupHook(PlayerInjector injector) {
        try {
            if (injector != null) {
                injector.cleanupAll();
            }
        }
        catch (Exception ex) {
            this.reporter.reportDetailed((Object)this, Report.newBuilder(REPORT_HOOK_CLEANUP_FAILED).callerParam(injector).error(ex));
        }
    }

    @Override
    public void handleDisconnect(Player player) {
        PlayerInjector injector = this.getInjector(player);
        if (injector != null) {
            injector.handleDisconnect();
        }
    }

    @Override
    public void updatePlayer(Player player) {
        InetSocketAddress address = player.getAddress();
        if (address != null) {
            SocketInjector injector = this.inputStreamLookup.peekSocketInjector(address);
            if (injector != null) {
                injector.setUpdatedPlayer(player);
            } else {
                this.inputStreamLookup.setSocketInjector(player.getAddress(), new BukkitSocketInjector(player));
            }
        }
    }

    @Override
    public boolean uninjectPlayer(Player player) {
        return this.uninjectPlayer(player, false);
    }

    private boolean uninjectPlayer(Player player, boolean prepareNextHook) {
        PlayerInjector injector;
        if (!this.hasClosed && player != null && (injector = this.playerInjection.remove(player)) != null) {
            injector.cleanupAll();
            if (prepareNextHook && injector instanceof NetworkObjectInjector) {
                try {
                    PlayerInjector dummyInjector = this.getHookInstance(player, PacketFilterManager.PlayerInjectHooks.NETWORK_SERVER_OBJECT);
                    dummyInjector.initializePlayer(player);
                    dummyInjector.setNetworkManager(injector.getNetworkManager(), true);
                }
                catch (IllegalAccessException e) {
                    this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_CANNOT_REVERT_HOOK).error(e));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean uninjectPlayer(InetSocketAddress address) {
        if (!this.hasClosed && address != null) {
            SocketInjector injector = this.inputStreamLookup.peekSocketInjector(address);
            if (injector != null) {
                this.uninjectPlayer(injector.getPlayer(), true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void sendServerPacket(Player receiver, PacketContainer packet, NetworkMarker marker, boolean filters) throws InvocationTargetException {
        PlayerInjector injector = this.getInjector(receiver);
        if (injector == null) {
            throw new PlayerLoggedOutException(String.format("Unable to send packet %s (%s): Player %s has logged out.", packet.getType(), packet, receiver));
        }
        injector.sendServerPacket(packet.getHandle(), marker, filters);
    }

    @Override
    public void recieveClientPacket(Player player, Object mcPacket) throws IllegalAccessException, InvocationTargetException {
        PlayerInjector injector = this.getInjector(player);
        if (injector == null) {
            throw new PlayerLoggedOutException(String.format("Unable to receieve packet %s. Player %s has logged out.", mcPacket, player));
        }
        injector.processPacket(mcPacket);
    }

    private PlayerInjector getInjector(Player player) {
        PlayerInjector injector = this.playerInjection.get(player);
        if (injector == null) {
            InetSocketAddress address = player.getAddress();
            if (address == null) {
                return null;
            }
            SocketInjector result = this.inputStreamLookup.peekSocketInjector(address);
            if (result instanceof PlayerInjector) {
                return (PlayerInjector)result;
            }
            return this.createDummyInjector(player);
        }
        return injector;
    }

    private PlayerInjector createDummyInjector(Player player) {
        if (!MinecraftReflection.getCraftPlayerClass().isAssignableFrom(player.getClass())) {
            return null;
        }
        try {
            PlayerInjector dummyInjector = this.getHookInstance(player, PacketFilterManager.PlayerInjectHooks.NETWORK_SERVER_OBJECT);
            dummyInjector.initializePlayer(player);
            if (dummyInjector.getSocket() == null) {
                return null;
            }
            this.inputStreamLookup.setSocketInjector(dummyInjector.getAddress(), dummyInjector);
            this.dummyInjectors.put(player, dummyInjector);
            return dummyInjector;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access fields.", e);
        }
    }

    PlayerInjector getInjectorByNetworkHandler(Object networkManager) {
        if (networkManager == null) {
            return null;
        }
        for (PlayerInjector injector : this.playerInjection.values()) {
            if (injector.getNetworkManager() != networkManager) continue;
            return injector;
        }
        return null;
    }

    @Override
    public boolean canRecievePackets() {
        return false;
    }

    @Override
    public PacketEvent handlePacketRecieved(PacketContainer packet, InputStream input, byte[] buffered) {
        throw new UnsupportedOperationException("Proxy injection cannot handle received packets.");
    }

    @Override
    public void checkListener(Set<PacketListener> listeners) {
        if (this.getLastSuccessfulHook() != null) {
            for (PacketListener listener : listeners) {
                this.checkListener(listener);
            }
        }
    }

    private PlayerInjector getLastSuccessfulHook() {
        return this.lastSuccessfulHook != null ? (PlayerInjector)this.lastSuccessfulHook.get() : null;
    }

    @Override
    public void checkListener(PacketListener listener) {
        UnsupportedListener result;
        PlayerInjector last = this.getLastSuccessfulHook();
        if (last != null && (result = last.checkListener(this.version, listener)) != null) {
            this.reporter.reportWarning((Object)this, Report.newBuilder(REPORT_UNSUPPPORTED_LISTENER).messageParam(PacketAdapter.getPluginName(listener), result));
            for (int packetID : result.getPackets()) {
                this.removePacketHandler(PacketType.findLegacy(packetID));
            }
        }
    }

    @Override
    public Set<PacketType> getSendingFilters() {
        return PacketRegistry.toPacketTypes(this.sendingFilters.toSet(), PacketType.Sender.SERVER);
    }

    @Override
    public void close() {
        if (this.hasClosed || this.playerInjection == null) {
            return;
        }
        for (PlayerInjector injection : this.playerInjection.values()) {
            if (injection == null) continue;
            injection.cleanupAll();
        }
        if (this.inputStreamLookup != null) {
            this.inputStreamLookup.cleanupAll();
        }
        if (this.serverInjection != null) {
            this.serverInjection.cleanupAll();
        }
        if (this.netLoginInjector != null) {
            this.netLoginInjector.cleanupAll();
        }
        this.inputStreamLookup = null;
        this.serverInjection = null;
        this.netLoginInjector = null;
        this.hasClosed = true;
        this.playerInjection.clear();
        this.invoker = null;
    }
}

