/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.server;

import com.comphenix.net.sf.cglib.proxy.Callback;
import com.comphenix.net.sf.cglib.proxy.CallbackFilter;
import com.comphenix.net.sf.cglib.proxy.Enhancer;
import com.comphenix.net.sf.cglib.proxy.MethodInterceptor;
import com.comphenix.net.sf.cglib.proxy.MethodProxy;
import com.comphenix.net.sf.cglib.proxy.NoOp;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.injector.server.InjectorContainer;
import com.comphenix.protocol.injector.server.SocketInjector;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.utility.ChatExtensions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class TemporaryPlayerFactory {
    private static CallbackFilter callbackFilter;

    public static SocketInjector getInjectorFromPlayer(Player player) {
        if (player instanceof InjectorContainer) {
            return ((InjectorContainer)player).getInjector();
        }
        return null;
    }

    public static void setInjectorInPlayer(Player player, SocketInjector injector) {
        ((InjectorContainer)player).setInjector(injector);
    }

    public Player createTemporaryPlayer(final Server server) {
        MethodInterceptor implementation = new MethodInterceptor(){

            @Override
            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                String methodName = method.getName();
                SocketInjector injector = ((InjectorContainer)obj).getInjector();
                if (injector == null) {
                    throw new IllegalStateException("Unable to find injector.");
                }
                if (methodName.equals("getPlayer")) {
                    return injector.getUpdatedPlayer();
                }
                if (methodName.equals("getAddress")) {
                    return injector.getAddress();
                }
                if (methodName.equals("getServer")) {
                    return server;
                }
                if (methodName.equals("chat") || methodName.equals("sendMessage")) {
                    try {
                        Object argument = args[0];
                        if (argument instanceof String) {
                            return TemporaryPlayerFactory.this.sendMessage(injector, (String)argument);
                        }
                        if (argument instanceof String[]) {
                            for (String message : (String[])argument) {
                                TemporaryPlayerFactory.this.sendMessage(injector, message);
                            }
                            return null;
                        }
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
                if (methodName.equals("kickPlayer")) {
                    injector.disconnect((String)args[0]);
                    return null;
                }
                Player updated = injector.getUpdatedPlayer();
                if (updated != obj && updated != null) {
                    return proxy.invoke(updated, args);
                }
                if (methodName.equals("isOnline")) {
                    return injector.getSocket() != null && injector.getSocket().isConnected();
                }
                if (methodName.equals("getName")) {
                    return "UNKNOWN[" + injector.getSocket().getRemoteSocketAddress() + "]";
                }
                throw new UnsupportedOperationException("The method " + method.getName() + " is not supported for temporary players.");
            }
        };
        if (callbackFilter == null) {
            callbackFilter = new CallbackFilter(){

                @Override
                public int accept(Method method) {
                    if (method.getDeclaringClass().equals(Object.class) || method.getDeclaringClass().equals(InjectorContainer.class)) {
                        return 0;
                    }
                    return 1;
                }
            };
        }
        Enhancer ex = new Enhancer();
        ex.setSuperclass(InjectorContainer.class);
        ex.setInterfaces(new Class[]{Player.class});
        ex.setCallbacks(new Callback[]{NoOp.INSTANCE, implementation});
        ex.setCallbackFilter(callbackFilter);
        return (Player)ex.create();
    }

    public Player createTemporaryPlayer(Server server, SocketInjector injector) {
        Player temporary = this.createTemporaryPlayer(server);
        ((InjectorContainer)temporary).setInjector(injector);
        return temporary;
    }

    private Object sendMessage(SocketInjector injector, String message) throws InvocationTargetException, FieldAccessException {
        for (PacketContainer packet : ChatExtensions.createChatPackets(message)) {
            injector.sendServerPacket(packet.getHandle(), null, false);
        }
        return null;
    }
}

