/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.accessors;

import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import java.lang.reflect.Field;

final class DefaultFieldAccessor
implements FieldAccessor {
    private final Field field;

    public DefaultFieldAccessor(Field field) {
        this.field = field;
    }

    @Override
    public Object get(Object instance) {
        try {
            return this.field.get(instance);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot read  " + this.field, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot use reflection.", e);
        }
    }

    @Override
    public void set(Object instance, Object value) {
        try {
            this.field.set(instance, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot set field " + this.field + " to value " + value, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot use reflection.", e);
        }
    }

    @Override
    public Field getField() {
        return this.field;
    }

    public int hashCode() {
        return this.field != null ? this.field.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultFieldAccessor) {
            DefaultFieldAccessor other = (DefaultFieldAccessor)obj;
            return other.field == this.field;
        }
        return true;
    }

    public String toString() {
        return "DefaultFieldAccessor [field=" + this.field + "]";
    }
}

