/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.MethodInfo;
import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class FuzzyClassContract
extends AbstractFuzzyMatcher<Class<?>> {
    private final ImmutableList<AbstractFuzzyMatcher<Field>> fieldContracts;
    private final ImmutableList<AbstractFuzzyMatcher<MethodInfo>> methodContracts;
    private final ImmutableList<AbstractFuzzyMatcher<MethodInfo>> constructorContracts;
    private final ImmutableList<AbstractFuzzyMatcher<Class<?>>> baseclassContracts;
    private final ImmutableList<AbstractFuzzyMatcher<Class<?>>> interfaceContracts;

    public static Builder newBuilder() {
        return new Builder();
    }

    private FuzzyClassContract(Builder builder) {
        this.fieldContracts = ImmutableList.copyOf((Collection)builder.fieldContracts);
        this.methodContracts = ImmutableList.copyOf((Collection)builder.methodContracts);
        this.constructorContracts = ImmutableList.copyOf((Collection)builder.constructorContracts);
        this.baseclassContracts = ImmutableList.copyOf((Collection)builder.baseclassContracts);
        this.interfaceContracts = ImmutableList.copyOf((Collection)builder.interfaceContracts);
    }

    public ImmutableList<AbstractFuzzyMatcher<Field>> getFieldContracts() {
        return this.fieldContracts;
    }

    public ImmutableList<AbstractFuzzyMatcher<MethodInfo>> getMethodContracts() {
        return this.methodContracts;
    }

    public ImmutableList<AbstractFuzzyMatcher<MethodInfo>> getConstructorContracts() {
        return this.constructorContracts;
    }

    public ImmutableList<AbstractFuzzyMatcher<Class<?>>> getBaseclassContracts() {
        return this.baseclassContracts;
    }

    public ImmutableList<AbstractFuzzyMatcher<Class<?>>> getInterfaceContracts() {
        return this.interfaceContracts;
    }

    @Override
    protected int calculateRoundNumber() {
        return this.combineRounds(this.findHighestRound((Collection)this.fieldContracts), this.findHighestRound((Collection)this.methodContracts), this.findHighestRound((Collection)this.constructorContracts), this.findHighestRound((Collection)this.interfaceContracts), this.findHighestRound((Collection)this.baseclassContracts));
    }

    private <T> int findHighestRound(Collection<AbstractFuzzyMatcher<T>> list) {
        int highest = 0;
        for (AbstractFuzzyMatcher<T> matcher : list) {
            highest = this.combineRounds(highest, matcher.getRoundNumber());
        }
        return highest;
    }

    @Override
    public boolean isMatch(Class<?> value, Object parent) {
        FuzzyReflection reflection = FuzzyReflection.fromClass(value, true);
        return !(this.fieldContracts.size() != 0 && !this.processContracts((Collection)reflection.getFields(), value, (List)this.fieldContracts) || this.methodContracts.size() != 0 && !this.processContracts((Collection)MethodInfo.fromMethods(reflection.getMethods()), value, (List)this.methodContracts) || this.constructorContracts.size() != 0 && !this.processContracts((Collection)MethodInfo.fromConstructors(value.getDeclaredConstructors()), value, (List)this.constructorContracts) || this.baseclassContracts.size() != 0 && !this.processValue((Object)value.getSuperclass(), parent, (List)this.baseclassContracts) || this.interfaceContracts.size() != 0 && !this.processContracts((Collection)Arrays.asList(value.getInterfaces()), (Class)parent, (List)this.interfaceContracts));
    }

    private <T> boolean processContracts(Collection<T> values, Object parent, List<AbstractFuzzyMatcher<T>> matchers) {
        boolean[] accepted = new boolean[matchers.size()];
        int count = accepted.length;
        for (T value : values) {
            int index = this.processValue(value, parent, accepted, matchers);
            if (index >= 0) {
                accepted[index] = true;
                --count;
            }
            if (count != 0) continue;
            return true;
        }
        return count == 0;
    }

    private <T> boolean processValue(T value, Object parent, List<AbstractFuzzyMatcher<T>> matchers) {
        for (int i = 0; i < matchers.size(); ++i) {
            if (!matchers.get(i).isMatch(value, parent)) continue;
            return true;
        }
        return false;
    }

    private <T> int processValue(T value, Object parent, boolean[] accepted, List<AbstractFuzzyMatcher<T>> matchers) {
        for (int i = 0; i < matchers.size(); ++i) {
            AbstractFuzzyMatcher<T> matcher;
            if (accepted[i] || !(matcher = matchers.get(i)).isMatch(value, parent)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        LinkedHashMap params = Maps.newLinkedHashMap();
        if (this.fieldContracts.size() > 0) {
            params.put("fields", this.fieldContracts);
        }
        if (this.methodContracts.size() > 0) {
            params.put("methods", this.methodContracts);
        }
        if (this.constructorContracts.size() > 0) {
            params.put("constructors", this.constructorContracts);
        }
        if (this.baseclassContracts.size() > 0) {
            params.put("baseclasses", this.baseclassContracts);
        }
        if (this.interfaceContracts.size() > 0) {
            params.put("interfaces", this.interfaceContracts);
        }
        return "{\n  " + Joiner.on((String)", \n  ").join(params.entrySet()) + "\n}";
    }

    public static class Builder {
        private List<AbstractFuzzyMatcher<Field>> fieldContracts = Lists.newArrayList();
        private List<AbstractFuzzyMatcher<MethodInfo>> methodContracts = Lists.newArrayList();
        private List<AbstractFuzzyMatcher<MethodInfo>> constructorContracts = Lists.newArrayList();
        private List<AbstractFuzzyMatcher<Class<?>>> baseclassContracts = Lists.newArrayList();
        private List<AbstractFuzzyMatcher<Class<?>>> interfaceContracts = Lists.newArrayList();

        public Builder field(AbstractFuzzyMatcher<Field> matcher) {
            this.fieldContracts.add(matcher);
            return this;
        }

        public Builder field(FuzzyFieldContract.Builder builder) {
            return this.field(builder.build());
        }

        public Builder method(AbstractFuzzyMatcher<MethodInfo> matcher) {
            this.methodContracts.add(matcher);
            return this;
        }

        public Builder method(FuzzyMethodContract.Builder builder) {
            return this.method(builder.build());
        }

        public Builder constructor(AbstractFuzzyMatcher<MethodInfo> matcher) {
            this.constructorContracts.add(matcher);
            return this;
        }

        public Builder constructor(FuzzyMethodContract.Builder builder) {
            return this.constructor(builder.build());
        }

        public Builder baseclass(AbstractFuzzyMatcher<Class<?>> matcher) {
            this.baseclassContracts.add(matcher);
            return this;
        }

        public Builder baseclass(Builder builder) {
            return this.baseclass(builder.build());
        }

        public Builder interfaces(AbstractFuzzyMatcher<Class<?>> matcher) {
            this.interfaceContracts.add(matcher);
            return this;
        }

        public Builder interfaces(Builder builder) {
            return this.interfaces(builder.build());
        }

        public FuzzyClassContract build() {
            Collections.sort(this.fieldContracts);
            Collections.sort(this.methodContracts);
            Collections.sort(this.constructorContracts);
            Collections.sort(this.baseclassContracts);
            Collections.sort(this.interfaceContracts);
            return new FuzzyClassContract(this);
        }
    }
}

