/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.utility.ClassSource;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;

class CachedPackage {
    private final Map<String, Class<?>> cache;
    private final String packageName;
    private final ClassSource source;

    public CachedPackage(String packageName, ClassSource source) {
        this.packageName = packageName;
        this.cache = Maps.newConcurrentMap();
        this.source = source;
    }

    public void setPackageClass(String className, Class<?> clazz) {
        this.cache.put(className, clazz);
    }

    public Class<?> getPackageClass(String className) {
        try {
            Class<?> result = this.cache.get(Preconditions.checkNotNull((Object)className, (Object)"className cannot be NULL"));
            if (result == null) {
                result = this.source.loadClass(CachedPackage.combine(this.packageName, className));
                if (result == null) {
                    throw new IllegalArgumentException("Source " + this.source + " returned NULL for " + className);
                }
                this.cache.put(className, result);
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find class " + className, e);
        }
    }

    public static String combine(String packageName, String className) {
        if (Strings.isNullOrEmpty((String)packageName)) {
            return className;
        }
        if (Strings.isNullOrEmpty((String)className)) {
            return packageName;
        }
        return packageName + "." + className;
    }
}

