/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import java.util.Map;

public abstract class ClassSource {
    public static ClassSource fromClassLoader() {
        return ClassSource.fromClassLoader(ClassSource.class.getClassLoader());
    }

    public static ClassSource fromPackage(String packageName) {
        return ClassSource.fromClassLoader().usingPackage(packageName);
    }

    public static ClassSource fromClassLoader(final ClassLoader loader) {
        return new ClassSource(){

            @Override
            public Class<?> loadClass(String canonicalName) throws ClassNotFoundException {
                return loader.loadClass(canonicalName);
            }
        };
    }

    public static ClassSource fromMap(final Map<String, Class<?>> map) {
        return new ClassSource(){

            @Override
            public Class<?> loadClass(String canonicalName) throws ClassNotFoundException {
                return (Class)map.get(canonicalName);
            }
        };
    }

    public ClassSource retry(final ClassSource other) {
        return new ClassSource(){

            @Override
            public Class<?> loadClass(String canonicalName) throws ClassNotFoundException {
                try {
                    return ClassSource.this.loadClass(canonicalName);
                }
                catch (ClassNotFoundException e) {
                    return other.getClass();
                }
            }
        };
    }

    public ClassSource usingPackage(final String packageName) {
        return new ClassSource(){

            @Override
            public Class<?> loadClass(String canonicalName) throws ClassNotFoundException {
                return ClassSource.this.loadClass(4.append(packageName, canonicalName));
            }
        };
    }

    protected static String append(String a, String b) {
        boolean left = a.endsWith(".");
        boolean right = b.endsWith(".");
        if (left && right) {
            return a.substring(0, a.length() - 1) + b;
        }
        if (left != right) {
            return a + b;
        }
        return a + "." + b;
    }

    public abstract Class<?> loadClass(String var1) throws ClassNotFoundException;
}

