/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.google.common.base.Objects;
import java.util.UUID;
import net.minecraft.util.com.mojang.authlib.GameProfile;
import org.apache.commons.lang.StringUtils;

public class WrappedGameProfile
extends AbstractWrapper {
    private static final ConstructorAccessor CREATE_STRING_STRING = Accessors.getConstructorAccessorOrNull(GameProfile.class, String.class, String.class);
    private static final FieldAccessor GET_UUID_STRING = Accessors.getFieldAcccessorOrNull(GameProfile.class, "id", String.class);

    private WrappedGameProfile(Object profile) {
        super(GameProfile.class);
        this.setHandle(profile);
    }

    public WrappedGameProfile(String id, String name) {
        super(GameProfile.class);
        if (CREATE_STRING_STRING != null) {
            this.setHandle(CREATE_STRING_STRING.invoke(id, name));
        } else {
            this.setHandle(new GameProfile(WrappedGameProfile.parseUUID(id, name), name));
        }
    }

    private static UUID parseUUID(String id, String name) {
        if (id == null) {
            return null;
        }
        try {
            int missing;
            if (StringUtils.isBlank((String)id)) {
                id = "0";
            }
            if ((missing = 4 - StringUtils.countMatches((String)id, (String)"-")) > 0) {
                id = id + StringUtils.repeat((String)"-0", (int)missing);
            }
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot construct profile [" + id + ", " + name + "]", e);
        }
    }

    public WrappedGameProfile(UUID uuid, String name) {
        super(GameProfile.class);
        if (CREATE_STRING_STRING != null) {
            this.setHandle(CREATE_STRING_STRING.invoke(uuid != null ? uuid.toString() : null, name));
        } else {
            this.setHandle(new GameProfile(uuid, name));
        }
    }

    public static WrappedGameProfile fromHandle(Object handle) {
        if (handle == null) {
            return null;
        }
        return new WrappedGameProfile(handle);
    }

    public String getId() {
        if (GET_UUID_STRING != null) {
            return (String)GET_UUID_STRING.get(this.handle);
        }
        GameProfile profile = this.getProfile();
        return profile.getId() != null ? profile.getId().toString() : null;
    }

    public String getName() {
        return this.getProfile().getName();
    }

    private GameProfile getProfile() {
        return (GameProfile)this.handle;
    }

    public WrappedGameProfile withName(String name) {
        return new WrappedGameProfile(this.getId(), name);
    }

    public WrappedGameProfile withId(String id) {
        return new WrappedGameProfile(id, this.getName());
    }

    public boolean isComplete() {
        return this.getProfile().isComplete();
    }

    public String toString() {
        return String.valueOf(this.getProfile());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getName()});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WrappedGameProfile) {
            WrappedGameProfile other = (WrappedGameProfile)obj;
            return Objects.equal((Object)this.getProfile(), (Object)other.getProfile());
        }
        return false;
    }
}

