/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.APIRegistrationController;
import mc.alk.arena.controllers.ArenaEditor;
import mc.alk.arena.controllers.BAEventController;
import mc.alk.arena.controllers.BattleArenaController;
import mc.alk.arena.controllers.BukkitInterface;
import mc.alk.arena.controllers.CompetitionController;
import mc.alk.arena.controllers.DuelController;
import mc.alk.arena.controllers.EventController;
import mc.alk.arena.controllers.EventScheduler;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.controllers.PlayerController;
import mc.alk.arena.controllers.RoomController;
import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.controllers.TeamController;
import mc.alk.arena.controllers.TeleportController;
import mc.alk.arena.controllers.WatchController;
import mc.alk.arena.executors.ArenaEditorExecutor;
import mc.alk.arena.executors.BAExecutor;
import mc.alk.arena.executors.BASchedulerExecutor;
import mc.alk.arena.executors.BattleArenaDebugExecutor;
import mc.alk.arena.executors.BattleArenaExecutor;
import mc.alk.arena.executors.CustomCommandExecutor;
import mc.alk.arena.executors.TeamExecutor;
import mc.alk.arena.listeners.BAPlayerListener;
import mc.alk.arena.listeners.BAPluginListener;
import mc.alk.arena.listeners.BASignListener;
import mc.alk.arena.listeners.SignUpdateListener;
import mc.alk.arena.listeners.competition.InArenaListener;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.victoryconditions.AllKills;
import mc.alk.arena.objects.victoryconditions.Custom;
import mc.alk.arena.objects.victoryconditions.HighestKills;
import mc.alk.arena.objects.victoryconditions.InfiniteLives;
import mc.alk.arena.objects.victoryconditions.KillLimit;
import mc.alk.arena.objects.victoryconditions.LastManStanding;
import mc.alk.arena.objects.victoryconditions.MobKills;
import mc.alk.arena.objects.victoryconditions.NLives;
import mc.alk.arena.objects.victoryconditions.NoTeamsLeft;
import mc.alk.arena.objects.victoryconditions.OneTeamLeft;
import mc.alk.arena.objects.victoryconditions.PlayerKills;
import mc.alk.arena.objects.victoryconditions.TimeLimit;
import mc.alk.arena.objects.victoryconditions.VictoryType;
import mc.alk.arena.serializers.ArenaControllerSerializer;
import mc.alk.arena.serializers.ArenaSerializer;
import mc.alk.arena.serializers.BAClassesSerializer;
import mc.alk.arena.serializers.BAConfigSerializer;
import mc.alk.arena.serializers.BaseConfig;
import mc.alk.arena.serializers.EventScheduleSerializer;
import mc.alk.arena.serializers.MessageSerializer;
import mc.alk.arena.serializers.SignSerializer;
import mc.alk.arena.serializers.SpawnSerializer;
import mc.alk.arena.serializers.StateFlagSerializer;
import mc.alk.arena.serializers.TeamHeadSerializer;
import mc.alk.arena.serializers.YamlFileUpdater;
import mc.alk.arena.util.FileLogger;
import mc.alk.arena.util.FileUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.PlayerUtil;
import mc.alk.mc.battleplugins.api.BattlePluginsAPI;
import mc.alk.mc.updater.FileUpdater;
import mc.alk.mc.updater.PluginUpdater;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattleArena
extends JavaPlugin {
    private static String pluginname;
    private static String version;
    private static BattleArena plugin;
    private static BattleArenaController arenaController;
    static BAEventController eventController;
    private static final TeamController tc;
    private static final EventController ec;
    private static final ArenaEditor aac;
    private static final DuelController dc;
    private static BAExecutor commandExecutor;
    private ArenaEditorExecutor arenaEditorExecutor;
    private final BAPlayerListener playerListener = new BAPlayerListener(arenaController);
    private final BAPluginListener pluginListener = new BAPluginListener();
    private final SignUpdateListener signUpdateListener = new SignUpdateListener();
    private final BASignListener signListener = new BASignListener(this.signUpdateListener);
    private final WatchController watchController = new WatchController();
    private ArenaControllerSerializer arenaControllerSerializer;
    private static final BAConfigSerializer baConfigSerializer;
    private static final BAClassesSerializer classesSerializer;
    private static final EventScheduleSerializer eventSchedulerSerializer;
    private static final SignSerializer signSerializer;
    private static final int bukkitId = 43134;
    private BattlePluginsAPI bpapi;

    public void onEnable() {
        plugin = this;
        PluginDescriptionFile pdfFile = this.getDescription();
        pluginname = pdfFile.getName();
        version = pdfFile.getVersion();
        Log.setLogger(this.getLogger());
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        MessageUtil.sendMessage((CommandSender)sender, "&4[" + pluginname + "] &6v" + version + "&f enabling!");
        BukkitInterface.setServer(Bukkit.getServer());
        arenaController = new BattleArenaController(this.signUpdateListener);
        final File dir = this.getDataFolder();
        FileUpdater.makeIfNotExists(dir);
        FileUpdater.makeIfNotExists(new File(dir + "/competitions"));
        FileUpdater.makeIfNotExists(new File(dir + "/messages"));
        FileUpdater.makeIfNotExists(new File(dir + "/saves"));
        FileUpdater.makeIfNotExists(new File(dir + "/modules"));
        FileUpdater.makeIfNotExists(new File(dir + "/otherPluginConfigs"));
        FileUpdater.makeIfNotExists(new File(dir + "/victoryConditions"));
        for (String c : new String[]{"HeroesConfig", "McMMOConfig", "WorldGuardConfig"}) {
            try {
                new BaseConfig(FileUtil.load(clazz, dir.getPath() + "/otherPluginConfigs/" + c + ".yml", "/default_files/otherPluginConfigs/" + c + ".yml"));
            }
            catch (Exception e) {
                Log.err("Couldn't load File " + dir.getPath() + "/otherPluginConfigs/" + c + ".yml");
                Log.printStackTrace(e);
            }
        }
        for (String c : new String[]{"AllKills", "KillLimit", "MobKills", "PlayerKills"}) {
            try {
                new BaseConfig(FileUtil.load(clazz, dir.getPath() + "/victoryConditions/" + c + ".yml", "/default_files/victoryConditions/" + c + ".yml"));
            }
            catch (Exception e) {
                Log.err("Couldn't load File " + dir.getPath() + "/otherPluginConfigs/" + c + ".yml");
                Log.printStackTrace(e);
            }
        }
        YamlFileUpdater yfu = new YamlFileUpdater((Plugin)this);
        MessageSerializer defaultMessages = new MessageSerializer("default", null);
        defaultMessages.setConfig(FileUtil.load(clazz, dir.getPath() + "/messages.yml", "/default_files/messages.yml"));
        yfu.updateMessageSerializer((Plugin)plugin, defaultMessages);
        defaultMessages.loadAll();
        MessageSerializer.setDefaultConfig(defaultMessages);
        commandExecutor = new BAExecutor();
        eventController = new BAEventController();
        this.pluginListener.loadAll();
        this.arenaControllerSerializer = new ArenaControllerSerializer();
        Bukkit.getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.pluginListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.signListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)tc, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new TeleportController(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)InArenaListener.INSTANCE, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.signUpdateListener, (Plugin)this);
        VictoryType.register(LastManStanding.class, (Plugin)this);
        VictoryType.register(NLives.class, (Plugin)this);
        VictoryType.register(InfiniteLives.class, (Plugin)this);
        VictoryType.register(TimeLimit.class, (Plugin)this);
        VictoryType.register(OneTeamLeft.class, (Plugin)this);
        VictoryType.register(NoTeamsLeft.class, (Plugin)this);
        VictoryType.register(PlayerKills.class, (Plugin)this);
        VictoryType.register(MobKills.class, (Plugin)this);
        VictoryType.register(AllKills.class, (Plugin)this);
        VictoryType.register(KillLimit.class, (Plugin)this);
        VictoryType.register(Custom.class, (Plugin)this);
        VictoryType.register(HighestKills.class, (Plugin)this);
        baConfigSerializer.setConfig(FileUtil.load(clazz, dir.getPath() + "/config.yml", "/default_files/config.yml"));
        try {
            YamlFileUpdater.updateBaseConfig((Plugin)this, baConfigSerializer);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        baConfigSerializer.loadDefaults();
        classesSerializer.setConfig(FileUtil.load(clazz, dir.getPath() + "/classes.yml", "/default_files/classes.yml"));
        classesSerializer.loadAll();
        SpawnSerializer ss = new SpawnSerializer();
        ss.setConfig(FileUtil.load(clazz, dir.getPath() + "/spawns.yml", "/default_files/spawns.yml"));
        TeamHeadSerializer ts = new TeamHeadSerializer();
        ts.setConfig(FileUtil.load(clazz, dir.getPath() + "/teamConfig.yml", "/default_files/teamConfig.yml"));
        ts.loadAll();
        this.arenaEditorExecutor = new ArenaEditorExecutor();
        this.getCommand("watch").setExecutor((CommandExecutor)commandExecutor);
        this.getCommand("team").setExecutor((CommandExecutor)new TeamExecutor(commandExecutor));
        this.getCommand("arenaAlter").setExecutor((CommandExecutor)this.arenaEditorExecutor);
        this.getCommand("battleArena").setExecutor((CommandExecutor)new BattleArenaExecutor());
        this.getCommand("battleArenaDebug").setExecutor((CommandExecutor)new BattleArenaDebugExecutor());
        final EventScheduler es = new EventScheduler();
        this.getCommand("battleArenaScheduler").setExecutor((CommandExecutor)new BASchedulerExecutor(es));
        eventSchedulerSerializer.setConfig(dir.getPath() + "/saves/scheduledEvents.yml");
        eventSchedulerSerializer.addScheduler(es);
        this.createMessageSerializers();
        FileLogger.init();
        Scheduler.scheduleSynchronousTask((Plugin)this, new Runnable(){

            public void run() {
                baConfigSerializer.loadVictoryConditions();
                baConfigSerializer.loadCompetitions();
                StateFlagSerializer sfs = new StateFlagSerializer();
                sfs.setConfig(dir.getPath() + "/saves/state.yml");
                commandExecutor.setDisabled(sfs.loadEnabled());
                ArenaSerializer.setBAC(arenaController);
                sfs.loadLobbyStates(RoomController.getLobbies());
                sfs.loadContainerStates(arenaController.getArenas());
                BattleArena.this.arenaControllerSerializer.load();
                signSerializer.setConfig(dir.getPath() + "/saves/signs.yml");
                signSerializer.loadAll(BattleArena.this.signUpdateListener);
                BattleArena.this.signUpdateListener.updateAllSigns();
                eventSchedulerSerializer.loadAll();
                if (Defaults.START_NEXT) {
                    es.startNext();
                } else if (Defaults.START_CONTINUOUS) {
                    es.start();
                }
            }
        });
        this.bpapi = new BattlePluginsAPI();
        PluginUpdater.update((Plugin)this, 43134, this.getFile(), Defaults.AUTO_UPDATE, Defaults.ANNOUNCE_UPDATE);
        Log.info("&4[" + pluginname + "] &6v" + version + "&f enabled!");
    }

    public void onDisable() {
        arenaController.stop();
        this.arenaControllerSerializer.save();
        eventSchedulerSerializer.saveScheduledEvents();
        signSerializer.saveAll(this.signUpdateListener);
        StateFlagSerializer sfs = new StateFlagSerializer();
        sfs.setConfig(this.getDataFolder().getPath() + "/saves/state.yml");
        sfs.save(commandExecutor.getDisabled(), RoomController.getLobbies(), arenaController.getArenas());
        FileLogger.saveAll();
    }

    public static void update(Plugin plugin, int bukkitId, File file, UpdateOption updateOption, AnnounceUpdateOption announceOption) {
        new APIRegistrationController().update(plugin, bukkitId, file, updateOption, announceOption);
    }

    public BattlePluginsAPI getBattlePluginsAPI() {
        return this.bpapi;
    }

    public WatchController getWatchController() {
        return this.watchController;
    }

    private void createMessageSerializers() {
        File f = new File(this.getDataFolder() + "/messages");
        if (!f.exists()) {
            try {
                if (!f.mkdir()) {
                    Log.err("Messages folder could not be created!");
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
        for (MatchParams mp : ParamController.getAllParams()) {
            String fileName = "defaultMessages.yml";
            MessageSerializer ms = new MessageSerializer(mp.getName(), null);
            ms.setConfig(FileUtil.load(((Object)((Object)this)).getClass(), f.getAbsolutePath() + "/" + mp.getName() + "Messages.yml", "/default_files/" + fileName));
            ms.loadAll();
            MessageSerializer.addMessageSerializer(mp.getName(), ms);
        }
    }

    public static BattleArena getSelf() {
        return plugin;
    }

    public static BattleArenaController getBAController() {
        return arenaController;
    }

    public static BAEventController getBAEventController() {
        return eventController;
    }

    public static TeamController getTeamController() {
        return tc;
    }

    public static DuelController getDuelController() {
        return dc;
    }

    public static EventController getEventController() {
        return ec;
    }

    public static ArenaEditor getArenaEditor() {
        return aac;
    }

    public static BAExecutor getBAExecutor() {
        return commandExecutor;
    }

    public static boolean inSystem(Player player, boolean showReasons) {
        return !BattleArena.getBAExecutor().canJoin(BattleArena.toArenaPlayer(player), showReasons);
    }

    public static boolean inCompetition(Player player) {
        return BattleArena.toArenaPlayer(player).getCompetition() != null;
    }

    public static boolean inArena(Player player) {
        return InArenaListener.inArena(PlayerUtil.getID(player));
    }

    public static boolean inArena(ArenaPlayer player) {
        return InArenaListener.inArena(player.getID());
    }

    public void reloadConfig() {
        super.reloadConfig();
        baConfigSerializer.loadDefaults();
        classesSerializer.loadAll();
        MessageSerializer.loadDefaults();
    }

    public BAConfigSerializer getBAConfigSerializer() {
        return baConfigSerializer;
    }

    public void reloadCompetitions() {
        CompetitionController.reloadCompetitions();
    }

    public static String getNameAndVersion() {
        return "[" + pluginname + "_v" + version + "]";
    }

    public static String getPluginName() {
        return "[" + pluginname + "]";
    }

    public static void saveArenas(Plugin plugin) {
        ArenaSerializer.saveArenas(plugin);
    }

    public static void saveArenas() {
        ArenaSerializer.saveAllArenas(false);
    }

    public static void saveArenas(boolean log) {
        ArenaSerializer.saveAllArenas(log);
    }

    public void loadArenas() {
        ArenaSerializer.loadAllArenas();
    }

    public static ArenaPlayer toArenaPlayer(Player player) {
        return PlayerController.toArenaPlayer(player);
    }

    public static Set<ArenaPlayer> toArenaPlayerSet(Collection<Player> players) {
        return PlayerController.toArenaPlayerSet(players);
    }

    public static List<ArenaPlayer> toArenaPlayerList(Collection<Player> players) {
        return PlayerController.toArenaPlayerList(players);
    }

    public static Set<Player> toPlayerSet(Collection<ArenaPlayer> players) {
        return PlayerController.toPlayerSet(players);
    }

    public static List<Player> toPlayerList(Collection<ArenaPlayer> players) {
        return PlayerController.toPlayerList(players);
    }

    public static Arena getArena(String arenaName) {
        return BattleArena.getBAController().getArena(arenaName);
    }

    public static void registerCompetition(JavaPlugin plugin, String name, String cmd, Class<? extends Arena> arenaClass) {
        new APIRegistrationController().registerCompetition(plugin, name, cmd, arenaClass);
    }

    public static void registerCompetition(JavaPlugin plugin, String name, String cmd, Class<? extends Arena> arenaClass, CustomCommandExecutor executor) {
        new APIRegistrationController().registerCompetition(plugin, name, cmd, arenaClass, executor);
    }

    public File getModuleDirectory() {
        return new File(this.getDataFolder() + "/modules");
    }

    public ArenaEditorExecutor getArenaEditorExecutor() {
        return this.arenaEditorExecutor;
    }

    static {
        tc = TeamController.INSTANCE;
        ec = new EventController();
        aac = new ArenaEditor();
        dc = new DuelController();
        baConfigSerializer = new BAConfigSerializer();
        classesSerializer = new BAClassesSerializer();
        eventSchedulerSerializer = new EventScheduleSerializer();
        signSerializer = new SignSerializer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnnounceUpdateOption {
        NONE,
        CONSOLE,
        OPS;


        public static AnnounceUpdateOption fromString(String name) {
            try {
                return AnnounceUpdateOption.valueOf(name.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }

        public PluginUpdater.AnnounceUpdateOption toPluginUpdater() {
            return PluginUpdater.AnnounceUpdateOption.fromString(this.name());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UpdateOption {
        NONE,
        RELEASE,
        BETA,
        ALL;


        public static UpdateOption fromString(String name) {
            try {
                return UpdateOption.valueOf(name.toUpperCase());
            }
            catch (Exception e) {
                if (name.equalsIgnoreCase("ALPHA")) {
                    return ALL;
                }
                return null;
            }
        }

        public PluginUpdater.UpdateOption toPluginUpdater() {
            return PluginUpdater.UpdateOption.fromString(this.name());
        }
    }
}

