/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.competition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import mc.alk.arena.competition.TransitionController;
import mc.alk.arena.events.BAEvent;
import mc.alk.arena.events.CompetitionEvent;
import mc.alk.arena.listeners.PlayerHolder;
import mc.alk.arena.listeners.custom.MethodController;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.joining.JoinResponseHandler;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.teams.TeamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Competition
implements JoinResponseHandler,
PlayerHolder,
TeamHandler {
    protected List<ArenaTeam> teams = new CopyOnWriteArrayList<ArenaTeam>();
    protected final Set<UUID> leftPlayers = Collections.synchronizedSet(new HashSet());
    static int count = 0;
    protected final int id = count++;
    protected final MethodController methodController = new MethodController("id =" + this.id);

    public abstract Long getTime(CompetitionState var1);

    public int getID() {
        return this.id;
    }

    public abstract String getName();

    @Override
    public abstract CompetitionState getState();

    protected abstract void transitionTo(CompetitionState var1);

    public boolean playerLeft(ArenaPlayer player) {
        return this.leftPlayers.contains(player.getID());
    }

    @Override
    public abstract MatchParams getParams();

    public void setTeams(List<ArenaTeam> teams) {
        this.teams.clear();
        this.teams.addAll(teams);
        for (int i = 0; i < teams.size(); ++i) {
            teams.get(i).setIndex(i);
        }
    }

    public List<ArenaTeam> getTeams() {
        return this.teams;
    }

    @Override
    public void callEvent(BAEvent event) {
        if (event instanceof CompetitionEvent && ((CompetitionEvent)event).getCompetition() == null) {
            ((CompetitionEvent)event).setCompetition(this);
        }
        this.methodController.callEvent(event);
    }

    public void addArenaListeners(Collection<ArenaListener> transitionListeners) {
        for (ArenaListener tl : transitionListeners) {
            this.addArenaListener(tl);
        }
    }

    protected void performTransition(MatchState state, ArenaPlayer player, ArenaTeam team, boolean onlyInMatch) {
        TransitionController.transition((PlayerHolder)this, (CompetitionState)state, player, team, onlyInMatch);
    }

    protected void performTransition(MatchState state, ArenaTeam team, boolean onlyInMatch) {
        TransitionController.transition((PlayerHolder)this, (CompetitionState)state, team, onlyInMatch);
    }

    protected void performTransition(MatchState state, Collection<ArenaTeam> teams, boolean onlyInMatch) {
        TransitionController.transition((PlayerHolder)this, (CompetitionState)state, teams, onlyInMatch);
    }

    @Override
    public ArenaTeam getTeam(ArenaPlayer player) {
        for (ArenaTeam t : this.teams) {
            if (!t.hasMember(player)) continue;
            return t;
        }
        return null;
    }

    public ArenaTeam getLeftTeam(ArenaPlayer player) {
        for (ArenaTeam t : this.teams) {
            if (!t.hasLeft(player)) continue;
            return t;
        }
        return null;
    }

    public ArenaTeam getTeam(int teamIndex) {
        return this.teams.size() <= teamIndex ? null : this.teams.get(teamIndex);
    }

    public boolean hasPlayer(ArenaPlayer player) {
        for (ArenaTeam t : this.teams) {
            if (!t.hasMember(player)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAlivePlayer(ArenaPlayer player) {
        for (ArenaTeam t : this.teams) {
            if (!t.hasAliveMember(player)) continue;
            return true;
        }
        return false;
    }

    public Set<ArenaPlayer> getPlayers() {
        HashSet<ArenaPlayer> players = new HashSet<ArenaPlayer>();
        for (ArenaTeam t : this.teams) {
            players.addAll(t.getPlayers());
        }
        return players;
    }
}

