/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.competition.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mc.alk.arena.BattleArena;
import mc.alk.arena.competition.Competition;
import mc.alk.arena.controllers.RoomController;
import mc.alk.arena.controllers.TeamController;
import mc.alk.arena.controllers.joining.AbstractJoinHandler;
import mc.alk.arena.controllers.joining.TeamJoinFactory;
import mc.alk.arena.controllers.messaging.EventMessageImpl;
import mc.alk.arena.controllers.messaging.EventMessager;
import mc.alk.arena.controllers.messaging.MessageHandler;
import mc.alk.arena.events.events.EventCancelEvent;
import mc.alk.arena.events.events.EventCompletedEvent;
import mc.alk.arena.events.events.EventFinishedEvent;
import mc.alk.arena.events.events.EventOpenEvent;
import mc.alk.arena.events.events.EventResultEvent;
import mc.alk.arena.events.events.EventStartEvent;
import mc.alk.arena.events.events.TeamJoinedEvent;
import mc.alk.arena.events.players.ArenaPlayerLeaveEvent;
import mc.alk.arena.events.players.ArenaPlayerTeleportEvent;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionResult;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.EventParams;
import mc.alk.arena.objects.EventState;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.exceptions.NeverWouldJoinException;
import mc.alk.arena.objects.joining.TeamJoinObject;
import mc.alk.arena.objects.messaging.EventMessageHandler;
import mc.alk.arena.objects.options.StateOptions;
import mc.alk.arena.objects.pairs.JoinResult;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Countdown;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.PermissionsUtil;
import mc.alk.arena.util.ServerUtil;
import mc.alk.arena.util.TimeUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Event
extends Competition
implements Countdown.CountdownCallback,
ArenaListener {
    final String name;
    protected EventParams eventParams;
    EventMessager mc;
    Countdown timer;
    protected AbstractJoinHandler joinHandler;
    protected EventState state;
    final Map<EventState, Long> times = new EnumMap<EventState, Long>(EventState.class);

    public Event(EventParams params) throws NeverWouldJoinException {
        this.eventParams = params;
        this.transitionTo(EventState.CLOSED);
        this.name = params.getName();
        this.joinHandler = TeamJoinFactory.createTeamJoinHandler((MatchParams)params, this);
        if (this.mc == null) {
            this.mc = new EventMessager(this);
        }
        this.mc.setMessageHandler(new EventMessageImpl(this));
    }

    public void openEvent() {
        this.teams.clear();
        EventOpenEvent event = new EventOpenEvent(this);
        this.callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        this.stopTimer();
        this.transitionTo(EventState.OPEN);
        this.mc.sendEventOpenMsg();
    }

    public void autoEvent() {
        this.openEvent();
        TimeUtil.testClock();
        this.mc.sendCountdownTillEvent(this.eventParams.getSecondsTillStart());
        this.timer = new Countdown((Plugin)BattleArena.getSelf(), (long)this.eventParams.getSecondsTillStart().intValue(), (long)this.eventParams.getAnnouncementInterval().intValue(), (Countdown.CountdownCallback)this);
    }

    public void addAllOnline() {
        Player[] online;
        for (Player p : online = ServerUtil.getOnlinePlayers()) {
            if (PermissionsUtil.isAdmin((CommandSender)p)) continue;
            ArenaTeam t = TeamController.createTeam(this.eventParams, BattleArena.toArenaPlayer(p));
            TeamJoinObject tqo = new TeamJoinObject(t, this.eventParams, null);
            this.joining(tqo);
        }
    }

    @Override
    public void addArenaListener(ArenaListener arenaListener) {
        this.methodController.addListener(arenaListener);
    }

    @Override
    public boolean removeArenaListener(ArenaListener arenaListener) {
        return this.methodController.removeListener(arenaListener);
    }

    public void startEvent() {
        List<ArenaTeam> improper = this.joinHandler.removeImproperTeams();
        for (ArenaTeam t : improper) {
            t.sendMessage("&cYour team has been excluded to having an improper team size");
        }
        Set<ArenaPlayer> excludedPlayers = this.getExcludedPlayers();
        for (ArenaPlayer p : excludedPlayers) {
            p.sendMessage(Log.colorChat(this.eventParams.getPrefix() + "&6 &5There werent enough players to create a &6" + this.eventParams.getMinTeamSize() + "&5 person team"));
        }
        this.transitionTo(EventState.RUNNING);
        this.callEvent(new EventStartEvent(this, this.teams));
    }

    protected void setEventResult(CompetitionResult result, boolean announce) {
        if (announce) {
            if (result.hasVictor()) {
                this.mc.sendEventVictory(result.getVictors(), result.getLosers());
            } else {
                this.mc.sendEventDraw(result.getDrawers(), result.getLosers());
            }
        }
        this.callEvent(new EventResultEvent(this, result));
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public void cancelEvent() {
        this.eventCancelled();
    }

    public void eventCompleted() {
        this.callEvent(new EventCompletedEvent(this));
        this.endEvent();
    }

    protected void eventCancelled() {
        this.stopTimer();
        ArrayList<ArenaTeam> newTeams = new ArrayList<ArenaTeam>(this.teams);
        this.callEvent(new EventCancelEvent(this));
        this.mc.sendEventCancelled(newTeams);
        this.endEvent();
    }

    protected void endEvent() {
        if (this.state == EventState.CLOSED) {
            return;
        }
        this.transitionTo(EventState.CLOSED);
        this.stopTimer();
        this.removeAllTeams();
        this.teams.clear();
        this.joinHandler = null;
        this.callEvent(new EventFinishedEvent(this));
        HandlerList.unregisterAll((Listener)this);
    }

    public boolean canJoin() {
        return this.isOpen();
    }

    public boolean canJoin(ArenaTeam t) {
        return this.isOpen();
    }

    @Override
    public abstract boolean canLeave(ArenaPlayer var1);

    @Override
    public EventState getState() {
        return this.state;
    }

    @Override
    protected void transitionTo(CompetitionState state) {
        this.state = (EventState)state;
        this.times.put(this.state, System.currentTimeMillis());
    }

    @Override
    public Long getTime(CompetitionState state) {
        return this.times.get(state);
    }

    @Override
    public boolean leave(ArenaPlayer p) {
        ArenaTeam t = this.getTeam(p);
        p.removeCompetition(this);
        if (this.eventParams.needsLobby()) {
            RoomController.leaveLobby(this.eventParams, p);
        }
        if (t == null) {
            return false;
        }
        t.playerLeft(p);
        return true;
    }

    public void removeAllTeams() {
        for (ArenaTeam t : this.teams) {
            for (ArenaPlayer p : t.getPlayers()) {
                p.removeCompetition(this);
            }
        }
        this.teams.clear();
    }

    @Override
    public boolean removedTeam(ArenaTeam team) {
        if (this.teams.remove(team)) {
            for (ArenaPlayer p : team.getPlayers()) {
                p.removeCompetition(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addedTeam(ArenaTeam team) {
        if (this.teams.contains(team)) {
            return true;
        }
        this.callEvent(new TeamJoinedEvent(this, team));
        return this.teams.add(team);
    }

    public JoinResult.JoinStatus joining(TeamJoinObject tqo) {
        ArenaTeam team = tqo.getTeam();
        if (this.joinHandler == null) {
            JoinResult.JoinStatus js = JoinResult.JoinStatus.NOTOPEN;
            return js;
        }
        AbstractJoinHandler.TeamJoinResult tjr = this.joinHandler.joiningTeam(tqo);
        switch (tjr.status) {
            case ADDED_TO_EXISTING: 
            case ADDED: {
                for (ArenaPlayer player : tqo.getTeam().getPlayers()) {
                    player.addCompetition(this);
                }
                this.mc.sendTeamJoined(tqo.getTeam());
                break;
            }
            case ADDED_STILL_NEEDS_PLAYERS: {
                this.mc.sendWaitingForMorePlayers(team, tjr.remaining);
                for (ArenaPlayer player : tqo.getTeam().getPlayers()) {
                    player.addCompetition(this);
                }
                break;
            }
            case CANT_FIT: {
                this.mc.sendCantFitTeam(team);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getCommand() {
        return this.eventParams.getCommand();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public boolean isRunning() {
        return this.state == EventState.RUNNING;
    }

    public boolean isOpen() {
        return this.state == EventState.OPEN;
    }

    public boolean isClosed() {
        return this.state == EventState.CLOSED;
    }

    public boolean isFinished() {
        return this.state == EventState.FINISHED;
    }

    @Override
    public EventParams getParams() {
        return this.eventParams;
    }

    public int getNTeams() {
        int size = 0;
        for (ArenaTeam t : this.teams) {
            if (t.size() <= 0) continue;
            ++size;
        }
        return size;
    }

    public void setTeamJoinHandler(AbstractJoinHandler tjh) {
        this.joinHandler = tjh;
    }

    public void setMessageHandler(EventMessageHandler handler) {
        this.mc.setMessageHandler(handler);
    }

    public EventMessageHandler getMessageHandler() {
        return this.mc.getMessageHandler();
    }

    public abstract String getResultString();

    protected Set<ArenaPlayer> getExcludedPlayers() {
        return this.joinHandler == null ? null : this.joinHandler.getExcludedPlayers();
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        if (this.eventParams != null) {
            boolean rated = this.eventParams.isRated();
            sb.append(rated ? "&4Rated" : "&aUnrated").append("&e ").append(this.name).append(". ");
            sb.append("&e(&6").append(this.state).append("&e)");
            sb.append("&eTeam size=").append(this.eventParams.getTeamSize());
            sb.append("&e Teams=&6 ").append(this.teams.size());
        }
        if (this.state == EventState.OPEN && this.joinHandler != null) {
            sb.append("\n&eJoiningTeams: ").append(MessageUtil.joinPlayers(this.joinHandler.getExcludedPlayers(), ", "));
        }
        return sb.toString();
    }

    public String getInfo() {
        return StateOptions.getInfo(this.eventParams, this.eventParams.getName());
    }

    public boolean canLeaveTeam(ArenaPlayer p) {
        return this.canLeave(p);
    }

    public void broadcast(String msg) {
        for (ArenaTeam t : this.teams) {
            t.sendMessage(msg);
        }
    }

    public Long getTimeTillStart() {
        if (this.timer == null) {
            return null;
        }
        return this.timer.getTimeRemaining();
    }

    @Override
    public boolean intervalTick(int remaining) {
        if (!this.isOpen()) {
            return false;
        }
        if (remaining == 0) {
            if (this.hasEnough()) {
                this.startEvent();
            } else {
                this.mc.sendEventCancelledDueToLackOfPlayers(this.getPlayers());
                this.cancelEvent();
            }
        } else {
            this.mc.sendCountdownTillEvent(remaining);
        }
        return true;
    }

    @Override
    public Set<ArenaPlayer> getPlayers() {
        HashSet<ArenaPlayer> players = new HashSet<ArenaPlayer>();
        for (ArenaTeam t : this.getTeams()) {
            players.addAll(t.getPlayers());
        }
        if (this.isOpen() && this.joinHandler != null) {
            players.addAll(this.joinHandler.getExcludedPlayers());
        }
        return players;
    }

    public void setSilent(boolean silent) {
        this.mc.setSilent(silent);
    }

    public String toString() {
        return "[" + this.getName() + ":" + this.id + "]";
    }

    public boolean waitingToJoin(ArenaPlayer p) {
        return this.joinHandler != null && this.joinHandler.getExcludedPlayers().contains(p);
    }

    public boolean hasEnoughTeams() {
        return this.getNTeams() >= this.eventParams.getMinTeams();
    }

    public boolean hasEnough() {
        return this.joinHandler != null && this.joinHandler.hasEnough(Integer.MAX_VALUE);
    }

    @Override
    public void addedToTeam(ArenaTeam team, Collection<ArenaPlayer> players) {
    }

    @Override
    public void addedToTeam(ArenaTeam team, ArenaPlayer player) {
    }

    @Override
    public void removedFromTeam(ArenaTeam team, Collection<ArenaPlayer> players) {
    }

    @Override
    public void removedFromTeam(ArenaTeam team, ArenaPlayer player) {
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void onPreJoin(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPostJoin(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPreQuit(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPostQuit(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        player.removeCompetition(this);
    }

    @Override
    public void onPreEnter(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPostEnter(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPreLeave(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPostLeave(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onArenaPlayerLeaveEvent(ArenaPlayerLeaveEvent event) {
        if (this.hasPlayer(event.getPlayer())) {
            event.addMessage(MessageHandler.getSystemMessage("you_left_event", this.getName()));
            this.leave(event.getPlayer());
        }
    }

    @Override
    public boolean hasOption(StateOption option) {
        return this.getParams().hasOptionAt((CompetitionState)this.state, option);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TeamSizeComparator
    implements Comparator<ArenaTeam> {
        @Override
        public int compare(ArenaTeam arg0, ArenaTeam arg1) {
            if (arg0.size() == arg1.size()) {
                return 0;
            }
            return arg0.size() < arg1.size() ? -1 : 1;
        }
    }
}

