/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.competition.events.tournament;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import mc.alk.arena.BattleArena;
import mc.alk.arena.competition.TransitionController;
import mc.alk.arena.competition.events.Event;
import mc.alk.arena.competition.events.tournament.Round;
import mc.alk.arena.competition.events.tournament.TournamentTransition;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.controllers.BattleArenaController;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.controllers.joining.TeamJoinFactory;
import mc.alk.arena.controllers.plugins.TrackerController;
import mc.alk.arena.events.events.tournaments.TournamentRoundEvent;
import mc.alk.arena.events.matches.MatchCancelledEvent;
import mc.alk.arena.events.matches.MatchCompletedEvent;
import mc.alk.arena.events.matches.MatchCreatedEvent;
import mc.alk.arena.listeners.PlayerHolder;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionResult;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.EventParams;
import mc.alk.arena.objects.EventState;
import mc.alk.arena.objects.LocationType;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchResult;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.Matchup;
import mc.alk.arena.objects.StateGraph;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.exceptions.NeverWouldJoinException;
import mc.alk.arena.objects.joining.MatchTeamQObject;
import mc.alk.arena.objects.options.EventOpenOptions;
import mc.alk.arena.objects.options.JoinOptions;
import mc.alk.arena.objects.options.StateOptions;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.objects.stats.ArenaStat;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.TimeUtil;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TournamentEvent
extends Event
implements Listener,
ArenaListener {
    public long timeBetweenRounds;
    int curRound = -1;
    int nrounds = -1;
    boolean preliminary_round = false;
    ArrayList<ArenaTeam> aliveTeams = new ArrayList();
    ArrayList<ArenaTeam> competingTeams = new ArrayList();
    final EventParams singleGameParms;
    Random rand = new Random();
    Integer curTimer = null;
    Map<Match, Matchup> matchups = Collections.synchronizedMap(new HashMap());
    Set<Matchup> incompleteMatchups = new HashSet<Matchup>();
    final ArrayList<Round> rounds = new ArrayList();

    public TournamentEvent(EventParams params, EventOpenOptions eoo) throws NeverWouldJoinException {
        super(params);
        this.singleGameParms = new EventParams(eoo.getParams());
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BattleArena.getSelf());
        this.timeBetweenRounds = params.getTimeBetweenRounds().intValue();
        ChatColor color = MessageUtil.getFirstColor(this.singleGameParms.getPrefix());
        params.setTeamSize(this.singleGameParms.getTeamSize());
        String str = color + "[" + this.singleGameParms.getName() + " " + params.getName() + "]";
        params.setPrefix(str);
        this.singleGameParms.setPrefix(str);
        str = this.singleGameParms.getName() + " " + params.getName();
        params.setName(str);
        this.singleGameParms.setName(str);
        this.setTeamJoinHandler(TeamJoinFactory.createTeamJoinHandler((MatchParams)params, this));
    }

    @Override
    public void openEvent() {
        super.openEvent();
        this.aliveTeams.clear();
        this.competingTeams.clear();
        this.rounds.clear();
        this.curRound = -1;
        this.nrounds = -1;
        this.joinHandler.removeImproperTeams();
    }

    static int getNTeams(Collection<ArenaTeam> teams) {
        int size = 0;
        for (ArenaTeam at : teams) {
            if (at == null || at.size() <= 0) continue;
            ++size;
        }
        return size;
    }

    @Override
    public void startEvent() {
        super.startEvent();
        Server server = Bukkit.getServer();
        int osize = TournamentEvent.getNTeams(this.teams);
        this.nrounds = this.calcNRounds(osize);
        int minTeams = this.eventParams.getMinTeams();
        int roundteams = (int)Math.pow(minTeams, this.nrounds);
        server.broadcastMessage(Log.colorChat(this.eventParams.getPrefix() + "&e The " + this.singleGameParms.getName() + " is starting!"));
        TreeMap sortTeams = new TreeMap(Collections.reverseOrder());
        TrackerController sc = new TrackerController(this.eventParams);
        for (ArenaTeam t : this.teams) {
            if (t.size() <= 0) continue;
            ArenaStat stat = sc.loadRecord(t);
            Double elo = stat.getRating();
            while (sortTeams.containsKey(elo)) {
                elo = elo + 1.0E-4;
            }
            sortTeams.put(elo, t);
        }
        this.teams.clear();
        this.aliveTeams.clear();
        ArrayList ts = new ArrayList(sortTeams.values());
        for (ArenaTeam t : ts) {
            this.teams.add(t);
            this.aliveTeams.add(t);
            this.competingTeams.add(t);
        }
        this.removeExtraneous();
        boolean bl = this.preliminary_round = this.teams.size() != roundteams;
        if (this.preliminary_round) {
            ++this.nrounds;
        }
        server.broadcastMessage(Log.colorChat(this.eventParams.getPrefix() + "&6 " + this.teams.size() + " &e" + MessageUtil.getTeamsOrPlayers(this.teams.size()) + " will compete in a &6" + this.nrounds + "&e round tournament"));
        if (this.preliminary_round) {
            this.makePreliminaryRound();
        } else {
            this.makeNextRound();
        }
        this.startRound();
    }

    @ArenaEventHandler(end=MatchState.ONOPEN)
    public void onMatchCreatedEvent(MatchCreatedEvent event) {
        Matchup matchup = ((MatchTeamQObject)event.getOriginalObject().getOriginalQueuedObject()).getMatchup();
        this.matchups.put(event.getMatch(), matchup);
    }

    @ArenaEventHandler
    public void matchCompleted(MatchCompletedEvent event) {
        this.matchEnded(event.getMatch());
    }

    @ArenaEventHandler
    public void matchCancelled(MatchCancelledEvent event) {
        this.matchEnded(event.getMatch());
    }

    @Override
    public void endEvent() {
        super.endEvent();
        this.aliveTeams.clear();
        this.competingTeams.clear();
        this.matchups.clear();
        if (this.curTimer != null) {
            Bukkit.getScheduler().cancelTask(this.curTimer.intValue());
            this.curTimer = null;
        }
    }

    private void matchEnded(Match am) {
        if (this.state == EventState.CLOSED || this.state == EventState.FINISHED) {
            return;
        }
        Matchup m = this.matchups.get(am);
        if (m == null) {
            this.eventCancelled();
            Log.err("[BA Error] match completed but not found in tournament");
            return;
        }
        this.incompleteMatchups.remove(m);
        CompetitionResult nmr = this.createNewMatchResult(am);
        if (nmr.getVictors().isEmpty()) {
            return;
        }
        ArenaTeam victor = nmr.getVictors().iterator().next();
        m.setResult(nmr);
        for (ArenaTeam t : nmr.getLosers()) {
            super.removedTeam(t);
        }
        this.aliveTeams.removeAll(nmr.getLosers());
        if (this.incompleteMatchups.isEmpty()) {
            TimeUtil.testClock();
            if (this.curRound + 1 == this.nrounds || this.isFinished()) {
                HashSet<ArenaTeam> losers = new HashSet<ArenaTeam>(this.competingTeams);
                losers.remove(victor);
                HashSet<ArenaTeam> victors = new HashSet<ArenaTeam>(Arrays.asList(victor));
                MatchResult result = new MatchResult();
                result.setVictors(victors);
                this.setEventResult(result, true);
                TransitionController.transition((PlayerHolder)am, (CompetitionState)TournamentTransition.FIRSTPLACE, victors, false);
                TransitionController.transition((PlayerHolder)am, (CompetitionState)TournamentTransition.PARTICIPANTS, losers, false);
                this.eventCompleted();
            } else {
                this.callEvent(new TournamentRoundEvent(this, this.curRound));
                this.makeNextRound();
                this.startRound();
            }
        }
    }

    private CompetitionResult createNewMatchResult(Match match) {
        CompetitionResult nmr;
        MatchResult r = match.getResult();
        if (r.isDraw() || r.isUnknown()) {
            nmr = this.createRandomWinner(r.getDrawers(), match);
            nmr.addLosers(r.getLosers());
        } else if (r.hasVictor() && r.getVictors().size() != 1) {
            nmr = this.createRandomWinner(r.getVictors(), match);
            nmr.addLosers(r.getLosers());
            nmr.addLosers(r.getDrawers());
        } else {
            nmr = r;
        }
        return nmr;
    }

    private CompetitionResult createRandomWinner(Collection<ArenaTeam> randos, Match match) {
        MatchResult mr = new MatchResult();
        ArenaTeam victor = null;
        ArrayList<ArenaTeam> ls = new ArrayList<ArenaTeam>();
        for (ArenaTeam at : randos) {
            if (at.size() == 0) continue;
            ls.add(at);
        }
        if (ls.isEmpty()) {
            ArenaPlayer v;
            ArrayList<ArenaPlayer> lp = new ArrayList<ArenaPlayer>();
            for (ArenaTeam at : match.getTeams()) {
                lp.addAll(at.getLeftPlayers());
            }
            ArenaPlayer arenaPlayer = v = lp.isEmpty() ? null : (ArenaPlayer)lp.get(this.rand.nextInt(lp.size()));
            if (v != null) {
                victor = match.getLeftTeam(v);
            }
            if (victor == null) {
                Log.err("[BattleArena] Tournament found a match with no players, cancelling tournament");
                this.cancelEvent();
                return mr;
            }
        } else {
            victor = (ArenaTeam)ls.get(this.rand.nextInt(ls.size()));
        }
        victor.sendMessage("&2You drew your match but have been randomly selected as the winner!");
        mr.setVictor(victor);
        HashSet<ArenaTeam> losers = new HashSet<ArenaTeam>(ls);
        losers.remove(victor);
        mr.addLosers(losers);
        for (ArenaTeam l : losers) {
            l.sendMessage("&cYou drew your match but someone else has been randomly selected as the winner!");
        }
        return mr;
    }

    private void removeExtraneous() {
        int minTeams = this.eventParams.getMinTeams();
        int needed_size = (int)Math.pow(minTeams, this.nrounds);
        int nprelims = (this.teams.size() - needed_size) / (minTeams - 1);
        int remaining = this.teams.size() - (needed_size + nprelims * (minTeams - 1));
        if (remaining > 0) {
            ArrayList<ArenaTeam> newTeams = new ArrayList<ArenaTeam>();
            for (int i = 0; i < remaining; ++i) {
                ArenaTeam t = (ArenaTeam)this.teams.get(needed_size + i);
                newTeams.add(t);
                t.sendMessage("&c[Tourney] There weren't enough players for you to compete in this tourney");
            }
            this.teams.removeAll(newTeams);
            this.aliveTeams.removeAll(newTeams);
        }
    }

    private void makePreliminaryRound() {
        ++this.curRound;
        this.incompleteMatchups.clear();
        Round tr = new Round(this.curRound);
        this.rounds.add(tr);
        int nrounds = this.calcNRounds(this.teams.size()) + 1;
        int minTeams = this.eventParams.getMinTeams();
        int needed_size = (int)Math.pow(minTeams, nrounds - 1);
        int nprelims = (this.aliveTeams.size() - needed_size) / (minTeams - 1);
        int loffset = needed_size - 1;
        int hoffset = needed_size;
        for (int i = 0; i < nprelims; ++i) {
            ArrayList<ArenaTeam> newTeams = new ArrayList<ArenaTeam>();
            for (int j = 0; j < minTeams / 2; ++j) {
                newTeams.add(this.aliveTeams.get(loffset));
                newTeams.add(this.aliveTeams.get(hoffset));
                --loffset;
                ++hoffset;
            }
            EventParams sgp = ParamController.copyParams(this.singleGameParms);
            JoinOptions jo = new JoinOptions();
            jo.setMatchParams(sgp);
            Matchup m = this.createMatchup(sgp, newTeams, jo);
            tr.addMatchup(m);
            this.incompleteMatchups.add(m);
        }
    }

    private Matchup createMatchup(EventParams matchupParams, Collection<ArenaTeam> teams, JoinOptions jo) {
        Matchup m = new Matchup(matchupParams, teams, jo);
        ArrayList<ArenaListener> li = this.methodController.getArenaListeners() != null ? new ArrayList<ArenaListener>(this.methodController.getArenaListeners()) : new ArrayList();
        for (ArenaListener al : li) {
            m.addArenaListener(al);
        }
        m.addArenaListener(this);
        return m;
    }

    private void makeNextRound() {
        ++this.curRound;
        this.incompleteMatchups.clear();
        Round tr = new Round(this.curRound);
        this.rounds.add(tr);
        int minTeams = this.eventParams.getMinTeams();
        int size = this.aliveTeams.size();
        int nMatches = size / minTeams;
        for (int i = 0; i < nMatches; ++i) {
            ArrayList<ArenaTeam> newTeams = new ArrayList<ArenaTeam>();
            for (int j = 0; j < minTeams / 2; ++j) {
                int index = i + j * nMatches;
                newTeams.add(this.aliveTeams.get(index));
                newTeams.add(this.aliveTeams.get(size - 1 - index));
            }
            JoinOptions jo = new JoinOptions();
            EventParams sgp = ParamController.copyParams(this.singleGameParms);
            jo.setMatchParams(sgp);
            Matchup m = this.createMatchup(sgp, newTeams, jo);
            tr.addMatchup(m);
            this.incompleteMatchups.add(m);
        }
    }

    public boolean startRound() {
        if (this.curRound < 0 || this.state == EventState.CLOSED) {
            return false;
        }
        this.announceRound();
        final BattleArenaController ac = BattleArena.getBAController();
        BattleArena plugin = BattleArena.getSelf();
        this.curTimer = Scheduler.scheduleSynchronousTask((Plugin)plugin, new Runnable(){

            public void run() {
                Round tr = TournamentEvent.this.rounds.get(TournamentEvent.this.curRound);
                for (Matchup m : tr.getMatchups()) {
                    ac.addMatchup(new MatchTeamQObject(m));
                }
            }
        }, this.timeBetweenRounds * 20L);
        return true;
    }

    private void announceRound() {
        String strround;
        Round tr = this.rounds.get(this.curRound);
        String string = strround = this.preliminary_round && this.curRound == 0 ? "PreliminaryRound" : "Round " + (this.curRound + 1);
        if (this.curRound + 1 == this.nrounds) {
            strround = "Final Round";
        }
        if (this.preliminary_round) {
            this.preliminary_round = false;
            int nprelims = tr.getMatchups().size() * this.eventParams.getMinTeams();
            for (int i = 0; i < this.aliveTeams.size() - nprelims; ++i) {
                ArenaTeam t = this.aliveTeams.get(i);
                t.sendMessage("&4[" + strround + "]&e You have a &5bye&e this round");
            }
        }
        TrackerController sc = new TrackerController(this.eventParams);
        String prefix = this.eventParams.getPrefix();
        if (tr.getMatchups().size() <= 8) {
            for (Matchup m : tr.getMatchups()) {
                ArrayList<String> names = new ArrayList<String>();
                for (ArenaTeam t : m.getTeams()) {
                    ArenaStat st = sc.loadRecord(t);
                    names.add("&8" + t.getDisplayName() + "&6[" + st.getRating() + "]");
                }
                String msg = "&e" + strround + ": " + StringUtils.join(names, (String)" vs ");
                if (55 > msg.length() + prefix.length()) {
                    this.broadcastAlive(prefix + " " + msg);
                    continue;
                }
                this.broadcastAlive(msg);
            }
        } else {
            this.broadcastAlive(prefix + "&e Round " + strround + " has " + tr.getMatchups().size() + " " + MessageUtil.teamsOrPlayers(this.eventParams.getMinTeamSize()) + " competing. &6/tourney status:&e for updates");
        }
        if (this.curRound != this.nrounds) {
            this.broadcast(prefix + "&e " + strround + " will start in &4" + this.timeBetweenRounds + " &eseconds!");
        } else {
            this.broadcast(prefix + "&e The " + strround + " will start in &4" + this.timeBetweenRounds + " &eseconds!");
        }
    }

    @Override
    public void broadcast(String msg) {
        for (ArenaTeam t : this.competingTeams) {
            t.sendMessage(msg);
        }
    }

    public void broadcastAlive(String msg) {
        for (ArenaTeam t : this.aliveTeams) {
            t.sendMessage(msg);
        }
    }

    @Override
    public void addedToTeam(ArenaTeam team, ArenaPlayer ap) {
        super.addedToTeam(team, ap);
        if (team.size() == 1) {
            this.announceTourneySize();
        }
    }

    @Override
    public boolean addedTeam(ArenaTeam team) {
        if (super.addedTeam(team)) {
            this.announceTourneySize();
            return true;
        }
        return false;
    }

    private void announceTourneySize() {
        int size = 0;
        for (ArenaTeam t : this.teams) {
            if (t.size() <= 0) continue;
            ++size;
        }
        int nrounds = this.calcNRounds(size);
        int idealteam = (int)Math.pow(this.eventParams.getMinTeams().intValue(), nrounds);
        if (nrounds > 1 && size % idealteam == 0) {
            MessageUtil.broadcastMessage(Log.colorChat(this.eventParams.getPrefix() + "&6" + size + " " + MessageUtil.getTeamsOrPlayers(this.teams.size()) + "&e have joined, Current tournament will have &6" + nrounds + "&e rounds"));
        }
    }

    public int getNrounds() {
        return this.nrounds;
    }

    private int calcNRounds(int size) {
        return (int)Math.floor(Math.log(size) / Math.log(this.eventParams.getMinTeams().intValue()));
    }

    @Override
    public boolean canLeave(ArenaPlayer p) {
        ArenaTeam t = this.getTeam(p);
        return this.isOpen() || t != null && !this.aliveTeams.contains(t);
    }

    @Override
    public String getStatus() {
        return this.getStatus(this.curRound);
    }

    public String getStatus(int round) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getStatus());
        if (round < 0) {
            return sb.toString();
        }
        sb.append("&e Alive Teams=&6 ").append(this.aliveTeams.size()).append("\n");
        Round tr = this.rounds.get(round);
        int ncomplete = tr.getCompleteMatchups().size();
        int total = tr.getMatchups().size();
        sb.append(this.preliminary_round && round == 0 ? "&ePreliminaryRound" : "&eRound");
        sb.append("&4 ").append(round + 1).append(" &eComplete Matches: &6 ").append(ncomplete).append("/").append(total);
        return sb.toString();
    }

    @Override
    public MatchState getMatchState() {
        return null;
    }

    @Override
    public boolean isHandled(ArenaPlayer player) {
        return false;
    }

    @Override
    public boolean checkReady(ArenaPlayer player, ArenaTeam team, StateOptions mo, boolean b) {
        return false;
    }

    @Override
    public SpawnLocation getSpawn(int index, boolean random) {
        return null;
    }

    @Override
    public LocationType getLocationType() {
        return LocationType.ARENA;
    }

    @Override
    public String getResultString() {
        StringBuilder sb = new StringBuilder();
        if (this.rounds.isEmpty()) {
            return "&eThere are no results yet";
        }
        if (!this.isFinished() && !this.isClosed()) {
            sb.append("&eEvent is still &6").append(this.state).append("\n");
        }
        boolean useRounds = this.rounds.size() > 1;
        for (int r = 0; r < this.rounds.size(); ++r) {
            Round round = this.rounds.get(r);
            if (useRounds) {
                sb.append("&5***&4 Round ").append(r + 1).append("&5 ***\n");
            }
            boolean useMatchups = round.getMatchups().size() > 1;
            for (Matchup m : round.getMatchups()) {
                CompetitionResult result;
                if (useMatchups) {
                    sb.append("&4Matchup :");
                }
                if ((result = m.getResult()) == null || result.getVictors() == null) {
                    for (ArenaTeam t : m.getTeams()) {
                        sb.append(t.getTeamSummary()).append(" ");
                    }
                    sb.append("\n");
                    continue;
                }
                sb.append(result.toPrettyString()).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        StateGraph so = this.singleGameParms.getStateOptions();
        sb.append(StateOptions.getInfo(this.singleGameParms, this.singleGameParms.getName()));
        String firstPlacePrizes = so.getGiveString(TournamentTransition.FIRSTPLACE);
        String participantPrizes = so.getGiveString(TournamentTransition.PARTICIPANTS);
        if (participantPrizes != null) {
            sb.append("\n&ePrize for &6participation:&e ").append(participantPrizes);
        }
        if (firstPlacePrizes != null) {
            sb.append("\n&ePrize for getting &b1st &eplace:");
            sb.append(firstPlacePrizes);
        }
        return sb.toString();
    }
}

