/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.competition.match;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.controllers.ArenaClassController;
import mc.alk.arena.controllers.RoomController;
import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.controllers.TeleportController;
import mc.alk.arena.events.matches.MatchPlayersReadyEvent;
import mc.alk.arena.events.players.ArenaPlayerDeathEvent;
import mc.alk.arena.events.players.ArenaPlayerKillEvent;
import mc.alk.arena.events.players.ArenaPlayerReadyEvent;
import mc.alk.arena.listeners.PlayerHolder;
import mc.alk.arena.objects.ArenaClass;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.options.StateOptions;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.CommandUtil;
import mc.alk.arena.util.Countdown;
import mc.alk.arena.util.DmgDeathUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.PermissionsUtil;
import mc.alk.arena.util.PlayerUtil;
import mc.alk.arena.util.TeamUtil;
import mc.alk.scoreboardapi.api.SEntry;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaMatch
extends Match {
    static boolean disabledAllCommands;
    static final HashSet<String> disabledCommands;
    static final HashSet<String> enabledCommands;
    final Map<UUID, Integer> deathTimer = new HashMap<UUID, Integer>();
    final Map<UUID, Integer> respawnTimer = new HashMap<UUID, Integer>();

    public ArenaMatch(Arena arena, MatchParams mp, Collection<ArenaListener> listeners) {
        super(arena, mp, listeners);
    }

    @ArenaEventHandler(suppressCastWarnings=true, bukkitPriority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        ArenaTeam killT;
        ArenaPlayer target = BattleArena.toArenaPlayer(event.getEntity());
        if (this.state == MatchState.ONCANCEL || this.state == MatchState.ONCOMPLETE) {
            return;
        }
        ArenaTeam t = this.getTeam(target);
        if (t == null) {
            return;
        }
        ArenaPlayerDeathEvent apde = new ArenaPlayerDeathEvent(target, t);
        apde.setPlayerDeathEvent(event);
        this.callEvent(apde);
        ArenaPlayer killer = DmgDeathUtil.getPlayerCause(event);
        if (killer != null && (killT = this.getTeam(killer)) != null) {
            killT.addKill(killer);
            this.callEvent(new ArenaPlayerKillEvent(killer, killT, target));
        }
    }

    @ArenaEventHandler(bukkitPriority=EventPriority.MONITOR)
    public void onPlayerDeath(ArenaPlayerDeathEvent event) {
        boolean trueDeath;
        ArenaPlayer target = event.getPlayer();
        if (this.state == MatchState.ONCANCEL || this.state == MatchState.ONCOMPLETE) {
            return;
        }
        ArenaTeam t = event.getTeam();
        Integer nDeaths = t.addDeath(target);
        boolean exiting = event.isExiting() || !this.respawns || nDeaths >= this.nLivesPerPlayer;
        event.setExiting(exiting);
        boolean bl = trueDeath = event.getPlayerDeathEvent() != null;
        if (this.nLivesPerPlayer != Integer.MAX_VALUE) {
            int curLives = this.nLivesPerPlayer - nDeaths;
            SEntry e = this.scoreboard.getEntry((OfflinePlayer)target.getPlayer());
            if (e != null) {
                this.scoreboard.setEntryNameSuffix(e, curLives <= 1 ? "" : "&4(" + curLives + ")");
            }
        }
        if (trueDeath) {
            block17: {
                PlayerDeathEvent pde = event.getPlayerDeathEvent();
                if (this.cancelExpLoss) {
                    pde.setKeepLevel(true);
                }
                if (this.clearsInventoryOnDeath || this.keepsInventory) {
                    try {
                        pde.getDrops().clear();
                    }
                    catch (Exception e) {
                        if (Defaults.DEBUG_VIRTUAL) break block17;
                        Log.printStackTrace(e);
                    }
                } else if (this.woolTeams) {
                    int index = t.getIndex();
                    ItemStack teamHead = TeamUtil.getTeamHead(index);
                    List items = pde.getDrops();
                    for (ItemStack is : items) {
                        if (is.getType() != teamHead.getType() || is.getDurability() != teamHead.getDurability()) continue;
                        int amt = is.getAmount();
                        if (amt > 1) {
                            is.setAmount(amt - 1);
                            break;
                        }
                        is.setType(Material.AIR);
                        break;
                    }
                }
            }
            if (this.keepsInventory) {
                boolean restores = this.getParams().hasOptionAt((CompetitionState)MatchState.ONLEAVE, TransitionOption.RESTOREITEMS);
                if (restores && exiting) {
                    this.psc.clearMatchItems(target);
                } else {
                    this.psc.storeMatchItems(target);
                }
            }
            ArenaMatch am = this;
            Integer timer = this.deathTimer.get(target.getID());
            if (timer != null) {
                Bukkit.getScheduler().cancelTask(timer.intValue());
            }
        }
        if (exiting) {
            this.performTransition(MatchState.ONCOMPLETE, target, t, true);
            this.checkAndHandleIfTeamDead(t);
        }
    }

    @ArenaEventHandler(priority=mc.alk.arena.objects.events.EventPriority.HIGH)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        final ArenaPlayer p = BattleArena.toArenaPlayer(event.getPlayer());
        if (this.isWon()) {
            return;
        }
        StateOptions mo = this.tops.getOptions(MatchState.ONDEATH);
        if (mo == null) {
            return;
        }
        if (this.respawns) {
            SpawnLocation loc;
            boolean randomRespawn = mo.randomRespawn();
            Integer timer = this.deathTimer.get(p.getID());
            if (timer != null) {
                Bukkit.getScheduler().cancelTask(timer.intValue());
            }
            final ArenaTeam t = this.getTeam(p);
            if (mo.hasAnyOption(TransitionOption.TELEPORTLOBBY, TransitionOption.TELEPORTMAINLOBBY, TransitionOption.TELEPORTWAITROOM, TransitionOption.TELEPORTMAINWAITROOM)) {
                final int index = t.getIndex();
                loc = mo.hasOption(TransitionOption.TELEPORTLOBBY) ? RoomController.getLobbySpawn(index, this.getParams().getType(), randomRespawn) : (mo.hasOption(TransitionOption.TELEPORTMAINLOBBY) ? RoomController.getLobbySpawn(Integer.MAX_VALUE, this.getParams().getType(), randomRespawn) : (mo.hasOption(TransitionOption.TELEPORTMAINWAITROOM) ? this.getWaitRoomSpawn(Integer.MAX_VALUE, randomRespawn) : this.getWaitRoomSpawn(index, randomRespawn)));
                Integer respawnTime = mo.getInt(TransitionOption.RESPAWNTIME);
                if (respawnTime == null) {
                    respawnTime = 15;
                }
                Integer finalRespawnTime = respawnTime;
                if (this.scoreboard != null) {
                    new Countdown((Plugin)BattleArena.getSelf(), finalRespawnTime, 1, new Countdown.CountdownCallback(){

                        public boolean intervalTick(int secondsRemaining) {
                            SEntry e;
                            if (!ArenaMatch.this.scoreboard.hasThisScoreboard(p.getPlayer())) {
                                ArenaMatch.this.scoreboard.setScoreboard(p.getPlayer());
                            }
                            if ((e = ArenaMatch.this.scoreboard.getEntry((OfflinePlayer)p.getPlayer())) != null) {
                                if (secondsRemaining > 0) {
                                    ArenaMatch.this.scoreboard.setEntryNameSuffix(e, "&e(" + secondsRemaining + ")");
                                } else {
                                    Integer curLives = ArenaMatch.this.nLivesPerPlayer - t.getNDeaths(p);
                                    String s = ArenaMatch.this.nLivesPerPlayer != Integer.MAX_VALUE && curLives != 1 ? "&4(" + curLives + ")" : "";
                                    ArenaMatch.this.scoreboard.setEntryNameSuffix(e, s);
                                }
                            }
                            return true;
                        }
                    });
                }
                int id = Scheduler.scheduleSynchronousTask(new Runnable(){

                    public void run() {
                        Integer id = ArenaMatch.this.respawnTimer.remove(p.getID());
                        Bukkit.getScheduler().cancelTask(id.intValue());
                        SpawnLocation loc = ArenaMatch.this.getTeamSpawn(index, ArenaMatch.this.tops.hasOptionAt(MatchState.ONSPAWN, TransitionOption.RANDOMRESPAWN));
                        TeleportController.teleport(p.getPlayer(), loc.getLocation());
                    }
                }, respawnTime * 20);
                this.respawnTimer.put(p.getID(), id);
            } else {
                loc = this.getTeamSpawn(this.getTeam(p), randomRespawn);
            }
            event.setRespawnLocation(loc.getLocation());
            final ArenaMatch am = this;
            Scheduler.scheduleSynchronousTask(new Runnable(){

                public void run() {
                    ArenaTeam t = ArenaMatch.this.getTeam(p);
                    am.performTransition(MatchState.ONDEATH, p, t, false);
                    am.performTransition(MatchState.ONSPAWN, p, t, false);
                    if (ArenaMatch.this.respawnsWithClass) {
                        ArenaClass ac = null;
                        if (p.getPreferredClass() != null) {
                            ac = p.getPreferredClass();
                        } else if (p.getCurrentClass() != null) {
                            ac = p.getCurrentClass();
                        }
                        if (ac != null) {
                            ArenaClassController.giveClass(p, ac);
                        }
                    }
                    if (ArenaMatch.this.keepsInventory) {
                        ArenaMatch.this.psc.restoreMatchItems(p);
                    }
                    if (ArenaMatch.this.woolTeams) {
                        TeamUtil.setTeamHead(t.getIndex(), p);
                    }
                }
            });
        } else {
            Location l;
            Location location = l = this.tops.hasOptionAt(MatchState.ONLEAVE, TransitionOption.TELEPORTTO) ? this.tops.getOptions(MatchState.ONLEAVE).getTeleportToLoc() : p.getOldLocation().getLocation();
            if (l != null) {
                event.setRespawnLocation(l);
            }
        }
    }

    @ArenaEventHandler(priority=mc.alk.arena.objects.events.EventPriority.HIGH, bukkitPriority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess1(PlayerCommandPreprocessEvent event) {
        this.handlePreprocess(event);
    }

    @ArenaEventHandler(priority=mc.alk.arena.objects.events.EventPriority.HIGH)
    public void onPlayerCommandPreprocess2(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.handlePreprocess(event);
    }

    private void handlePreprocess(PlayerCommandPreprocessEvent event) {
        if (CommandUtil.shouldCancel(event, disabledAllCommands, disabledCommands, enabledCommands)) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(ChatColor.RED + "You cannot use that command when you are in a match");
            if (PermissionsUtil.isAdmin((CommandSender)event.getPlayer())) {
                MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&cYou can set &6/bad allowAdminCommands true: &c to change");
            }
        }
    }

    @ArenaEventHandler(priority=mc.alk.arena.objects.events.EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.playerInteract(event);
    }

    private void playerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null || !event.getClickedBlock().getType().equals((Object)Material.SIGN) && !event.getClickedBlock().getType().equals((Object)Material.WALL_SIGN) && !event.getClickedBlock().getType().equals((Object)Defaults.READY_BLOCK)) {
            return;
        }
        if (!event.getClickedBlock().getType().equals((Object)Material.SIGN) && !event.getClickedBlock().getType().equals((Object)Material.WALL_SIGN)) {
            if (this.respawnTimer.containsKey(PlayerUtil.getID(event.getPlayer()))) {
                ArenaMatch.respawnClick(event, this, this.respawnTimer);
            } else {
                this.readyClick(event);
            }
        }
    }

    public static void respawnClick(PlayerInteractEvent event, PlayerHolder am, Map<UUID, Integer> respawnTimer) {
        ArenaPlayer ap = BattleArena.toArenaPlayer(event.getPlayer());
        Integer id = respawnTimer.remove(ap.getID());
        Bukkit.getScheduler().cancelTask(id.intValue());
        SpawnLocation loc = am.getSpawn(am.getTeam(ap).getIndex(), am.getParams().hasOptionAt((CompetitionState)MatchState.ONSPAWN, TransitionOption.RANDOMRESPAWN));
        TeleportController.teleport(ap, loc.getLocation());
    }

    public static void signClick(PlayerInteractEvent event, PlayerHolder am) {
        Sign sign = (Sign)event.getClickedBlock().getState();
        if (!sign.getLine(0).matches("^.[0-9a-fA-F]\\*.*$") && !sign.getLine(0).matches("^\\[.*$")) {
            return;
        }
        Action action = event.getAction();
        if (action != Action.LEFT_CLICK_BLOCK && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (action == Action.LEFT_CLICK_BLOCK) {
            event.setCancelled(true);
        }
        ArenaClass ac = ArenaClassController.getClass(MessageUtil.decolorChat(sign.getLine(0)).replace('*', ' ').replace('[', ' ').replace(']', ' ').trim());
        ArenaClassController.changeClass(event.getPlayer(), am, ac);
    }

    private void readyClick(PlayerInteractEvent event) {
        if (!Defaults.ENABLE_PLAYER_READY_BLOCK) {
            return;
        }
        ArenaPlayer ap = BattleArena.toArenaPlayer(event.getPlayer());
        if (!this.isInWaitRoomState()) {
            return;
        }
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_BLOCK) {
            event.setCancelled(true);
        }
        if (ap.isReady()) {
            return;
        }
        ap.setReady(true);
        MessageUtil.sendMessage(ap, "&2You ready yourself for the arena");
        this.callEvent(new ArenaPlayerReadyEvent(ap, true));
    }

    @ArenaEventHandler
    public void onPlayerReady(ArenaPlayerReadyEvent event) {
        if (!Defaults.ENABLE_PLAYER_READY_BLOCK) {
            return;
        }
        int tcount = 0;
        int pcount = 0;
        for (ArenaTeam t : this.teams) {
            if (!t.isReady() && t.size() > 0) {
                return;
            }
            ++tcount;
            pcount += t.size();
        }
        if (tcount < this.params.getMinTeams() || pcount < this.params.getMinPlayers()) {
            return;
        }
        this.callEvent(new MatchPlayersReadyEvent(this));
    }

    public static void setDisabledCommands(List<String> commands) {
        if (commands == null) {
            return;
        }
        disabledCommands.clear();
        if (commands.contains("all")) {
            disabledAllCommands = true;
        } else {
            for (String s : commands) {
                disabledCommands.add("/" + s.toLowerCase());
            }
        }
    }

    public static void setEnabledCommands(List<String> commands) {
        if (commands == null) {
            return;
        }
        enabledCommands.clear();
        for (String s : commands) {
            enabledCommands.add("/" + s.toLowerCase());
        }
    }

    static {
        disabledCommands = new HashSet();
        enabledCommands = new HashSet();
    }
}

