/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.competition.match;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.competition.Competition;
import mc.alk.arena.controllers.ArenaAlterController;
import mc.alk.arena.controllers.ArenaController;
import mc.alk.arena.controllers.ListenerAdder;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.controllers.PlayerStoreController;
import mc.alk.arena.controllers.RewardController;
import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.controllers.containers.GameManager;
import mc.alk.arena.controllers.joining.AbstractJoinHandler;
import mc.alk.arena.controllers.messaging.MatchMessager;
import mc.alk.arena.controllers.messaging.MessageHandler;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.controllers.plugins.TrackerController;
import mc.alk.arena.controllers.plugins.WorldGuardController;
import mc.alk.arena.events.EventManager;
import mc.alk.arena.events.matches.MatchCancelledEvent;
import mc.alk.arena.events.matches.MatchCompletedEvent;
import mc.alk.arena.events.matches.MatchFindCurrentLeaderEvent;
import mc.alk.arena.events.matches.MatchFinishedEvent;
import mc.alk.arena.events.matches.MatchOpenEvent;
import mc.alk.arena.events.matches.MatchPrestartEvent;
import mc.alk.arena.events.matches.MatchResultEvent;
import mc.alk.arena.events.matches.MatchStartEvent;
import mc.alk.arena.events.matches.MatchTimerIntervalEvent;
import mc.alk.arena.events.players.ArenaPlayerDeathEvent;
import mc.alk.arena.events.players.ArenaPlayerLeaveEvent;
import mc.alk.arena.events.players.ArenaPlayerTeleportEvent;
import mc.alk.arena.events.prizes.ArenaDrawersPrizeEvent;
import mc.alk.arena.events.prizes.ArenaLosersPrizeEvent;
import mc.alk.arena.events.prizes.ArenaPrizeEvent;
import mc.alk.arena.events.prizes.ArenaWinnersPrizeEvent;
import mc.alk.arena.events.teams.TeamDeathEvent;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionResult;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.ContainerState;
import mc.alk.arena.objects.LocationType;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchResult;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.StateGraph;
import mc.alk.arena.objects.StateOption;
import mc.alk.arena.objects.WinLossDraw;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.arenas.ArenaControllerInterface;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.messaging.Channels;
import mc.alk.arena.objects.messaging.MatchMessageHandler;
import mc.alk.arena.objects.modules.ArenaModule;
import mc.alk.arena.objects.options.StateOptions;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.objects.scoreboard.ArenaObjective;
import mc.alk.arena.objects.scoreboard.ArenaScoreboard;
import mc.alk.arena.objects.scoreboard.ScoreboardFactory;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.victoryconditions.NLives;
import mc.alk.arena.objects.victoryconditions.NoTeamsLeft;
import mc.alk.arena.objects.victoryconditions.OneTeamLeft;
import mc.alk.arena.objects.victoryconditions.TeamTimeLimit;
import mc.alk.arena.objects.victoryconditions.TimeLimit;
import mc.alk.arena.objects.victoryconditions.VictoryCondition;
import mc.alk.arena.objects.victoryconditions.VictoryType;
import mc.alk.arena.objects.victoryconditions.interfaces.DefinesNumLivesPerPlayer;
import mc.alk.arena.objects.victoryconditions.interfaces.DefinesNumTeams;
import mc.alk.arena.objects.victoryconditions.interfaces.DefinesTimeLimit;
import mc.alk.arena.objects.victoryconditions.interfaces.ScoreTracker;
import mc.alk.arena.util.Countdown;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.TeamUtil;
import mc.alk.scoreboardapi.api.SEntry;
import mc.alk.scoreboardapi.api.SObjective;
import mc.alk.scoreboardapi.scoreboard.SAPIDisplaySlot;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Match
extends Competition
implements Runnable,
ArenaController {
    final MatchParams params;
    final Arena arena;
    final ArenaControllerInterface arenaInterface;
    MatchState state = MatchState.NONE;
    final Map<MatchState, Long> times = Collections.synchronizedMap(new EnumMap(MatchState.class));
    final List<VictoryCondition> vcs = new ArrayList<VictoryCondition>();
    MatchResult matchResult;
    final StateGraph tops;
    final PlayerStoreController psc = new PlayerStoreController();
    Set<MatchState> waitRoomStates = null;
    final CompetitionState tinState;
    Long joinCutoffTime = null;
    Integer currentTimer = null;
    Countdown startCountdown = null;
    Countdown matchCountdown = null;
    private final Collection<ArenaPlayer> inGamePlayers = new HashSet<ArenaPlayer>();
    final Set<UUID> inMatch = new HashSet<UUID>();
    List<UUID> inMatchList;
    final Set<ArenaTeam> nonEndingTeams = new HashSet<ArenaTeam>();
    final Map<ArenaTeam, Integer> individualTeamTimers = new HashMap<ArenaTeam, Integer>();
    final Map<ArenaTeam, TeamTimeLimit> individualTeamTimeLimits = new HashMap<ArenaTeam, TeamTimeLimit>();
    final Set<ArenaTeam> deadTeams = new HashSet<ArenaTeam>();
    final AtomicBoolean addedVictoryConditions = new AtomicBoolean(false);
    final GameManager gameManager;
    double prizePoolMoney = 0.0;
    final boolean needsClearInventory;
    final boolean clearsInventory;
    final boolean clearsInventoryOnDeath;
    final boolean keepsInventory;
    boolean respawns;
    final boolean spawnsRandom;
    final boolean woolTeams;
    final boolean armorTeams;
    final boolean alwaysTeamNames;
    final boolean respawnsWithClass;
    final boolean cancelExpLoss;
    final boolean individualWins;
    final boolean alwaysOpen;
    int neededTeams;
    int nLivesPerPlayer = 1;
    final ArenaScoreboard scoreboard;
    final MatchMessager mc;
    AbstractJoinHandler joinHandler;
    final ArenaObjective defaultObjective;
    ArenaPreviousState oldArenaState;

    public Match(Arena arena, MatchParams matchParams, Collection<ArenaListener> listeners) {
        this.transitionTo(MatchState.ONCREATE);
        this.params = ParamController.copyParams(matchParams);
        this.params.setName(this.getName());
        this.params.flatten();
        this.tops = this.params.getStateGraph();
        this.gameManager = GameManager.getGameManager(this.params);
        this.arena = arena;
        this.arenaInterface = new ArenaControllerInterface(arena);
        this.addArenaListener(arena);
        if (listeners != null) {
            this.addArenaListeners(listeners);
        }
        this.scoreboard = ScoreboardFactory.createScoreboard(this, this.params);
        this.mc = new MatchMessager(this);
        arena.setMatch(this);
        Set<ArenaModule> modules = this.params.getModules();
        if (modules != null) {
            for (ArenaModule am : modules) {
                if (!am.isEnabled()) continue;
                this.addArenaListener(am);
            }
        }
        boolean noEnter = this.tops.hasAnyOption((StateOption)TransitionOption.WGNOENTER);
        if (arena.hasRegion()) {
            WorldGuardController.setFlag(arena.getWorldGuardRegion(), "entry", !noEnter);
        }
        this.woolTeams = this.tops.hasAnyOption((StateOption)TransitionOption.WOOLTEAMS) && this.params.getMaxTeamSize() > 1 || this.tops.hasAnyOption((StateOption)TransitionOption.ALWAYSWOOLTEAMS);
        this.armorTeams = this.tops.hasAnyOption((StateOption)TransitionOption.ARMORTEAMS);
        this.tinState = this.tops.getCompetitionState(TransitionOption.TELEPORTIN);
        this.spawnsRandom = this.tinState != null && this.tops.hasOptionAt(this.tinState, TransitionOption.RANDOMSPAWN);
        this.alwaysTeamNames = this.tops.hasAnyOption((StateOption)TransitionOption.ALWAYSTEAMNAMES);
        this.cancelExpLoss = this.tops.hasAnyOption((StateOption)TransitionOption.NOEXPERIENCELOSS);
        this.matchResult = new MatchResult();
        this.needsClearInventory = this.tops.hasOptionAt(MatchState.PREREQS, TransitionOption.CLEARINVENTORY);
        this.clearsInventory = this.tops.hasOptionAt(MatchState.ONCOMPLETE, TransitionOption.CLEARINVENTORY);
        this.keepsInventory = this.tops.hasOptionAt(MatchState.ONDEATH, TransitionOption.KEEPINVENTORY);
        this.clearsInventoryOnDeath = this.tops.hasOptionAt(MatchState.ONDEATH, TransitionOption.CLEARINVENTORY);
        this.respawns = this.tops.hasOptionAt(MatchState.ONDEATH, TransitionOption.RESPAWN) || this.tops.hasOptionAt(MatchState.ONDEATH, TransitionOption.RANDOMSPAWN);
        this.respawnsWithClass = this.tops.hasOptionAt(MatchState.ONSPAWN, TransitionOption.RESPAWNWITHCLASS);
        this.alwaysOpen = this.params.isAlwaysOpen();
        this.neededTeams = this.alwaysOpen ? 0 : this.params.getMinTeams();
        boolean bl = this.individualWins = this.tops.hasOptionAt(MatchState.DEFAULTS, TransitionOption.INDIVIDUALWINS) || this.alwaysOpen;
        if (this.tops.hasAnyOption(TransitionOption.TELEPORTWAITROOM, TransitionOption.TELEPORTLOBBY, TransitionOption.TELEPORTMAINWAITROOM, TransitionOption.TELEPORTMAINLOBBY, TransitionOption.TELEPORTCOURTYARD)) {
            this.waitRoomStates = new HashSet<MatchState>(this.tops.getMatchStateRange(TransitionOption.TELEPORTWAITROOM, TransitionOption.TELEPORTIN));
            this.waitRoomStates.addAll(this.tops.getMatchStateRange(TransitionOption.TELEPORTWAITROOM, TransitionOption.TELEPORTIN));
            this.waitRoomStates.addAll(this.tops.getMatchStateRange(TransitionOption.TELEPORTMAINWAITROOM, TransitionOption.TELEPORTIN));
            this.waitRoomStates.addAll(this.tops.getMatchStateRange(TransitionOption.TELEPORTLOBBY, TransitionOption.TELEPORTIN));
            this.waitRoomStates.addAll(this.tops.getMatchStateRange(TransitionOption.TELEPORTMAINLOBBY, TransitionOption.TELEPORTIN));
            this.waitRoomStates.addAll(this.tops.getMatchStateRange(TransitionOption.TELEPORTCOURTYARD, TransitionOption.TELEPORTIN));
            if (this.waitRoomStates.isEmpty()) {
                this.waitRoomStates = null;
            }
        }
        ListenerAdder.addListeners(this, this.tops);
        this.methodController.addAllEvents(this);
        EventManager.registerEvents(this, (Plugin)BattleArena.getSelf());
        this.defaultObjective = this.scoreboard.createObjective("default", "Player Kills", "&6Still Alive", SAPIDisplaySlot.SIDEBAR, 100);
        if (this.params.getMaxTeamSize() <= 2) {
            this.defaultObjective.setDisplayTeams(false);
        }
        if (this.hasWaitroom() && this.params.isWaitroomClosedWhenRunning().booleanValue()) {
            this.oldArenaState = new ArenaPreviousState(arena);
            arena.setContainerState(ArenaAlterController.ChangeType.WAITROOM, new ContainerState(ContainerState.AreaContainerState.CLOSED, "&cA match is already in progress in arena " + arena.getName()));
        }
        this.updateBukkitEvents(MatchState.ONCREATE);
    }

    private void updateBukkitEvents(MatchState matchState) {
        this.methodController.updateEvents((ArenaListener)null, matchState, this.getInMatchList());
    }

    private void updateBukkitEvents(MatchState matchState, ArenaPlayer player) {
        this.methodController.updateEvents(matchState, player);
    }

    private void updateBukkitEvents(MatchState matchState, ArenaListener listener) {
        this.methodController.updateEvents(listener, matchState, this.getInMatchList());
    }

    public void open() {
        MatchOpenEvent event = new MatchOpenEvent(this);
        this.callEvent(event);
        if (event.isCancelled()) {
            this.cancelMatch();
            return;
        }
        this.arenaInterface.onOpen();
        this.transitionTo(MatchState.ONOPEN);
        this.updateBukkitEvents(MatchState.ONOPEN);
        this.transitionTo(MatchState.INOPEN);
        this.onJoin(this.teams);
    }

    @Override
    public void run() {
        this.preStartMatch();
    }

    public boolean isTimedStart() {
        return this.startCountdown != null;
    }

    public void setTimedStart(int seconds, Integer interval) {
        if (this.startCountdown != null) {
            this.startCountdown.stop();
            this.startCountdown = null;
        }
        if (this.joinHandler != null) {
            this.joinHandler.useWaitingScoreboard();
            this.joinHandler.setWaitingScoreboardTime(seconds);
        }
        if (seconds > 0) {
            this.mc.sendCountdownTillPrestart(seconds);
            this.startCountdown = new Countdown((Plugin)BattleArena.getSelf(), seconds, interval, new Countdown.CountdownCallback(){

                public boolean intervalTick(int remaining) {
                    if (Match.this.state != MatchState.ONOPEN) {
                        return false;
                    }
                    if (remaining == 0) {
                        if (Match.this.checkEnoughTeams(Match.this.getTeams(), Match.this.neededTeams)) {
                            Match.this.preStartMatch();
                        }
                    } else {
                        Match.this.mc.sendCountdownTillPrestart(remaining);
                    }
                    return true;
                }
            });
        } else {
            this.preStartMatch();
        }
    }

    public void hookTeamJoinHandler(AbstractJoinHandler teamJoinHandler) {
        teamJoinHandler.setCompetition(this);
        this.joinHandler = teamJoinHandler;
        this.teams = this.joinHandler.getTeams();
        teamJoinHandler.transferOldScoreboards(this.scoreboard.getBScoreboard());
        for (int i = 0; i < this.teams.size(); ++i) {
            ((ArenaTeam)this.teams.get(i)).setIndex(i);
            for (ArenaPlayer ap : ((ArenaTeam)this.teams.get(i)).getPlayers()) {
                this.joiningOngoing((ArenaTeam)this.teams.get(i), ap);
            }
        }
        this.inGamePlayers.addAll(this.joinHandler.getPlayers());
    }

    public List<ArenaTeam> getNonEmptyTeams() {
        ArrayList<ArenaTeam> teams = new ArrayList<ArenaTeam>();
        for (ArenaTeam at : this.teams) {
            if (at == null || at.size() <= 0) continue;
            teams.add(at);
        }
        return teams;
    }

    private void preStartTeams(List<ArenaTeam> teams, boolean matchPrestarting) {
        StateOptions ts = this.params.getStateOptions(MatchState.ONPRESTART);
        if (ts != null && ts.teleportsIn()) {
            for (ArenaTeam t : teams) {
                this.checkReady(t, this.params.getStateOptions(MatchState.PREREQS));
            }
        }
        this.performTransition(MatchState.ONPRESTART, teams, true);
        if (matchPrestarting) {
            this.mc.sendOnPreStartMsg(this.getNonEmptyTeams());
        } else {
            this.mc.sendOnPreStartMsg(this.getNonEmptyTeams(), Channels.NullChannel);
        }
    }

    private void preStartMatch() {
        if (this.state == MatchState.ONCANCEL || this.state.ordinal() >= MatchState.INPRESTART.ordinal()) {
            return;
        }
        this.transitionTo(MatchState.ONPRESTART);
        this.updateBukkitEvents(MatchState.ONPRESTART);
        this.transitionTo(MatchState.INPRESTART);
        this.callEvent(new MatchPrestartEvent(this, this.teams));
        this.preStartTeams(this.teams, true);
        this.arenaInterface.onPrestart();
        new Countdown((Plugin)BattleArena.getSelf(), this.params.getSecondsTillMatch(), 1, new Countdown.CountdownCallback(){

            public boolean intervalTick(int remaining) {
                SObjective obj = Match.this.scoreboard.getObjective(SAPIDisplaySlot.SIDEBAR);
                if (obj != null) {
                    if (remaining == 0 && Match.this.params.getMatchTime() == Integer.MAX_VALUE) {
                        obj.setDisplayNameSuffix("");
                    } else {
                        obj.setDisplayNameSuffix(" &e(" + remaining + ")");
                    }
                }
                return Match.this.currentTimer != null;
            }
        });
        this.currentTimer = Scheduler.scheduleSynchronousTask(new Runnable(){

            public void run() {
                Match.this.startMatch();
            }
        }, (int)((long)this.params.getSecondsTillMatch().intValue() * 20L));
        if (this.waitRoomStates != null) {
            this.joinCutoffTime = System.currentTimeMillis() + (long)((this.params.getSecondsTillMatch() - Defaults.JOIN_CUTOFF_TIME) * 1000);
        }
    }

    public void start() {
        if (this.state != MatchState.INPRESTART) {
            return;
        }
        if (this.currentTimer != null) {
            Bukkit.getScheduler().cancelTask(this.currentTimer.intValue());
        }
        this.currentTimer = Scheduler.scheduleSynchronousTask(new Runnable(){

            public void run() {
                Match.this.startMatch();
            }
        }, 200L);
    }

    private void startMatch() {
        if (this.state == MatchState.ONCANCEL) {
            return;
        }
        this.transitionTo(MatchState.ONSTART);
        if (!this.addedVictoryConditions.get()) {
            this.addVictoryConditions();
        }
        ArrayList<ArenaTeam> competingTeams = new ArrayList<ArenaTeam>();
        StateOptions ts = this.params.getStateOptions(this.state);
        if (ts != null && ts.teleportsIn()) {
            for (ArenaTeam t : this.teams) {
                this.checkReady(t, this.params.getStateOptions(MatchState.PREREQS));
            }
        }
        for (ArenaTeam t : this.teams) {
            if (t.isDead()) continue;
            competingTeams.add(t);
        }
        int nCompetingTeams = competingTeams.size();
        if (nCompetingTeams >= this.neededTeams) {
            MatchStartEvent event = new MatchStartEvent(this, this.teams);
            this.updateBukkitEvents(MatchState.ONSTART);
            this.callEvent(event);
            this.performTransition(MatchState.ONSTART, competingTeams, true);
            this.arenaInterface.onStart();
            List<ArenaTeam> net = this.getNonEmptyTeams();
            try {
                this.mc.sendOnStartMsg(net);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
            if (Defaults.USE_SCOREBOARD) {
                for (ArenaPlayer ap : this.inGamePlayers) {
                    this.scoreboard.setScoreboard(ap.getPlayer());
                }
            }
        }
        this.checkEnoughTeams(competingTeams, this.neededTeams);
        this.transitionTo(MatchState.INGAME);
    }

    @Override
    public boolean hasOption(StateOption option) {
        return this.params.getStateGraph().hasInArenaOrOptionAt(this.state, option);
    }

    private boolean checkEnoughTeams(List<ArenaTeam> competingTeams, int neededTeams) {
        int nCompetingTeams = competingTeams.size();
        if (nCompetingTeams >= neededTeams) {
            return true;
        }
        if (nCompetingTeams < neededTeams && nCompetingTeams == 1) {
            ArenaTeam victor = competingTeams.get(0);
            victor.sendMessage("&4WIN!!!&eThe other team was offline or didnt meet the entry requirements.");
            this.setVictor(victor);
            return false;
        }
        if (competingTeams.isEmpty()) {
            this.cancelMatch();
        } else {
            this.setDraw();
        }
        return false;
    }

    private synchronized void matchWinLossOrDraw(MatchResult result) {
        if (this.alwaysOpen) {
            this.nonEndingMatchWinLossOrDraw(result);
        } else {
            this.endingMatchWinLossOrDraw(result);
        }
    }

    private synchronized void nonEndingMatchWinLossOrDraw(MatchResult result) {
        ArrayList<ArenaTeam> remove = new ArrayList<ArenaTeam>();
        for (ArenaTeam t : result.getLosers()) {
            if (this.nonEndingTeams.add(t) && t.size() != 0) continue;
            remove.add(t);
        }
        result.removeLosers(remove);
        remove.clear();
        for (ArenaTeam t : result.getDrawers()) {
            if (this.nonEndingTeams.add(t) && t.size() != 0) continue;
            remove.add(t);
        }
        result.removeDrawers(remove);
        remove.clear();
        for (ArenaTeam t : result.getVictors()) {
            if (this.nonEndingTeams.add(t) && t.size() != 0) continue;
            remove.add(t);
        }
        result.removeVictors(remove);
        if (result.getLosers().isEmpty() && result.getDrawers().isEmpty() && result.getVictors().isEmpty()) {
            return;
        }
        MatchResultEvent event = new MatchResultEvent(this, result);
        this.callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        int timerid = Scheduler.scheduleSynchronousTask(new NonEndingMatchVictory(this, result), 2L);
        for (ArenaTeam t : this.teams) {
            this.individualTeamTimers.put(t, timerid);
        }
    }

    private synchronized void endingMatchWinLossOrDraw(MatchResult result) {
        if (this.state == MatchState.ONVICTORY || this.state == MatchState.ONCOMPLETE || this.state == MatchState.ONCANCEL) {
            return;
        }
        this.matchResult = result;
        MatchResultEvent event = new MatchResultEvent(this, result);
        this.callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        this.transitionTo(MatchState.ONVICTORY);
        this.transitionTo(MatchState.INVICTORY);
        this.arenaInterface.onVictory(result);
        this.currentTimer = Scheduler.scheduleSynchronousTask(new MatchVictory(this), 2L);
    }

    private void givePrizes(Match am, CompetitionResult result) {
        ArenaPrizeEvent event;
        if (result.getLosers() != null && !result.getLosers().isEmpty()) {
            am.performTransition(MatchState.LOSERS, result.getLosers(), false);
            event = new ArenaLosersPrizeEvent(am, result.getLosers());
            this.callEvent(event);
            new RewardController(event, this.psc).giveRewards();
        }
        if (result.getDrawers() != null && !result.getDrawers().isEmpty()) {
            am.performTransition(MatchState.DRAWERS, result.getDrawers(), false);
            event = new ArenaDrawersPrizeEvent(am, result.getDrawers());
            this.callEvent(event);
            new RewardController(event, this.psc).giveRewards();
        }
        if (result.getVictors() != null && !result.getVictors().isEmpty()) {
            am.performTransition(MatchState.WINNERS, result.getVictors(), false);
            event = new ArenaWinnersPrizeEvent(am, result.getVictors());
            this.callEvent(event);
            new RewardController(event, this.psc).giveRewards();
        }
    }

    public synchronized void cancelMatch() {
        if (this.state == MatchState.ONCANCEL) {
            return;
        }
        this.state = MatchState.ONCANCEL;
        this.arenaInterface.onCancel();
        for (ArenaTeam arenaTeam : this.teams) {
            if (arenaTeam == null) continue;
            this.performTransition(MatchState.ONCANCEL, arenaTeam, true);
        }
        for (Map.Entry entry : this.individualTeamTimers.entrySet()) {
            Scheduler.cancelTask((Integer)entry.getValue());
            if (this.teams.contains(entry.getKey())) continue;
            this.performTransition(MatchState.ONCANCEL, (ArenaTeam)entry.getKey(), true);
        }
        this.callEvent(new MatchCancelledEvent(this));
        this.updateBukkitEvents(MatchState.ONCANCEL);
        this.deconstruct();
    }

    private void nonEndingDeconstruct(List<ArenaTeam> teams) {
        for (ArenaTeam t : teams) {
            this.performTransition(MatchState.ONFINISH, t, true);
            for (ArenaPlayer p : t.getPlayers()) {
                p.removeCompetition(this);
                if (this.joinHandler == null) continue;
                this.joinHandler.leave(p);
            }
            this.individualTeamTimers.remove(t);
            this.scoreboard.removeTeam(t);
            TeamTimeLimit ttl = this.individualTeamTimeLimits.remove(t);
            if (ttl != null) {
                ttl.stopCountdown();
            }
            t.reset();
        }
        this.nonEndingTeams.removeAll(teams);
    }

    private void deconstruct() {
        Match match = this;
        this.callEvent(new MatchFinishedEvent(match));
        this.updateBukkitEvents(MatchState.ONFINISH);
        for (ArenaTeam arenaTeam : this.teams) {
            this.performTransition(MatchState.ONFINISH, arenaTeam, true);
            for (ArenaPlayer p : arenaTeam.getPlayers()) {
                p.removeCompetition(this);
            }
            this.scoreboard.removeTeam(arenaTeam);
        }
        for (Map.Entry entry : this.individualTeamTimers.entrySet()) {
            Scheduler.cancelTask((Integer)entry.getValue());
            if (this.teams.contains(entry.getKey())) continue;
            this.performTransition(MatchState.ONCANCEL, (ArenaTeam)entry.getKey(), true);
            for (ArenaPlayer p : ((ArenaTeam)entry.getKey()).getPlayers()) {
                p.removeCompetition(this);
            }
        }
        if (this.oldArenaState != null) {
            this.oldArenaState.revert(this.arena);
        }
        this.scoreboard.clear();
        this.arenaInterface.onFinish();
        this.inMatch.clear();
        this.inMatchList = null;
        this.teams.clear();
        this.methodController.deconstruct();
        HandlerList.unregisterAll((Listener)this);
    }

    private boolean _addedTeam(ArenaTeam team) {
        if (this.isFinished()) {
            return false;
        }
        if (Defaults.DEBUG_MATCH_TEAMS) {
            Log.info(this.getID() + " addedTeam(" + team.getName() + ":" + team.getId() + ")");
        }
        team.setArenaObjective(this.defaultObjective);
        this.scoreboard.addTeam(team);
        for (ArenaPlayer p : team.getPlayers()) {
            if (p == null) continue;
            this._addedToTeam(team, p);
            if (this.isHandled(p)) continue;
            this.joiningOngoing(team, p);
        }
        return true;
    }

    @Override
    public void addArenaListener(ArenaListener arenaListener) {
        this.methodController.addListener(arenaListener);
        if (this.state.ordinal() >= MatchState.ONCREATE.ordinal()) {
            this.methodController.updateEventsRange(arenaListener, MatchState.ONCREATE, this.state, this.getInMatchList());
        }
        if (!this.inMatch.isEmpty()) {
            this.updateBukkitEvents(MatchState.ONENTER, arenaListener);
        }
    }

    @Override
    public boolean removeArenaListener(ArenaListener arenaListener) {
        return this.methodController.removeListener(arenaListener);
    }

    @Override
    public boolean addedTeam(ArenaTeam team) {
        return this._addedTeam(team);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UUID> getInMatchList() {
        Match match = this;
        synchronized (match) {
            if (this.inMatchList == null) {
                this.inMatchList = new ArrayList<UUID>(this.inMatch);
            }
            return this.inMatchList;
        }
    }

    public boolean isInMatch(ArenaPlayer player) {
        return this.inMatch.contains(player.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addInMatch(ArenaPlayer player) {
        boolean added = false;
        Match match = this;
        synchronized (match) {
            if (this.inMatch.add(player.getID())) {
                this.inMatchList = null;
                added = true;
            }
        }
        if (added) {
            this.updateBukkitEvents(MatchState.ONENTER, player);
            this.arenaInterface.onEnter(player, player.getTeam());
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeInMatch(ArenaPlayer player) {
        boolean removed = false;
        Match match = this;
        synchronized (match) {
            if (this.inMatch.remove(player.getID())) {
                this.inMatchList = null;
                removed = true;
            }
        }
        if (removed) {
            player.despawnMobs();
            this.updateBukkitEvents(MatchState.ONLEAVE, player);
            this.arenaInterface.onLeave(player, player.getTeam());
        }
        return removed;
    }

    private void _addedToTeam(ArenaTeam team, ArenaPlayer player) {
        this.deadTeams.remove(team);
        team.setAlive(player);
        this.scoreboard.addedToTeam(team, player);
        this.defaultObjective.setPoints(player, 0);
    }

    @Override
    public boolean removedTeam(ArenaTeam team) {
        if (Defaults.DEBUG_MATCH_TEAMS) {
            Log.info(this.getID() + " removedTeam(" + team.getName() + ":" + team.getId() + ")");
        }
        this.scoreboard.removeTeam(team);
        this.teams.remove(team);
        HeroesController.removeTeam(team);
        return true;
    }

    @Override
    public void addedToTeam(ArenaTeam team, ArenaPlayer player) {
        if (this.isEnding()) {
            return;
        }
        if (Defaults.DEBUG_MATCH_TEAMS) {
            Log.info(this.getID() + " addedToTeam(" + team.getName() + ":" + team.getId() + ", " + player.getName() + ") inside=" + this.isInMatch(player));
        }
        if (!team.hasSetName() && team.getDisplayName().length() > 32) {
            team.setDisplayName(TeamUtil.getTeamName(team.getIndex()));
        }
        this._addedToTeam(team, player);
        this.mc.sendAddedToTeam(team, player);
        if (!this.isHandled(player)) {
            this.joiningOngoing(team, player);
        }
    }

    private static void doTransition(Match match, MatchState state, ArenaPlayer player, ArenaTeam team, boolean onlyInMatch) {
        if (player != null) {
            match.performTransition(state, player, team, onlyInMatch);
        } else {
            match.performTransition(state, team, onlyInMatch);
        }
    }

    private void joiningOngoing(final ArenaTeam team, final ArenaPlayer player) {
        final Match match = this;
        if (!this.gameManager.hasPlayer(player)) {
            Match.doTransition(match, MatchState.ONJOIN, player, team, true);
        }
        if (this.state.ordinal() >= MatchState.ONPRESTART.ordinal()) {
            Match.doTransition(match, MatchState.ONPRESTART, player, team, true);
            if (this.state.ordinal() >= MatchState.ONSTART.ordinal()) {
                int timerid = Scheduler.scheduleSynchronousTask(new Runnable(){

                    public void run() {
                        Match.doTransition(match, MatchState.ONSTART, player, team, true);
                    }
                }, (int)((long)this.params.getSecondsTillMatch().intValue() * 20L));
                if (!this.individualTeamTimeLimits.containsKey(team)) {
                    TeamTimeLimit ttl = new TeamTimeLimit(this, team);
                    this.individualTeamTimeLimits.put(team, ttl);
                    ttl.startCountdown();
                }
                this.individualTeamTimers.put(team, timerid);
            }
        }
    }

    @Override
    public void addedToTeam(ArenaTeam team, Collection<ArenaPlayer> players) {
        for (ArenaPlayer ap : players) {
            this.addedToTeam(team, ap);
        }
    }

    @Override
    public void removedFromTeam(ArenaTeam team, Collection<ArenaPlayer> players) {
        for (ArenaPlayer ap : players) {
            this.privateRemovedFromTeam(team, ap);
        }
    }

    @Override
    public void removedFromTeam(ArenaTeam team, ArenaPlayer player) {
        this.privateRemovedFromTeam(team, player);
    }

    protected void onJoin(Collection<ArenaTeam> teams) {
        if (teams == null) {
            return;
        }
        for (ArenaTeam t : teams) {
            this._addedTeam(t);
        }
    }

    @Override
    public boolean canLeave(ArenaPlayer p) {
        return !this.tops.hasOptionAt(this.state, TransitionOption.NOLEAVE);
    }

    @Override
    public boolean leave(ArenaPlayer p) {
        return this.joinHandler != null && this.joinHandler.leave(p);
    }

    protected void checkAndHandleIfTeamDead(ArenaTeam team) {
        if (team.isDead() && this.deadTeams.add(team)) {
            TeamTimeLimit ttl;
            if (this.getState().ordinal() < MatchState.ONVICTORY.ordinal()) {
                this.callEvent(new TeamDeathEvent(team));
            }
            if (this.alwaysOpen && (ttl = this.individualTeamTimeLimits.remove(team)) != null) {
                ttl.stopCountdown();
            }
        }
    }

    private void privateRemovedFromTeam(ArenaTeam team, ArenaPlayer ap) {
        if (Defaults.DEBUG_MATCH_TEAMS) {
            Log.info(this.getID() + " removedFromTeam(" + team.getName() + ":" + team.getId() + ")" + ap.getName());
        }
        HeroesController.removedFromTeam(team, ap.getPlayer());
        this.scoreboard.removedFromTeam(team, ap);
    }

    private void preFirstJoin(ArenaPlayer player) {
        ArenaTeam team = this.getTeam(player);
        this.leftPlayers.remove(player.getID());
        this.inGamePlayers.add(player);
        player.addCompetition(this);
        if (this.params.hasEntranceFee()) {
            this.prizePoolMoney += this.params.getEntranceFee().doubleValue();
        }
        if (WorldGuardController.hasWorldGuard() && this.arena.hasRegion()) {
            this.psc.addMember(player, this.arena.getWorldGuardRegion());
        }
        this.performTransition(MatchState.ONENTERARENA, player, team, false);
    }

    private void postFirstJoin(ArenaPlayer player) {
        ArenaTeam team = this.getTeam(player);
        this.arenaInterface.onJoin(player, team);
        if (this.state == MatchState.ONOPEN && this.joinHandler != null && this.joinHandler.isFull()) {
            Scheduler.scheduleSynchronousTask((Plugin)BattleArena.getSelf(), this);
        }
        if (this.nLivesPerPlayer != 1 && this.nLivesPerPlayer != Integer.MAX_VALUE) {
            player.getMetaData().setLivesLeft(this.nLivesPerPlayer);
            SEntry e = this.scoreboard.getEntry((OfflinePlayer)player.getPlayer());
            if (e != null) {
                this.scoreboard.setEntryNameSuffix(e, "(" + this.nLivesPerPlayer + ")");
            }
        }
        if (!this.params.getUseTrackerPvP().booleanValue()) {
            TrackerController.stopTracking(player);
            TrackerController.stopTrackingMessages(player);
        }
        if (this.woolTeams && team != null && team.getIndex() != -1) {
            TeamUtil.setTeamHead(team.getIndex(), player);
        }
        if (this.cancelExpLoss) {
            this.psc.cancelExpLoss(player, true);
        }
        this.addInMatch(player);
    }

    @EventHandler
    public void onArenaPlayerLeaveEventGlobal(ArenaPlayerLeaveEvent event) {
        if (this.leftPlayers.contains(event.getPlayer().getID()) || this.inGamePlayers.contains(event.getPlayer()) && event.getPlayer().getCurLocation().getType() == LocationType.ARENA || !this.isHandled(event.getPlayer())) {
            return;
        }
        this.privateQuitting(event);
    }

    @ArenaEventHandler
    public void onArenaPlayerLeaveEvent(ArenaPlayerLeaveEvent event) {
        ArenaPlayer player = event.getPlayer();
        if (!this.isHandled(player)) {
            return;
        }
        this.privateQuitting(event);
    }

    protected void privateQuitting(ArenaPlayerLeaveEvent event) {
        ArenaPlayer ap = event.getPlayer();
        if (this.params.hasOptionAt((CompetitionState)MatchState.DEFAULTS, TransitionOption.DROPITEMS)) {
            InventoryUtil.dropItems(ap.getPlayer());
            InventoryUtil.clearInventory(ap.getPlayer());
        }
        this.performTransition(MatchState.ONCANCEL, ap, ap.getTeam(), false);
        event.addMessage(MessageHandler.getSystemMessage("you_left_competition", this.params.getName()));
    }

    @Override
    public void onPreJoin(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        this.preFirstJoin(player);
    }

    @Override
    public void onPostJoin(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        this.postFirstJoin(player);
    }

    @Override
    public void onPreQuit(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    @Override
    public void onPostQuit(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        boolean cancelsIfGone;
        ArenaTeam t = player.getTeam();
        this.performTransition(MatchState.ONLEAVEARENA, player, t, false);
        if (WorldGuardController.hasWorldGuard() && this.arena.hasRegion()) {
            this.psc.removeMember(player, this.arena.getWorldGuardRegion());
        }
        player.removeCompetition(this);
        player.reset();
        if (!this.params.getUseTrackerPvP().booleanValue()) {
            TrackerController.resumeTracking(player);
            TrackerController.resumeTrackingMessages(player);
        }
        if (t != null) {
            if (this.woolTeams) {
                TeamUtil.removeTeamHead(t.getIndex(), player.getPlayer());
            }
            t.killMember(player);
            this.checkAndHandleIfTeamDead(t);
            this.scoreboard.setDead(t, player);
        }
        boolean bl = cancelsIfGone = this.state.ordinal() <= MatchState.ONOPEN.ordinal();
        if (this.alwaysOpen || cancelsIfGone) {
            this.joinHandler.leave(player);
            this.inGamePlayers.remove(player);
        }
        if (this.cancelExpLoss) {
            this.psc.cancelExpLoss(player, false);
        }
        this.removeInMatch(player);
        player.setTeam(null);
        if (cancelsIfGone && this.joinHandler.isEmpty()) {
            this.cancelMatch();
        }
        if (this.state == MatchState.ONCANCEL || this.state.ordinal() <= MatchState.ONOPEN.ordinal()) {
            if (this.params.hasEntranceFee()) {
                this.prizePoolMoney -= this.params.getEntranceFee().doubleValue();
            }
            if (player.getMetaData().getJoinRequirements() != null) {
                PlayerStoreController psc = new PlayerStoreController(player.getMetaData().getJoinRequirements());
                psc.restoreAll(player);
            }
        }
        if (player.getMetaData().getJoinRequirements() != null) {
            player.getMetaData().setJoinRequirements(null);
        }
    }

    @Override
    public void onPreEnter(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        if (!this.inGamePlayers.contains(player)) {
            this.preFirstJoin(player);
            player.getMetaData().setJoining(true);
        }
        this.addInMatch(player);
    }

    @Override
    public void onPostEnter(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        if (player.getMetaData().isJoining()) {
            player.getMetaData().setJoining(false);
            this.postFirstJoin(player);
        }
    }

    @Override
    public void onPreLeave(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
        this.removeInMatch(player);
    }

    @Override
    public void onPostLeave(ArenaPlayer player, ArenaPlayerTeleportEvent apte) {
    }

    public void setMessageHandler(MatchMessageHandler mc) {
        this.mc.setMessageHandler(mc);
    }

    public MatchMessageHandler getMessageHandler() {
        return this.mc.getMessageHandler();
    }

    private synchronized void addVictoryConditions() {
        Integer nLives;
        this.addedVictoryConditions.set(true);
        VictoryCondition vt = VictoryType.createVictoryCondition(this);
        if (!this.alwaysOpen && !(vt instanceof DefinesTimeLimit) && this.params.getMatchTime() != null && this.params.getMatchTime() > 0 && this.params.getMatchTime() != Integer.MAX_VALUE) {
            this.addVictoryCondition(new TimeLimit(this));
        }
        if (this.alwaysOpen) {
            for (ArenaTeam team : this.getNonEmptyTeams()) {
                TeamTimeLimit ttl = new TeamTimeLimit(this, team);
                this.individualTeamTimeLimits.put(team, ttl);
                ttl.startCountdown();
            }
        }
        if ((nLives = this.params.getNLives()) != null && nLives > 0 && !(vt instanceof DefinesNumLivesPerPlayer)) {
            this.addVictoryCondition(new NLives(this, nLives));
        }
        Integer nTeams = this.params.getMinTeams();
        if (!(vt instanceof DefinesNumTeams) && nTeams > 0 && !this.alwaysOpen) {
            if (nTeams == 1) {
                this.addVictoryCondition(new NoTeamsLeft(this));
            } else {
                this.addVictoryCondition(new OneTeamLeft(this));
            }
        }
        this.addVictoryCondition(vt);
    }

    public void addVictoryCondition(VictoryCondition victoryCondition) {
        this.vcs.add(victoryCondition);
        this.addArenaListener(victoryCondition);
        if (!this.alwaysOpen && victoryCondition instanceof DefinesNumTeams) {
            this.neededTeams = Math.max(this.neededTeams, ((DefinesNumTeams)((Object)victoryCondition)).getNeededNumberOfTeams().max);
        }
        if (victoryCondition instanceof DefinesNumLivesPerPlayer) {
            this.nLivesPerPlayer = Math.max(this.nLivesPerPlayer, ((DefinesNumLivesPerPlayer)((Object)victoryCondition)).getLivesPerPlayer());
            if (this.nLivesPerPlayer > 1) {
                this.respawns = true;
            }
            for (ArenaPlayer ap : this.inGamePlayers) {
                if (this.nLivesPerPlayer == 1 || this.nLivesPerPlayer == Integer.MAX_VALUE) continue;
                ap.getMetaData().setLivesLeft(this.nLivesPerPlayer);
                this.scoreboard.setEntryNameSuffix(ap.getName(), "&4(" + this.nLivesPerPlayer + ")");
            }
        }
        if (Defaults.USE_SCOREBOARD && !this.alwaysOpen && victoryCondition instanceof TimeLimit) {
            if (this.matchCountdown != null) {
                this.matchCountdown.stop();
            }
            final Match match = this;
            this.matchCountdown = new Countdown((Plugin)BattleArena.getSelf(), ((TimeLimit)victoryCondition).getTime(), 1, new Countdown.CountdownCallback(){

                public boolean intervalTick(int secondsRemaining) {
                    match.secondTick(secondsRemaining);
                    return true;
                }
            });
        }
        if (victoryCondition instanceof ScoreTracker) {
            if (this.params.getMaxTeamSize() <= 2) {
                ((ScoreTracker)((Object)victoryCondition)).setDisplayTeams(false);
            }
            ((ScoreTracker)((Object)victoryCondition)).setScoreBoard(this.scoreboard);
        }
    }

    public void removeVictoryCondition(VictoryCondition victoryCondition) {
        this.vcs.remove(victoryCondition);
        this.removeArenaListener(victoryCondition);
    }

    public VictoryCondition getVictoryCondition(Class<? extends VictoryCondition> clazz) {
        for (VictoryCondition vc : this.vcs) {
            if (vc.getClass() != clazz) continue;
            return vc;
        }
        return null;
    }

    @Override
    public Arena getArena() {
        return this.arena;
    }

    public boolean isEnding() {
        return this.isWon() || this.isFinished();
    }

    public boolean isFinished() {
        return this.state == MatchState.ONCOMPLETE || this.state == MatchState.ONCANCEL;
    }

    public boolean isWon() {
        return this.state == MatchState.INVICTORY || this.state == MatchState.ONCOMPLETE || this.state == MatchState.ONCANCEL;
    }

    public boolean isStarted() {
        return this.state == MatchState.INGAME;
    }

    public boolean isInWaitRoomState() {
        return this.state.ordinal() < MatchState.ONSTART.ordinal();
    }

    @Override
    public MatchState getState() {
        return this.state;
    }

    @Override
    public MatchState getMatchState() {
        return this.state == MatchState.INGAME ? MatchState.ONSTART : this.state;
    }

    @Override
    protected void transitionTo(CompetitionState state) {
        this.state = (MatchState)state;
        if (!this.addedVictoryConditions.get() && state == this.tinState) {
            this.addVictoryConditions();
        }
        this.times.put(this.state, System.currentTimeMillis());
    }

    @Override
    public Long getTime(CompetitionState state) {
        return this.times.get(state);
    }

    @Override
    public MatchParams getParams() {
        return this.params;
    }

    @Override
    public List<ArenaTeam> getTeams() {
        return this.teams;
    }

    public List<ArenaTeam> getAliveTeams() {
        ArrayList<ArenaTeam> alive = new ArrayList<ArenaTeam>();
        for (ArenaTeam t : this.teams) {
            if (t.isDead()) continue;
            alive.add(t);
        }
        return alive;
    }

    public Set<ArenaPlayer> getAlivePlayers() {
        HashSet<ArenaPlayer> players = new HashSet<ArenaPlayer>();
        for (ArenaTeam t : this.teams) {
            if (t.isDead()) continue;
            players.addAll(t.getLivingPlayers());
        }
        return players;
    }

    public SpawnLocation getTeamSpawn(ArenaTeam team, boolean random) {
        return random ? this.arena.getSpawn(-1, true) : this.arena.getSpawn(team.getIndex(), false);
    }

    public SpawnLocation getTeamSpawn(int index, boolean random) {
        return random ? this.arena.getSpawn(-1, true) : this.arena.getSpawn(index, false);
    }

    public SpawnLocation getWaitRoomSpawn(ArenaTeam team, boolean random) {
        return random ? this.arena.getRandomWaitRoomSpawnLoc() : this.arena.getWaitRoomSpawnLoc(team.getIndex());
    }

    public SpawnLocation getWaitRoomSpawn(int index, boolean random) {
        return random ? this.arena.getRandomWaitRoomSpawnLoc() : this.arena.getWaitRoomSpawnLoc(index);
    }

    public void setMatchResult(MatchResult result) {
        this.matchResult = result;
    }

    public void endMatchWithResult(MatchResult result) {
        this.matchResult = result;
        this.matchWinLossOrDraw(result);
    }

    public void setVictor(ArenaPlayer p) {
        ArenaTeam t = this.getTeam(p);
        if (t != null) {
            this.setVictor(t);
        }
    }

    public synchronized void setWinner(ArenaTeam team) {
        this.setVictor(team);
    }

    public synchronized void setVictor(ArenaTeam team) {
        this.setVictor(new ArrayList<ArenaTeam>(Arrays.asList(team)));
    }

    public synchronized void setVictor(Collection<ArenaTeam> winningTeams) {
        if (this.individualWins) {
            MatchResult result = new MatchResult();
            result.setVictors(winningTeams);
            this.endMatchWithResult(result);
        } else {
            this.matchResult.setVictors(winningTeams);
            ArrayList<ArenaTeam> losers = new ArrayList<ArenaTeam>(this.teams);
            losers.removeAll(winningTeams);
            this.matchResult.addLosers(losers);
            this.matchResult.setResult(WinLossDraw.WIN);
            this.endMatchWithResult(this.matchResult);
        }
    }

    public synchronized void setDraw() {
        this.matchResult.setResult(WinLossDraw.DRAW);
        this.matchResult.setDrawers(this.teams);
        this.endMatchWithResult(this.matchResult);
    }

    public synchronized void setLosers() {
        this.matchResult.setResult(WinLossDraw.LOSS);
        this.matchResult.setLosers(this.teams);
        this.endMatchWithResult(this.matchResult);
    }

    public synchronized void setNonEndingVictor(ArenaTeam team) {
        MatchResult result = new MatchResult();
        result.setVictor(team);
        this.nonEndingMatchWinLossOrDraw(result);
    }

    public MatchResult getResult() {
        return this.matchResult;
    }

    public Set<ArenaTeam> getVictors() {
        return this.matchResult.getVictors();
    }

    public synchronized Set<ArenaTeam> getLosers() {
        return this.matchResult.getLosers();
    }

    public Set<ArenaTeam> getDrawers() {
        return this.matchResult.getDrawers();
    }

    public int indexOf(ArenaTeam t) {
        return this.teams.indexOf(t);
    }

    @Override
    public boolean isHandled(ArenaPlayer player) {
        GameManager gm = GameManager.getGameManager(this.params);
        boolean b = gm.isHandled(player);
        return this.isInMatch(player) || b;
    }

    protected Set<ArenaPlayer> checkReady(ArenaTeam t, StateOptions mo) {
        HashSet<ArenaPlayer> alive = new HashSet<ArenaPlayer>();
        for (ArenaPlayer p : t.getPlayers()) {
            if (!this.checkReady(p, t, mo, true)) continue;
            alive.add(p);
        }
        return alive;
    }

    @Override
    public boolean checkReady(ArenaPlayer p, ArenaTeam t, StateOptions mo, boolean announce) {
        boolean online = p.isOnline();
        boolean inBed = p.getPlayer().isSleeping();
        boolean inmatch = this.isInMatch(p);
        String pname = p.getDisplayName();
        boolean ready = true;
        World w = this.arena.getSpawn(0, false).getLocation().getWorld();
        if (!online) {
            t.sendToOtherMembers(p, "&4!!! &eYour teammate &6" + pname + "&e was killed for not being online");
            ready = false;
        } else if (inBed) {
            t.sendToOtherMembers(p, "&4!!! &eYour teammate &6" + pname + "&e was killed for being in bed while the match starts");
            ready = false;
        } else if (p.isDead()) {
            t.sendToOtherMembers(p, "&4!!! &eYour teammate &6" + pname + "&e was killed for being dead while the match starts");
            ready = false;
        } else if (!inmatch && !this.tops.playerReady(p, w)) {
            t.sendToOtherMembers(p, "&4!!! &eYour teammate &6" + pname + "&e was killed for not being ready");
            String notReady = this.tops.getRequiredString(p, w, "&eYou needed");
            MessageUtil.sendMessage(p, "&eYou didn't compete because of the following.");
            MessageUtil.sendMessage(p, notReady);
            ready = false;
        }
        if (!ready) {
            t.killMember(p);
        }
        return ready;
    }

    public void sendMessage(String string) {
        for (ArenaTeam t : this.teams) {
            t.sendMessage(string);
        }
    }

    public String getMatchInfo() {
        StateOptions to = this.params.getStateOptions(this.state);
        StringBuilder sb = new StringBuilder("ArenaMatch " + this.toString() + " ");
        sb.append(this.params).append("\n");
        sb.append("state=&6").append(this.state).append("\n");
        sb.append("pvp=&6").append(to != null ? to.getPVP() : "on").append("\n");
        sb.append("result=&e(").append(this.matchResult).append("&e)\n");
        ArrayList<ArenaTeam> deadTeams = new ArrayList<ArenaTeam>();
        ArrayList<ArenaTeam> aliveTeams = new ArrayList<ArenaTeam>();
        for (ArenaTeam t : this.teams) {
            if (t.size() == 0) continue;
            if (t.isDead()) {
                deadTeams.add(t);
                continue;
            }
            aliveTeams.add(t);
        }
        for (ArenaTeam t : aliveTeams) {
            sb.append(t.getTeamInfo(this.inMatch)).append("\n");
        }
        for (ArenaTeam t : deadTeams) {
            sb.append(t.getTeamInfo(this.inMatch)).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[Match:" + this.id + ":" + (this.arena != null ? this.arena.getName() : "none") + " ,");
        for (ArenaTeam t : this.teams) {
            sb.append("[").append(t.getDisplayName()).append("] ,");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean hasTeam(ArenaTeam team) {
        return this.teams.contains(team);
    }

    public List<VictoryCondition> getVictoryConditions() {
        return this.vcs;
    }

    public void timeExpired() {
        MatchFindCurrentLeaderEvent event = new MatchFindCurrentLeaderEvent(this, this.teams, true);
        this.callEvent(event);
        MatchResult result = event.getResult();
        if (result.isUnknown() || result.getDrawers().isEmpty() && result.getLosers().isEmpty() && result.getVictors().isEmpty()) {
            result = this.defaultObjective.getMatchResult(this);
        }
        try {
            this.mc.sendTimeExpired();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        this.endingMatchWinLossOrDraw(result);
    }

    public void intervalTick(int remaining) {
        MatchFindCurrentLeaderEvent event = new MatchFindCurrentLeaderEvent(this, this.teams, false);
        this.callEvent(event);
        this.callEvent(new MatchTimerIntervalEvent(this, remaining));
        try {
            this.mc.sendOnIntervalMsg(remaining, event.getCurrentLeaders());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void secondTick(int remaining) {
        SObjective obj = this.scoreboard.getObjective(SAPIDisplaySlot.SIDEBAR);
        if (obj != null) {
            obj.setDisplayNameSuffix(" &e(" + remaining + ")");
        }
    }

    public AbstractJoinHandler getTeamJoinHandler() {
        return this.joinHandler;
    }

    public boolean hasWaitroom() {
        return this.arena.getWaitroom() != null;
    }

    public boolean hasSpectatorRoom() {
        return this.arena.getSpectatorRoom() != null;
    }

    public boolean isJoinablePostCreate() {
        return this.joinHandler != null && (this.alwaysOpen || this.tops.hasOptionAt(MatchState.ONJOIN, TransitionOption.ALWAYSJOIN) || !this.joinHandler.isFull() || this.params.hasOptionAt((CompetitionState)MatchState.ONJOIN, TransitionOption.TELEPORTIN));
    }

    public boolean canStillJoin() {
        return this.joinHandler != null && (this.alwaysOpen || this.tops.hasOptionAt(MatchState.ONJOIN, TransitionOption.ALWAYSJOIN) || (this.hasWaitroom() || this.hasSpectatorRoom()) && !this.joinHandler.isFull() && this.isInWaitRoomState() && (this.joinCutoffTime == null || System.currentTimeMillis() < this.joinCutoffTime) || this.params.hasOptionAt((CompetitionState)MatchState.ONJOIN, TransitionOption.TELEPORTIN) && this.state.ordinal() < MatchState.ONSTART.ordinal());
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.params.getName();
    }

    public void killTeam(int teamIndex) {
        if (this.teams.size() <= teamIndex) {
            return;
        }
        ArenaTeam t = (ArenaTeam)this.teams.get(teamIndex);
        if (t == null) {
            return;
        }
        this.killTeam(t);
    }

    public void killTeam(ArenaTeam t) {
        for (ArenaPlayer ap : t.getLivingPlayers()) {
            ArenaPlayerDeathEvent apde = new ArenaPlayerDeathEvent(ap, t);
            apde.setExiting(true);
            this.callEvent(apde);
        }
    }

    public boolean allTeamsReady() {
        for (ArenaTeam t : this.teams) {
            if (t.isReady()) continue;
            return false;
        }
        return true;
    }

    public boolean alwaysOpen() {
        return this.alwaysOpen;
    }

    public ArenaScoreboard getScoreboard() {
        return this.scoreboard;
    }

    @Override
    public SpawnLocation getSpawn(int index, boolean random) {
        return this.getTeamSpawn(index, random);
    }

    @Override
    public LocationType getLocationType() {
        return LocationType.ARENA;
    }

    public List<ArenaPlayer> getNonLeftPlayers() {
        ArrayList<ArenaPlayer> players = new ArrayList<ArenaPlayer>();
        for (ArenaTeam at : this.getTeams()) {
            for (ArenaPlayer ap : at.getPlayers()) {
                if (at.hasLeft(ap)) continue;
                players.add(ap);
            }
        }
        return players;
    }

    public void setOldArenaParams(MatchParams oldArenaParams) {
        if (this.oldArenaState == null) {
            this.oldArenaState = new ArenaPreviousState(this.arena);
        }
        this.oldArenaState.params = oldArenaParams;
    }

    public Double getPrizePoolMoney() {
        return this.prizePoolMoney;
    }

    class ArenaPreviousState {
        final ContainerState waitroomCS;
        final ContainerState arenaCS;
        MatchParams params;

        public ArenaPreviousState(Arena arena) {
            this.waitroomCS = arena.getWaitroom() != null ? arena.getWaitroom().getContainerState() : null;
            this.arenaCS = arena.getContainerState();
        }

        public void revert(Arena arena) {
            if (this.params != null) {
                arena.setParams(this.params);
            }
            arena.setContainerState(this.arenaCS);
            if (this.waitroomCS != null && arena.getWaitroom() != null) {
                arena.getWaitroom().setContainerState(this.waitroomCS);
            }
        }
    }

    class MatchCompleted
    implements Runnable {
        final Match am;

        MatchCompleted(Match am) {
            this.am = am;
        }

        public void run() {
            Match.this.transitionTo(MatchState.ONCOMPLETE);
            this.am.performTransition(MatchState.ONCOMPLETE, Match.this.teams, true);
            Match.this.currentTimer = Scheduler.scheduleSynchronousTask(new Runnable(){

                public void run() {
                    Match.this.callEvent(new MatchCompletedEvent(MatchCompleted.this.am));
                    Match.this.arenaInterface.onComplete();
                    Match.this.givePrizes(MatchCompleted.this.am, Match.this.matchResult);
                    Match.this.updateBukkitEvents(MatchState.ONCOMPLETE);
                    Match.this.deconstruct();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NonEndingMatchCompleted
    implements Runnable {
        final Match am;
        final MatchResult result;
        final List<ArenaTeam> teams;

        NonEndingMatchCompleted(Match am, MatchResult result, List<ArenaTeam> teams) {
            this.am = am;
            this.result = result;
            this.teams = teams;
        }

        @Override
        public void run() {
            Set<ArenaTeam> victors = this.result.getVictors();
            this.am.performTransition(MatchState.ONCOMPLETE, this.teams, true);
            int timerid = Scheduler.scheduleSynchronousTask(new Runnable(){

                public void run() {
                    Match.this.givePrizes(NonEndingMatchCompleted.this.am, NonEndingMatchCompleted.this.result);
                    Match.this.nonEndingDeconstruct(NonEndingMatchCompleted.this.teams);
                }
            });
            for (ArenaTeam t : this.teams) {
                Match.this.individualTeamTimers.put(t, timerid);
            }
        }
    }

    class MatchVictory
    implements Runnable {
        final Match am;

        MatchVictory(Match am) {
            this.am = am;
        }

        public void run() {
            Set<ArenaTeam> victors = Match.this.matchResult.getVictors();
            Set<ArenaTeam> losers = Match.this.matchResult.getLosers();
            Set<ArenaTeam> drawers = Match.this.matchResult.getDrawers();
            if (Match.this.params.isRated().booleanValue()) {
                TrackerController sc = new TrackerController(Match.this.params);
                sc.addRecord(victors, losers, drawers, this.am.getResult().getResult(), Match.this.params.isTeamRating());
            }
            if (Match.this.matchResult.hasVictor()) {
                try {
                    Match.this.mc.sendOnVictoryMsg(victors, losers);
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            } else {
                try {
                    Match.this.mc.sendOnDrawMessage(drawers, losers);
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
            Match.this.updateBukkitEvents(MatchState.ONVICTORY);
            this.am.performTransition(MatchState.ONVICTORY, Match.this.teams, true);
            Match.this.currentTimer = Scheduler.scheduleSynchronousTask(new MatchCompleted(this.am), (int)((long)Match.this.params.getSecondsToLoot().intValue() * 20L));
        }
    }

    class NonEndingMatchVictory
    implements Runnable {
        final Match am;
        final MatchResult result;

        NonEndingMatchVictory(Match am, MatchResult result) {
            this.am = am;
            this.result = result;
        }

        public void run() {
            ArrayList<ArenaTeam> teams = new ArrayList<ArenaTeam>();
            Set<ArenaTeam> victors = this.result.getVictors();
            Set<ArenaTeam> losers = this.result.getLosers();
            Set<ArenaTeam> drawers = this.result.getDrawers();
            teams.addAll(victors);
            teams.addAll(losers);
            teams.addAll(drawers);
            if (Match.this.params.isRated().booleanValue()) {
                TrackerController sc = new TrackerController(Match.this.params);
                sc.addRecord(victors, losers, drawers, this.result.getResult(), Match.this.params.isTeamRating());
            }
            if (this.result.hasVictor()) {
                try {
                    Match.this.mc.sendOnVictoryMsg(victors, losers);
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            } else {
                try {
                    Match.this.mc.sendOnDrawMessage(drawers, losers);
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
            this.am.performTransition(MatchState.ONVICTORY, teams, true);
            int timerid = Scheduler.scheduleSynchronousTask(new NonEndingMatchCompleted(this.am, this.result, teams), (int)((long)Match.this.params.getSecondsToLoot().intValue() * 20L));
            for (ArenaTeam t : teams) {
                Match.this.individualTeamTimers.put(t, timerid);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PlayerState {
        OUTOFMATCH,
        INMATCH;

    }
}

