/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.CommandController;
import mc.alk.arena.controllers.CompetitionController;
import mc.alk.arena.executors.BAExecutor;
import mc.alk.arena.executors.CustomCommandExecutor;
import mc.alk.arena.executors.DuelExecutor;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.RegisteredCompetition;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.arenas.ArenaType;
import mc.alk.arena.serializers.ArenaSerializer;
import mc.alk.arena.serializers.ConfigSerializer;
import mc.alk.arena.serializers.MessageSerializer;
import mc.alk.arena.util.FileUtil;
import mc.alk.arena.util.Log;
import mc.alk.mc.updater.FileUpdater;
import mc.alk.mc.updater.PluginUpdater;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIRegistrationController {
    static final Set<String> delayedInits = Collections.synchronizedSet(new HashSet());

    private boolean loadFile(Plugin plugin, File fullFile, String fileName, String name, String cmd) {
        if (fullFile.exists()) {
            return true;
        }
        InputStream inputStream = FileUtil.getInputStream(plugin.getClass(), new File(fileName));
        return inputStream != null && this.createFile(fullFile, name, cmd, inputStream);
    }

    private boolean loadFile(Plugin plugin, File defaultFile, File defaultPluginFile, File pluginFile, String fullFileName, String name, String cmd) {
        if (pluginFile.exists()) {
            return true;
        }
        InputStream inputStream = FileUtil.getInputStream(plugin.getClass(), new File(fullFileName));
        if (inputStream == null && defaultFile != null && defaultPluginFile != null) {
            inputStream = FileUtil.getInputStream(plugin.getClass(), defaultFile, defaultPluginFile);
        }
        return inputStream != null && this.createFile(pluginFile, name, cmd, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createFile(File pluginFile, String name, String cmd, InputStream inputStream) {
        BufferedWriter fw;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        try {
            fw = new BufferedWriter(new FileWriter(pluginFile));
        }
        catch (IOException e) {
            Log.printStackTrace(e);
            return false;
        }
        try {
            String line;
            while ((line = br.readLine()) != null) {
                line = line.replaceAll("<name>", name).replaceAll("<cmd>", cmd);
                fw.write(line + "\n");
            }
        }
        catch (IOException e) {
            Log.printStackTrace(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fw.close();
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
            try {
                br.close();
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
        return true;
    }

    private void setCommandToExecutor(JavaPlugin plugin, String wantedCommand, CommandExecutor executor) {
        if (!APIRegistrationController.setCommandToExecutor(plugin, wantedCommand, executor, false)) {
            ArrayList<String> aliases = new ArrayList<String>();
            ArenaBukkitCommand arenaCommand = new ArenaBukkitCommand(wantedCommand, "", "", aliases, (Plugin)BattleArena.getSelf(), executor);
            CommandController.registerCommand(arenaCommand);
        }
    }

    private static boolean setCommandToExecutor(JavaPlugin plugin, String command, CommandExecutor executor, boolean displayError) {
        try {
            plugin.getCommand(command).setExecutor(executor);
            return true;
        }
        catch (Exception e) {
            if (displayError) {
                Log.err(plugin.getName() + " command " + command + " was not found. Did you register it in your plugin.yml?");
            }
            return false;
        }
    }

    public boolean registerCompetition(JavaPlugin plugin, String name, String cmd, Class<? extends Arena> arenaClass) {
        return this.registerCompetition(plugin, name, cmd, arenaClass, null);
    }

    public boolean registerCompetition(JavaPlugin plugin, String name, String cmd, Class<? extends Arena> arenaClass, CustomCommandExecutor executor) {
        File dir = plugin.getDataFolder();
        File configFile = new File(dir.getAbsoluteFile() + "/" + name + "Config.yml");
        File msgFile = new File(dir.getAbsoluteFile() + "/" + name + "Messages.yml");
        File defaultArenaFile = new File(dir.getAbsoluteFile() + "/arenas.yml");
        return this.registerCompetition(plugin, name, cmd, arenaClass, executor, configFile, msgFile, defaultArenaFile);
    }

    public boolean registerCompetition(JavaPlugin plugin, String name, String cmd, Class<? extends Arena> arenaClass, CustomCommandExecutor executor, File configFile, File messageFile, File defaultArenaFile) {
        return this.registerCompetition(plugin, name, cmd, arenaClass, executor, configFile, messageFile, new File(plugin.getDataFolder() + "/" + name + "Config.yml"), defaultArenaFile);
    }

    public boolean registerCompetition(JavaPlugin plugin, String name, String cmd, Class<? extends Arena> arenaClass, CustomCommandExecutor executor, File configFile, File messageFile, File defaultPluginConfigFile, File defaultArenaFile) {
        try {
            return this._registerCompetition(plugin, name, cmd, arenaClass, executor, configFile, messageFile, defaultPluginConfigFile, defaultArenaFile);
        }
        catch (Exception e) {
            Log.err("[BattleArena] could not register " + plugin.getName() + " " + name);
            Log.err("[BattleArena] config " + configFile);
            Log.printStackTrace(e);
            return true;
        }
    }

    private boolean _registerCompetition(JavaPlugin plugin, String name, String cmd, Class<? extends Arena> arenaClass, CustomCommandExecutor executor, File configFile, File messageFile, File defaultPluginConfigFile, File defaultArenaFile) throws Exception {
        RegisteredCompetition rc;
        File dir = plugin.getDataFolder();
        FileUpdater.makeIfNotExists(dir);
        String configFileName = name + "Config.yml";
        String defaultConfigFileName = "defaultConfig.yml";
        File compDir = configFile.getParentFile().getAbsoluteFile();
        File pluginFile = new File(compDir.getPath() + File.separator + configFileName);
        File defaultFile = new File("default_files/competitions/" + File.separator + defaultConfigFileName);
        if (!delayedInits.contains(plugin.getName())) {
            delayedInits.add(plugin.getName());
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new DelayedRegistrationHandler(plugin, compDir, defaultArenaFile));
        }
        if (!this.loadFile((Plugin)plugin, defaultFile, defaultPluginConfigFile, pluginFile, name + "Config.yml", name, cmd)) {
            Log.err(plugin.getName() + " " + pluginFile.getName() + " could not be loaded!");
            Log.err("defaultFile=" + defaultFile.getAbsolutePath());
            Log.err("defaultPluginFile=" + (defaultPluginConfigFile != null ? defaultPluginConfigFile.getAbsolutePath() : "null"));
            Log.err("pluginFile=" + pluginFile.getAbsolutePath());
            return false;
        }
        ConfigSerializer config = new ConfigSerializer((Plugin)plugin, pluginFile, name);
        if (config.getConfigurationSection(name) == null) {
            Log.err(plugin.getName() + " " + pluginFile.getName() + " config file could not be loaded!");
            return false;
        }
        ArenaType gameType = ConfigSerializer.getArenaGameType(config.getConfigurationSection(name));
        if (arenaClass == null && (arenaClass = gameType != null ? ArenaType.getArenaClass(gameType) : ConfigSerializer.getArenaClass(config.getConfigurationSection(name))) == null) {
            arenaClass = Arena.class;
        }
        ArenaType at = ArenaType.register(name, arenaClass, (Plugin)plugin);
        MatchParams mp = config.loadMatchParams();
        MessageSerializer ms = null;
        if (this.loadFile((Plugin)plugin, messageFile, name + "Messages.yml", name, cmd)) {
            ms = new MessageSerializer(name, mp);
        } else if (gameType != null && (rc = CompetitionController.getCompetition((Plugin)plugin, gameType.getName())) != null) {
            ms = MessageSerializer.getMessageSerializer(gameType.getName());
        }
        if (ms != null) {
            ms.setConfig(messageFile);
            ms.loadAll();
            MessageSerializer.addMessageSerializer(name, ms);
        }
        rc = new RegisteredCompetition((Plugin)plugin, name);
        if (executor == null && gameType != null) {
            RegisteredCompetition comp = CompetitionController.getCompetition((Plugin)plugin, gameType.getName());
            if (comp != null) {
                executor = comp.getCustomExecutor();
            }
        } else {
            rc.setCustomExeuctor(executor);
        }
        this.createExecutor(plugin, cmd, executor, mp);
        rc.setConfigSerializer(config);
        if (!CompetitionController.hasPlugin((Plugin)plugin)) {
            BattleArena.getSelf().getBattlePluginsAPI().scheduleSendStats((Plugin)plugin);
        }
        CompetitionController.addRegisteredCompetition(rc);
        ArenaSerializer as = new ArenaSerializer((Plugin)plugin, defaultArenaFile);
        as.loadArenas((Plugin)plugin, at);
        rc.setArenaSerializer(as);
        return true;
    }

    private void createExecutor(JavaPlugin plugin, String cmd, CustomCommandExecutor executor, MatchParams mp) {
        BAExecutor exe = mp.isDuelOnly() ? new DuelExecutor() : new BAExecutor();
        if (executor != null) {
            exe.addMethods(executor, executor.getClass().getMethods());
        }
        this.setCommandToExecutor(plugin, cmd.toLowerCase(), exe);
        if (!mp.getCommand().equalsIgnoreCase(cmd)) {
            this.setCommandToExecutor(plugin, mp.getCommand().toLowerCase(), exe);
        }
    }

    public void update(Plugin plugin, int bukkitId, File file, BattleArena.UpdateOption updateOption, BattleArena.AnnounceUpdateOption announceOption) {
        if (updateOption == null) {
            updateOption = BattleArena.UpdateOption.NONE;
        }
        if (announceOption == null) {
            announceOption = BattleArena.AnnounceUpdateOption.NONE;
        }
        PluginUpdater.update(plugin, bukkitId, file, updateOption.toPluginUpdater(), announceOption.toPluginUpdater());
    }

    class DelayedRegistrationHandler
    implements Runnable {
        final JavaPlugin plugin;
        final File compDir;
        final File arenaFile;

        DelayedRegistrationHandler(JavaPlugin plugin, File compDir, File arenaFile) {
            this.plugin = plugin;
            this.compDir = compDir;
            this.arenaFile = arenaFile;
        }

        public void run() {
            if (!this.plugin.isEnabled()) {
                return;
            }
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    return file.toString().matches(".*Config.yml$");
                }
            };
            if (!this.compDir.exists()) {
                return;
            }
            for (File file : this.compDir.listFiles(fileFilter)) {
                File msgFile;
                File configFile;
                String n = file.getName().substring(0, file.getName().length() - "Config.yml".length());
                if (ArenaType.contains(n) || n.contains(".") || new APIRegistrationController().registerCompetition(this.plugin, n, n, null, null, configFile = new File(this.compDir + "/" + n + "Config.yml"), msgFile = new File(this.compDir + "/" + n + "Messages.yml"), null, this.arenaFile)) continue;
                Log.err("[BattleArena] Unable to load custom competition " + n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArenaBukkitCommand
    extends Command
    implements PluginIdentifiableCommand {
        final CommandExecutor executor;
        final Plugin plugin;

        public ArenaBukkitCommand(String name, String description, String usageMessage, List<String> aliases, Plugin plugin, CommandExecutor executor) {
            super(name, description, usageMessage, aliases);
            this.plugin = plugin;
            this.executor = executor;
        }

        public boolean execute(CommandSender sender, String commandLabel, String[] args) {
            return this.executor.onCommand(sender, (Command)this, commandLabel, args);
        }

        public Plugin getPlugin() {
            return this.plugin;
        }
    }
}

