/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.plugins.DisguiseInterface;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.events.players.ArenaPlayerClassSelectedEvent;
import mc.alk.arena.listeners.PlayerHolder;
import mc.alk.arena.objects.ArenaClass;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.objects.spawns.SpawnInstance;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.EffectUtil;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.PlayerUtil;
import mc.alk.arena.util.TeamUtil;
import mc.alk.arena.util.TimeUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArenaClassController {
    static final HashMap<String, ArenaClass> classes = new HashMap();
    static final Map<UUID, Long> userClassSwitchTime = new ConcurrentHashMap<UUID, Long>();

    public static void addClass(ArenaClass ac) {
        classes.put(ac.getName().toUpperCase(), ac);
        classes.put(MessageUtil.decolorChat(ac.getDisplayName()).toUpperCase(), ac);
        classes.put(MessageUtil.decolorChat(ac.getDisplayName().replaceAll("\\[\\]", "")).toUpperCase(), ac);
    }

    public static ArenaClass getClass(String name) {
        return classes.get(name.toUpperCase());
    }

    public static void giveClass(ArenaPlayer player, ArenaClass ac) {
        ArenaClassController.giveClass(player, ac, null);
    }

    public static void giveClass(ArenaPlayer player, ArenaClass ac, Color color) {
        ArenaClass oldClass = player.getCurrentClass();
        if (oldClass != null) {
            player.despawnMobs();
        }
        if (HeroesController.enabled()) {
            ac = ArenaClassController.giveHeroClass(player, ac);
        }
        try {
            if (ac.getItems() != null) {
                InventoryUtil.addItemsToInventory(player.getPlayer(), ac.getItems(), true, color);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ArenaClassController.giveClassEnchants(player.getPlayer(), ac);
        if (ac.getDisguiseName() != null && DisguiseInterface.enabled()) {
            DisguiseInterface.disguisePlayer(player.getPlayer(), ac.getDisguiseName());
        }
        if (ac.getMobs() != null) {
            try {
                List<SpawnInstance> mobs = ac.getMobsClone();
                player.setMobs(mobs);
                player.spawnMobs();
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
        if (ac.getDoCommands() != null) {
            PlayerUtil.doCommands(player.getPlayer(), ac.getDoCommands());
        }
        if (player.getPreferredClass() == null) {
            player.setPreferredClass(ac);
        }
        player.setCurrentClass(ac);
    }

    private static ArenaClass giveHeroClass(ArenaPlayer player, ArenaClass ac) {
        ArenaClass ac2;
        String className;
        if (ac == ArenaClass.CHOSEN_CLASS && (className = HeroesController.getHeroClassName(player.getPlayer())) != null && (ac2 = ArenaClassController.getClass(className)) != null) {
            return ac2;
        }
        if (HeroesController.hasHeroClass(ac.getName())) {
            HeroesController.setHeroClass(player.getPlayer(), ac.getName());
        }
        return ac;
    }

    public static void giveClassEnchants(Player player, ArenaClass ac) {
        try {
            if (ac.getEffects() != null) {
                EffectUtil.enchantPlayer(player, ac.getEffects());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Set<ArenaClass> getClasses() {
        return new HashSet<ArenaClass>(classes.values());
    }

    public static boolean changeClass(Player p, PlayerHolder am, ArenaClass ac) {
        boolean woolTeams;
        long t;
        if (ac == null || !ac.valid()) {
            return false;
        }
        if (!p.hasPermission("arena.class.use." + ac.getName().toLowerCase())) {
            MessageUtil.sendSystemMessage((CommandSender)p, "class_no_perms", ac.getDisplayName());
            return false;
        }
        ArenaPlayer ap = BattleArena.toArenaPlayer(p);
        ArenaClass chosen = ap.getCurrentClass();
        if (chosen != null && chosen.getName().equals(ac.getName())) {
            MessageUtil.sendSystemMessage((CommandSender)p, "class_you_are_already", ac.getDisplayName());
            return false;
        }
        if (userClassSwitchTime.containsKey(ap.getID()) && (t = (long)(Defaults.TIME_BETWEEN_CLASS_CHANGE * 1000) - (System.currentTimeMillis() - userClassSwitchTime.get(ap.getID()))) > 0L) {
            MessageUtil.sendSystemMessage((CommandSender)p, "class_wait_time", TimeUtil.convertMillisToString(t));
            return false;
        }
        MatchParams mp = am != null ? am.getParams() : null;
        userClassSwitchTime.put(ap.getID(), System.currentTimeMillis());
        ArenaTeam at = ap.getTeam();
        boolean bl = woolTeams = at != null && at.getIndex() != -1 && p.getInventory().getHelmet() != null && InventoryUtil.sameItem(at.getHeadItem(), p.getInventory().getHelmet());
        if (chosen != null) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (chosen.getItems() != null) {
                items.addAll(chosen.getItems());
            }
            if (mp != null && mp.hasOptionAt((CompetitionState)MatchState.ONSPAWN, TransitionOption.GIVEITEMS) && mp.getGiveItems(MatchState.ONSPAWN) != null) {
                items.addAll(mp.getGiveItems(MatchState.ONSPAWN));
            }
            if (Defaults.NEED_SAME_ITEMS_TO_CHANGE_CLASS && !InventoryUtil.sameItems(items, p.getInventory(), woolTeams)) {
                MessageUtil.sendSystemMessage((CommandSender)p, "class_cant_switch_after_items", new Object[0]);
                return false;
            }
        }
        if (am != null) {
            am.callEvent(new ArenaPlayerClassSelectedEvent(ac));
        } else {
            new ArenaPlayerClassSelectedEvent(ac).callEvent();
        }
        InventoryUtil.clearInventory(p, woolTeams);
        EffectUtil.deEnchantAll(p);
        boolean armorTeams = mp != null && mp.hasAnyOption(TransitionOption.ARMORTEAMS);
        ap.despawnMobs();
        ArenaClassController.giveClass(ap, ac);
        ap.setPreferredClass(ac);
        if (mp != null && am != null) {
            List<PotionEffect> effects;
            CompetitionState state = am.getState();
            ArenaTeam team = am.getTeam(ap);
            int teamIndex = team == null ? -1 : team.getIndex();
            Color color = armorTeams && teamIndex != -1 ? TeamUtil.getTeamColor(teamIndex) : null;
            List<ItemStack> items = mp.getGiveItems(state);
            if (items != null) {
                try {
                    InventoryUtil.addItemsToInventory(p, items, true, color);
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
            if ((items = mp.getGiveItems(MatchState.ONSPAWN)) != null) {
                try {
                    InventoryUtil.addItemsToInventory(p, items, true, color);
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
            if ((effects = mp.getEffects(state)) != null) {
                EffectUtil.enchantPlayer(p, effects);
            }
            if ((effects = mp.getEffects(MatchState.ONSPAWN)) != null) {
                EffectUtil.enchantPlayer(p, effects);
            }
        }
        MessageUtil.sendSystemMessage((CommandSender)p, "class_chosen", ac.getDisplayName());
        return true;
    }

    static {
        classes.put(ArenaClass.CHOSEN_CLASS.getName().toUpperCase(), ArenaClass.CHOSEN_CLASS);
    }
}

