/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.HashMap;
import java.util.List;
import mc.alk.arena.controllers.SpawnController;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.spawns.SpawnLocation;
import mc.alk.arena.util.TeamUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ArenaDebugger {
    static HashMap<Arena, ArenaDebugger> arenas = null;
    final Arena arena;
    HashMap<Location, ItemStack> oldBlocks = new HashMap();

    public static ArenaDebugger getDebugger(Arena arena) {
        ArenaDebugger ad;
        if (arenas == null) {
            arenas = new HashMap();
        }
        if ((ad = arenas.get(arena)) == null) {
            ad = new ArenaDebugger(arena);
            arenas.put(arena, ad);
        }
        return ad;
    }

    public static void removeDebugger(ArenaDebugger ad) {
        arenas.remove(ad.arena);
        if (arenas.isEmpty()) {
            arenas = null;
        }
    }

    public ArenaDebugger(Arena arena) {
        this.arena = arena;
    }

    public static Location getLocKey(Location l) {
        return new Location(l.getWorld(), (double)l.getBlockX(), (double)l.getBlockY(), (double)l.getBlockZ());
    }

    public void hideSpawns(Player player) {
        for (Location l : this.oldBlocks.keySet()) {
            ItemStack is = this.oldBlocks.get(l);
            player.sendBlockChange(l, is.getType(), (byte)is.getDurability());
        }
        this.oldBlocks.clear();
        SpawnController sc = this.arena.getSpawnController();
        if (sc != null) {
            sc.stop();
        }
    }

    public void showSpawns(Player player) {
        int i;
        List<List<SpawnLocation>> locs;
        this.oldBlocks = new HashMap();
        SpawnController sc = this.arena.getSpawnController();
        if (sc != null) {
            sc.start();
        }
        if ((locs = this.arena.getSpawns()) != null) {
            for (i = 0; i < locs.size(); ++i) {
                for (SpawnLocation l : locs.get(i)) {
                    this.changeBlocks(player, l.getLocation(), TeamUtil.getTeamHead(i));
                }
            }
        }
        List<List<SpawnLocation>> list = locs = this.arena.getWaitroom() != null ? this.arena.getWaitroom().getSpawns() : null;
        if (locs != null) {
            for (i = 0; i < locs.size(); ++i) {
                for (SpawnLocation l : locs.get(i)) {
                    this.changeBlocks(player, l.getLocation(), TeamUtil.getTeamHead(i));
                }
            }
        }
        List<List<SpawnLocation>> list2 = locs = this.arena.getSpectatorRoom() != null ? this.arena.getSpectatorRoom().getSpawns() : null;
        if (locs != null) {
            for (i = 0; i < locs.size(); ++i) {
                for (SpawnLocation l : locs.get(i)) {
                    this.changeBlocks(player, l.getLocation(), TeamUtil.getTeamHead(i));
                }
            }
        }
    }

    private void changeBlocks(Player player, Location l, ItemStack is) {
        Location key = ArenaDebugger.getLocKey(l);
        if (!this.oldBlocks.containsKey(key)) {
            Block b = l.getBlock();
            player.sendBlockChange(l, is.getTypeId(), (byte)is.getDurability());
            this.oldBlocks.put(key, new ItemStack(b.getType(), (int)b.getData()));
        }
    }
}

