/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.HashMap;
import java.util.UUID;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.options.SpawnOptions;
import mc.alk.arena.objects.spawns.BlockSpawn;
import mc.alk.arena.objects.spawns.ChestSpawn;
import mc.alk.arena.objects.spawns.TimedSpawn;
import mc.alk.arena.serializers.ArenaSerializer;
import mc.alk.arena.serializers.SpawnSerializer;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.PlayerUtil;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class ArenaEditor
implements Listener {
    int nListening = 0;
    Integer timerID;
    HashMap<UUID, CurrentSelection> selections = new HashMap();

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null || !this.selections.containsKey(PlayerUtil.getID(event.getPlayer()))) {
            return;
        }
        CurrentSelection cs = this.selections.get(PlayerUtil.getID(event.getPlayer()));
        if (cs.listeningIndex == null || cs.getArena() == null) {
            return;
        }
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE && event.getAction() == Action.LEFT_CLICK_BLOCK) {
            event.setCancelled(true);
        }
        Arena a = cs.getArena();
        BlockSpawn bs = event.getClickedBlock().getState() instanceof Chest ? new ChestSpawn(event.getClickedBlock(), true) : new BlockSpawn(event.getClickedBlock(), true);
        TimedSpawn ts = SpawnSerializer.createTimedSpawn(bs, cs.listeningOptions);
        a.addTimedSpawn(cs.listeningIndex, ts);
        BattleArena.getBAController().updateArena(a);
        ArenaSerializer.saveArenas(a.getArenaType().getPlugin());
        MessageUtil.sendMessage((CommandSender)event.getPlayer(), "&2Added block spawn &6" + ts + "&2 to index=&5" + cs.listeningIndex);
        cs.listeningIndex = null;
        cs.listeningOptions = null;
    }

    void startListening() {
        final ArenaEditor self = this;
        if (this.nListening == 0) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BattleArena.getSelf());
        }
        ++this.nListening;
        if (this.timerID != null) {
            Scheduler.cancelTask(this.timerID);
        }
        this.timerID = Scheduler.scheduleSynchronousTask(new Runnable(){

            public void run() {
                HandlerList.unregisterAll((Listener)self);
                ArenaEditor.this.nListening = 0;
            }
        }, 600L);
    }

    public void setCurrentArena(CommandSender p, Arena arena) {
        UUID id = PlayerUtil.getID(p);
        if (this.selections.containsKey(id)) {
            CurrentSelection cs = this.selections.get(id);
            cs.setLastUsed(System.currentTimeMillis());
            cs.setArena(arena);
        } else {
            CurrentSelection cs = new CurrentSelection(System.currentTimeMillis(), arena);
            this.selections.put(id, cs);
        }
    }

    public Arena getArena(CommandSender p) {
        CurrentSelection cs = this.selections.get(PlayerUtil.getID(p));
        if (cs == null) {
            return null;
        }
        return cs.arena;
    }

    public CurrentSelection getCurrentSelection(CommandSender sender) {
        return this.selections.get(PlayerUtil.getID(sender));
    }

    public class CurrentSelection {
        public long lastUsed;
        public Arena arena;
        public Long listeningIndex;
        public SpawnOptions listeningOptions;

        CurrentSelection(long used, Arena arena) {
            this.lastUsed = used;
            this.arena = arena;
        }

        public void updateCurrentSelection() {
            this.lastUsed = System.currentTimeMillis();
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public void setLastUsed(long lastUsed) {
            this.lastUsed = lastUsed;
        }

        public Arena getArena() {
            return this.arena;
        }

        public void setArena(Arena arena) {
            this.arena = arena;
        }

        public void setStartListening(Long index, SpawnOptions po) {
            ArenaEditor.this.startListening();
            this.listeningIndex = index;
            this.listeningOptions = po;
        }
    }
}

