/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mc.alk.arena.BattleArena;
import mc.alk.arena.competition.events.Event;
import mc.alk.arena.events.events.EventFinishedEvent;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.EventParams;
import mc.alk.arena.objects.EventState;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.exceptions.InvalidEventException;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAEventController
implements Listener {
    private Map<String, Map<EventState, List<Event>>> allEvents = Collections.synchronizedMap(new HashMap());

    public BAEventController() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BattleArena.getSelf());
    }

    public SizeEventPair getUniqueEvent(MatchParams eventParams) {
        String key = this.getKey(eventParams);
        Map<EventState, List<Event>> events = this.allEvents.get(key);
        SizeEventPair result = new SizeEventPair();
        if (events == null || events.isEmpty()) {
            return result;
        }
        result.nEvents = 0;
        Event event = null;
        for (List<Event> list : events.values()) {
            SizeEventPair sizeEventPair = result;
            Integer.valueOf(sizeEventPair.nEvents + list.size());
            sizeEventPair.nEvents = sizeEventPair.nEvents;
            for (Event evt : list) {
                if (evt == null) continue;
                if (event != null) {
                    result.event = null;
                    return result;
                }
                event = evt;
                result.event = evt;
            }
        }
        return result;
    }

    public Event getEvent(ArenaPlayer p) {
        for (Map<EventState, List<Event>> map : this.allEvents.values()) {
            for (List<Event> list : map.values()) {
                for (Event event : list) {
                    if (!event.hasPlayer(p)) continue;
                    return event;
                }
            }
        }
        return null;
    }

    public boolean hasOpenEvent() {
        for (Map<EventState, List<Event>> map : this.allEvents.values()) {
            block4: for (EventState es : map.keySet()) {
                switch (es) {
                    case CLOSED: 
                    case FINISHED: {
                        continue block4;
                    }
                }
                if (map.get(es).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasOpenEvent(EventParams eventParam) {
        String key = this.getKey(eventParam);
        Map<EventState, List<Event>> events = this.allEvents.get(key);
        return events != null && events.get(EventState.OPEN) != null;
    }

    private String getKey(Event event) {
        return this.getKey(event.getParams());
    }

    private String getKey(MatchParams eventParams) {
        return eventParams.getCommand().toUpperCase();
    }

    public void addOpenEvent(Event event) throws InvalidEventException {
        List<Event> events;
        String key = this.getKey(event);
        Map<EventState, List<Event>> map = this.allEvents.get(key);
        if (map == null) {
            map = Collections.synchronizedMap(new EnumMap(EventState.class));
            this.allEvents.put(key, map);
        }
        if ((events = map.get(EventState.OPEN)) == null) {
            events = Collections.synchronizedList(new ArrayList());
            map.put(EventState.OPEN, events);
        }
        if (!events.isEmpty()) {
            throw new InvalidEventException("There is already an open event of this type!");
        }
        events.add(event);
    }

    public Event getOpenEvent(EventParams eventParams) {
        String key = this.getKey(eventParams);
        Map<EventState, List<Event>> events = this.allEvents.get(key);
        if (events == null) {
            return null;
        }
        List<Event> es = events.get(EventState.OPEN);
        return es != null && !es.isEmpty() ? es.get(0) : null;
    }

    public void startEvent(Event event) throws Exception {
        if (event.getState() != EventState.OPEN) {
            throw new Exception("Event was not open!");
        }
        String key = this.getKey(event);
        Event evt = this.getOpenEvent(event.getParams());
        if (evt != event) {
            throw new Exception("Trying to start the wrong open event!");
        }
        Map<EventState, List<Event>> map = this.allEvents.get(key);
        if (map == null) {
            map = Collections.synchronizedMap(new EnumMap(EventState.class));
            this.allEvents.put(key, map);
        }
        List<Event> events = map.get(EventState.OPEN);
        events.remove(event);
        events = map.get(EventState.RUNNING);
        if (events == null) {
            events = Collections.synchronizedList(new ArrayList());
            map.put(EventState.RUNNING, events);
        }
        events.add(event);
        event.startEvent();
    }

    public Map<EventState, List<Event>> getCurrentEvents(EventParams eventParams) {
        String key = this.getKey(eventParams);
        Map<EventState, List<Event>> events = this.allEvents.get(key);
        return events != null ? new EnumMap<EventState, List<Event>>(events) : null;
    }

    public boolean removeEvent(Event event) {
        for (Map<EventState, List<Event>> map : this.allEvents.values()) {
            for (List<Event> list : map.values()) {
                Iterator<Event> iter = list.iterator();
                while (iter.hasNext()) {
                    Event evt = iter.next();
                    if (!evt.equals(event)) continue;
                    iter.remove();
                }
            }
        }
        return false;
    }

    public boolean cancelEvent(Event event) {
        event.cancelEvent();
        return this.removeEvent(event);
    }

    @EventHandler
    public void onEventFinished(EventFinishedEvent event) {
        this.removeEvent(event.getEvent());
    }

    public static class SizeEventPair {
        public Integer nEvents = 0;
        public Event event = null;
    }
}

