/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import mc.alk.arena.BattleArena;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.controllers.RoomController;
import mc.alk.arena.controllers.containers.GameManager;
import mc.alk.arena.controllers.containers.LobbyContainer;
import mc.alk.arena.controllers.joining.AbstractJoinHandler;
import mc.alk.arena.events.matches.MatchFinishedEvent;
import mc.alk.arena.events.matches.MatchOpenEvent;
import mc.alk.arena.listeners.SignUpdateListener;
import mc.alk.arena.listeners.custom.MethodController;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.ContainerState;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.arenas.ArenaControllerInterface;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.arenas.ArenaType;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.exceptions.MatchCreationException;
import mc.alk.arena.objects.exceptions.NeverWouldJoinException;
import mc.alk.arena.objects.joining.ArenaMatchQueue;
import mc.alk.arena.objects.joining.MatchTeamQObject;
import mc.alk.arena.objects.joining.TeamJoinObject;
import mc.alk.arena.objects.joining.WaitingObject;
import mc.alk.arena.objects.options.EventOpenOptions;
import mc.alk.arena.objects.options.JoinOptions;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.objects.pairs.JoinResult;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.PlayerUtil;
import mc.alk.arena.util.ServerUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattleArenaController
implements ArenaListener,
Listener {
    private boolean stop = false;
    private final Set<Match> running_matches = Collections.synchronizedSet(new CopyOnWriteArraySet());
    private final Map<ArenaType, List<Match>> unfilled_matches = new HashMap<ArenaType, List<Match>>();
    private Map<String, Arena> allarenas = new ConcurrentHashMap<String, Arena>();
    private final Map<ArenaType, OldLobbyState> oldLobbyState = new HashMap<ArenaType, OldLobbyState>();
    private final ArenaMatchQueue amq = new ArenaMatchQueue();
    final SignUpdateListener signUpdateListener;
    private final Map<ArenaType, Arena> fixedArenas = new HashMap<ArenaType, Arena>();

    public BattleArenaController(SignUpdateListener signUpdateListener) {
        MethodController methodController = new MethodController("BAC");
        methodController.addAllEvents(this);
        try {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)BattleArena.getSelf());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.signUpdateListener = signUpdateListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.LOWEST)
    public void onMatchOpenEvent(MatchOpenEvent event) {
        Match match = event.getMatch();
        match.addArenaListener(this);
        Set<Match> set = this.running_matches;
        synchronized (set) {
            this.running_matches.add(match);
        }
        if (match.isJoinablePostCreate()) {
            List<Match> matches = this.unfilled_matches.get(match.getParams().getType());
            if (matches == null) {
                matches = new CopyOnWriteArrayList<Match>();
                this.unfilled_matches.put(match.getParams().getType(), matches);
            }
            matches.add(0, match);
        } else {
            this.removeFixedReservedArena(match.getArena());
        }
    }

    private void setFixedReservedArena(Arena arena) {
        this.fixedArenas.put(arena.getArenaType(), arena);
    }

    private void removeFixedReservedArena(Arena arena) {
        Arena a = this.fixedArenas.get(arena.getArenaType());
        if (a != null && a.matches(arena)) {
            this.fixedArenas.remove(arena.getArenaType());
        }
    }

    public Match createAndAutoMatch(Arena arena, EventOpenOptions eoo) throws NeverWouldJoinException, IllegalStateException, MatchCreationException {
        MatchParams mp = eoo.getParams();
        MatchParams oldArenaParams = arena.getParams();
        mp.setForceStartTime(eoo.getSecTillStart());
        this.setFixedReservedArena(arena);
        Match m = this.amq.createMatch(arena, eoo);
        m.setOldArenaParams(oldArenaParams);
        this.saveStates(m, arena);
        arena.setAllContainerState(ContainerState.OPEN);
        m.setTimedStart(eoo.getSecTillStart(), eoo.getInterval());
        this.amq.incNumberOpenMatches(mp.getType());
        if (eoo.hasOption(EventOpenOptions.EventOpenOption.FORCEJOIN)) {
            this.addAllOnline(m.getParams(), arena);
        }
        return m;
    }

    private void addAllOnline(MatchParams mp, Arena arena) {
        Player[] online = ServerUtil.getOnlinePlayers();
        String cmd = mp.getCommand() + " add " + arena.getName();
        for (Player p : online) {
            PlayerUtil.doCommand((CommandSender)p, cmd);
        }
    }

    private void saveStates(Match m, Arena arena) {
        if (RoomController.hasLobby(arena.getArenaType())) {
            LobbyContainer pc = RoomController.getLobby(arena.getArenaType());
            OldLobbyState ols = this.oldLobbyState.get(arena.getArenaType());
            if (ols == null) {
                ols = new OldLobbyState();
                ols.pcs = pc.getContainerState();
                this.oldLobbyState.put(arena.getArenaType(), ols);
            }
            ols.add(m);
        }
    }

    private void restoreStates(Match am, Arena arena) {
        OldLobbyState ols;
        if (arena == null) {
            arena = am.getArena();
        }
        if ((ols = this.oldLobbyState.get(arena.getArenaType())) != null && ols.remove(am) && ols.isEmpty()) {
            RoomController.getLobby(am.getArena().getArenaType()).setContainerState(ols.pcs);
        }
    }

    public void startMatch(Match arenaMatch) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)BattleArena.getSelf(), (Runnable)arenaMatch);
    }

    @ArenaEventHandler
    public void matchFinished(MatchFinishedEvent event) {
        Match am = event.getMatch();
        this.removeMatch(am);
        final Arena arena = this.allarenas.get(am.getArena().getName().toUpperCase());
        if (arena == null) {
            return;
        }
        this.restoreStates(am, arena);
        this.removeFixedReservedArena(arena);
        if (am.getParams().hasOptionAt((CompetitionState)MatchState.ONCOMPLETE, TransitionOption.REJOIN)) {
            MatchParams mp = am.getParams();
            List<ArenaPlayer> players = am.getNonLeftPlayers();
            String[] args = new String[]{};
            for (ArenaPlayer ap : players) {
                BattleArena.getBAExecutor().join(ap, mp, args);
            }
        }
        if (BattleArena.getSelf().isEnabled()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)BattleArena.getSelf(), new Runnable(){

                public void run() {
                    BattleArenaController.this.amq.add(arena);
                }
            }, (long)am.getParams().getArenaCooldown().intValue() * 20L);
        }
    }

    public void updateArena(Arena arena) {
        this.allarenas.put(arena.getName().toUpperCase(), arena);
        if (this.amq.removeArena(arena) != null) {
            this.amq.add(arena);
        }
    }

    public void addArena(Arena arena) {
        this.allarenas.put(arena.getName().toUpperCase(), arena);
        this.amq.add(arena);
    }

    public Map<String, Arena> getArenas() {
        return this.allarenas;
    }

    public JoinResult wantsToJoin(TeamJoinObject tqo) throws IllegalStateException {
        Arena a;
        JoinResult jr = this.joinExistingMatch(tqo);
        if (jr.status == JoinResult.JoinStatus.ADDED_TO_EXISTING_MATCH) {
            return jr;
        }
        if (!tqo.getJoinOptions().hasArena()) {
            tqo.getJoinOptions().setArena(this.getNextArena(tqo.getJoinOptions()));
        }
        if (tqo.getJoinOptions().getArena() != null && tqo.getJoinOptions().getArena().getParams().hasOptionAt((CompetitionState)MatchState.DEFAULTS, TransitionOption.ALWAYSOPEN) && this.getArenas(tqo.getMatchParams()).size() == 1 && this.amq.getNumberOpenMatches(tqo.getMatchParams().getType()) >= 1) {
            throw new IllegalStateException("&cThe arena " + tqo.getJoinOptions().getArena().getDisplayName() + "&c is currently in use");
        }
        jr = this.amq.join(tqo);
        MatchParams mp = tqo.getMatchParams();
        if (jr.params == null) {
            jr.params = mp;
        }
        if (tqo.getJoinOptions().hasArena() && jr.status != JoinResult.JoinStatus.STARTED_NEW_GAME && !(a = tqo.getJoinOptions().getArena()).getParams().hasOptionAt((CompetitionState)MatchState.DEFAULTS, TransitionOption.ALWAYSOPEN) && !a.getParams().hasOptionAt((CompetitionState)MatchState.ONJOIN, TransitionOption.ALWAYSJOIN) && mp.hasOptionAt((CompetitionState)MatchState.ONJOIN, TransitionOption.TELEPORTIN) && BattleArena.getBAController().getMatch(a) != null) {
            throw new IllegalStateException("&cThe arena " + a.getDisplayName() + "&c is currently in use");
        }
        switch (jr.status) {
            case ADDED_TO_ARENA_QUEUE: 
            case ADDED_TO_QUEUE: {
                break;
            }
            case NONE: {
                break;
            }
            case ERROR: 
            case ADDED_TO_EXISTING_MATCH: 
            case STARTED_NEW_GAME: {
                return jr;
            }
            case NOTOPEN: 
            case CANT_FIT: {
                return jr;
            }
        }
        if (mp.needsLobby()) {
            if (!RoomController.hasLobby(mp.getType())) {
                throw new IllegalStateException("&cLobby is not set for the " + mp.getName());
            }
            RoomController.getLobby(mp.getType()).teamJoining(tqo.getTeam());
        }
        if (tqo.getJoinOptions().hasArena()) {
            a = tqo.getJoinOptions().getArena();
            if (a.getParams().hasOptionAt((CompetitionState)MatchState.ONJOIN, TransitionOption.TELEPORTWAITROOM)) {
                if (a.getWaitroom() == null) {
                    throw new IllegalStateException("&cWaitroom is not set for this arena");
                }
                a.getWaitroom().teamJoining(tqo.getTeam());
            } else if (a.getParams().hasOptionAt((CompetitionState)MatchState.ONJOIN, TransitionOption.TELEPORTSPECTATE)) {
                if (a.getSpectatorRoom() == null) {
                    throw new IllegalStateException("&cSpectate is not set for this arena");
                }
                a.getSpectatorRoom().teamJoining(tqo.getTeam());
            } else if (a.getParams().hasOptionAt((CompetitionState)MatchState.ONJOIN, TransitionOption.TELEPORTIN)) {
                tqo.getJoinOptions().getArena().teamJoining(tqo.getTeam());
            }
        }
        for (ArenaTeam at : tqo.getTeams()) {
            for (ArenaPlayer ap : at.getPlayers()) {
                ap.getMetaData().setJoinOptions(tqo.getJoinOptions());
            }
        }
        return jr;
    }

    private JoinResult joinExistingMatch(TeamJoinObject tqo) {
        JoinResult jr = new JoinResult();
        jr.params = tqo.getMatchParams();
        if (this.unfilled_matches.isEmpty()) {
            return jr;
        }
        MatchParams params = tqo.getMatchParams();
        List<Match> matches = this.unfilled_matches.get(params.getType());
        if (matches == null) {
            return jr;
        }
        block4: for (Match match : matches) {
            AbstractJoinHandler tjh;
            if (!match.canStillJoin() || !match.getParams().matches(tqo.getJoinOptions()) || !match.getArena().matches(tqo.getJoinOptions()) || (tjh = match.getTeamJoinHandler()) == null) continue;
            AbstractJoinHandler.TeamJoinResult tjr = tjh.joiningTeam(tqo);
            switch (tjr.status) {
                case ADDED: 
                case ADDED_TO_EXISTING: 
                case ADDED_STILL_NEEDS_PLAYERS: {
                    jr.status = JoinResult.JoinStatus.ADDED_TO_EXISTING_MATCH;
                    break;
                }
                case CANT_FIT: {
                    continue block4;
                }
            }
            return jr;
        }
        return jr;
    }

    public boolean isInQue(ArenaPlayer p) {
        return this.amq.isInQue(p);
    }

    public void addMatchup(MatchTeamQObject m) {
        this.amq.join(m);
    }

    public Arena reserveArena(Arena arena) {
        return this.amq.reserveArena(arena);
    }

    public Arena getArena(String arenaName) {
        return this.allarenas.get(arenaName.toUpperCase());
    }

    public Arena removeArena(Arena arena) {
        this.amq.removeArena(arena);
        this.allarenas.remove(arena.getName().toUpperCase());
        return arena;
    }

    public void deleteArena(Arena arena) {
        this.removeArena(arena);
        ArenaControllerInterface ai = new ArenaControllerInterface(arena);
        ai.delete();
    }

    public void arenaChanged(Arena arena) {
        try {
            if (this.removeArena(arena) != null) {
                this.addArena(arena);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public Arena getNextArena(JoinOptions jo) {
        if (this.fixedArenas.containsKey(jo.getMatchParams().getType())) {
            return this.fixedArenas.get(jo.getMatchParams().getType());
        }
        return this.amq.getNextArena(jo);
    }

    public Arena getNextArena(MatchParams mp) {
        if (this.fixedArenas.containsKey(mp.getType())) {
            return this.fixedArenas.get(mp.getType());
        }
        return this.amq.getNextArena(mp);
    }

    public Arena nextArenaByMatchParams(MatchParams mp) {
        return this.amq.getNextArena(mp);
    }

    public Arena getArenaByMatchParams(MatchParams jp) {
        for (Arena a : this.allarenas.values()) {
            if (!a.valid() || !a.matches(jp)) continue;
            return a;
        }
        return null;
    }

    public Arena getArenaByMatchParams(JoinOptions jp) {
        for (Arena a : this.allarenas.values()) {
            if (!a.valid() || !a.matches(jp)) continue;
            return a;
        }
        return null;
    }

    public List<Arena> getArenas(MatchParams mp) {
        ArrayList<Arena> arenas = new ArrayList<Arena>();
        for (Arena a : this.allarenas.values()) {
            if (!a.valid() || !a.matches(mp)) continue;
            arenas.add(a);
        }
        return arenas;
    }

    public Arena getArenaByNearbyMatchParams(JoinOptions jp) {
        Arena possible = null;
        MatchParams mp = jp.getMatchParams();
        int sizeDif = Integer.MAX_VALUE;
        int m1 = mp.getMinTeamSize();
        for (Arena a : this.allarenas.values()) {
            if (a.getArenaType() != mp.getType() || !a.valid()) continue;
            if (a.matches(jp)) {
                return a;
            }
            int m2 = a.getParams().getMinTeamSize();
            if (m2 <= m1 || m2 - m1 >= sizeDif) continue;
            sizeDif = m2 - m1;
            possible = a;
        }
        return possible;
    }

    public Map<Arena, List<String>> getNotMachingArenaReasons(MatchParams mp) {
        HashMap<Arena, List<String>> reasons = new HashMap<Arena, List<String>>();
        for (Arena a : this.allarenas.values()) {
            if (a.getArenaType() != mp.getType()) continue;
            if (!a.valid()) {
                reasons.put(a, a.getInvalidReasons());
            }
            if (a.matches(mp)) continue;
            List rs = (List)reasons.get(a);
            if (rs == null) {
                reasons.put(a, a.getInvalidMatchReasons(mp, null));
                continue;
            }
            rs.addAll(a.getInvalidMatchReasons(mp, null));
        }
        return reasons;
    }

    public Map<Arena, List<String>> getNotMachingArenaReasons(JoinOptions jp) {
        HashMap<Arena, List<String>> reasons = new HashMap<Arena, List<String>>();
        MatchParams mp = jp.getMatchParams();
        Arena wantedArena = jp.getArena();
        for (Arena a : this.allarenas.values()) {
            if (wantedArena != null && !a.matches(wantedArena) || a.getArenaType() != mp.getType()) continue;
            if (!a.valid()) {
                reasons.put(a, a.getInvalidReasons());
            }
            if (a.matches(jp)) continue;
            List rs = (List)reasons.get(a);
            if (rs == null) {
                reasons.put(a, a.getInvalidMatchReasons(mp, jp));
                continue;
            }
            rs.addAll(a.getInvalidMatchReasons(mp, jp));
        }
        return reasons;
    }

    public boolean hasArenaSize(int i) {
        return this.getArenaBySize(i) != null;
    }

    public Arena getArenaBySize(int i) {
        for (Arena a : this.allarenas.values()) {
            if (!a.getParams().matchesTeamSize(i)) continue;
            return a;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMatch(Match am) {
        Set<Match> set = this.running_matches;
        synchronized (set) {
            this.running_matches.remove(am);
        }
        List<Match> matches = this.unfilled_matches.get(am.getParams().getType());
        if (matches != null) {
            matches.remove(am);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        this.amq.stop();
        this.amq.purgeQueue();
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match am : this.running_matches) {
                Arena arena;
                this.cancelMatch(am);
                Arena a = am.getArena();
                if (a == null || (arena = this.allarenas.get(a.getName().toUpperCase())) == null) continue;
                this.amq.add(arena);
            }
            this.running_matches.clear();
        }
    }

    public void resume() {
        this.stop = false;
        this.amq.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelMatch(Arena arena) {
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match am : this.running_matches) {
                if (!am.getArena().getName().equals(arena.getName())) continue;
                this.cancelMatch(am);
                return true;
            }
        }
        return false;
    }

    public boolean cancelMatch(ArenaPlayer p) {
        Match am = this.getMatch(p);
        if (am == null) {
            return false;
        }
        this.cancelMatch(am);
        return true;
    }

    public boolean cancelMatch(ArenaTeam team) {
        Set<ArenaPlayer> ps = team.getPlayers();
        return !ps.isEmpty() && this.cancelMatch(ps.iterator().next());
    }

    public void cancelMatch(Match am) {
        am.cancelMatch();
        for (ArenaTeam t : am.getTeams()) {
            t.sendMessage("&4!!!&e This arena match has been cancelled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Match getArenaMatch(Arena a) {
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match am : this.running_matches) {
                if (!am.getArena().getName().equals(a.getName())) continue;
                return am;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insideArena(ArenaPlayer p) {
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match am : this.running_matches) {
                if (!am.isHandled(p)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Match getMatch(ArenaPlayer p) {
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match am : this.running_matches) {
                if (!am.hasPlayer(p)) continue;
                return am;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Match getMatch(Arena arena) {
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match am : this.running_matches) {
                if (!am.getArena().equals(arena)) continue;
                return am;
            }
        }
        return null;
    }

    public String toString() {
        return "[BAC]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringQueuesAndMatches() {
        StringBuilder sb = new StringBuilder();
        sb.append("------ running  matches -------\n");
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match am : this.running_matches) {
                sb.append(am).append("\n");
            }
        }
        return sb.toString();
    }

    public String toStringArenas() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.amq.toStringArenas());
        sb.append("------ arenas -------\n");
        for (Arena a : this.allarenas.values()) {
            sb.append(a).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllArenas() {
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match am : this.running_matches) {
                am.cancelMatch();
            }
        }
        this.amq.stop();
        this.amq.removeAllArenas();
        this.allarenas.clear();
        this.amq.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllArenas(ArenaType arenaType) {
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match am : this.running_matches) {
                if (am.getArena().getArenaType() != arenaType) continue;
                am.cancelMatch();
            }
        }
        this.amq.stop();
        this.amq.removeAllArenas(arenaType);
        Iterator<Arena> iter = this.allarenas.values().iterator();
        while (iter.hasNext()) {
            Arena a = iter.next();
            if (a == null || a.getArenaType() != arenaType) continue;
            iter.remove();
        }
        this.amq.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllArenas() {
        this.amq.stop();
        this.amq.clearTeamQueues();
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match am : this.running_matches) {
                am.cancelMatch();
            }
        }
        GameManager.cancelAll();
        this.amq.resume();
    }

    public Collection<ArenaTeam> purgeQueue() {
        return this.amq.purgeQueue();
    }

    public boolean hasRunningMatches() {
        return !this.running_matches.isEmpty();
    }

    public WaitingObject getQueueObject(ArenaPlayer player) {
        return this.amq.getQueueObject(player);
    }

    public List<String> getInvalidQueueReasons(WaitingObject qo) {
        return this.amq.invalidReason(qo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceStart(MatchParams mp, boolean respectMinimumPlayers) {
        boolean started = false;
        Map<ArenaType, List<Match>> map = this.unfilled_matches;
        synchronized (map) {
            List<Match> matches = this.unfilled_matches.get(mp.getType());
            if (matches != null) {
                for (Match match : matches) {
                    if (!match.isTimedStart()) continue;
                    match.setTimedStart(0, 0);
                    started = true;
                }
            }
        }
        return this.amq.forceStart(mp, respectMinimumPlayers) || started;
    }

    public Collection<ArenaPlayer> getPlayersInAllQueues() {
        return this.amq.getPlayersInAllQueues();
    }

    public Collection<ArenaPlayer> getPlayersInQueue(MatchParams params) {
        return this.amq.getPlayersInQueue(params);
    }

    public String queuesToString() {
        return this.amq.queuesToString();
    }

    public boolean isQueueEmpty() {
        Collection<ArenaPlayer> col = this.getPlayersInAllQueues();
        return col == null || col.isEmpty();
    }

    public ArenaMatchQueue getArenaMatchQueue() {
        return this.amq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Match> getRunningMatches(MatchParams params) {
        ArrayList<Match> list = new ArrayList<Match>();
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match m : this.running_matches) {
                if (m.getParams().getType() != params.getType()) continue;
                list.add(m);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Match getSingleMatch(MatchParams params) {
        Match match = null;
        Set<Match> set = this.running_matches;
        synchronized (set) {
            for (Match m : this.running_matches) {
                if (m.getParams().getType() != params.getType()) continue;
                if (match != null) {
                    return null;
                }
                match = m;
            }
        }
        return match;
    }

    public void openAll(MatchParams mp) {
        for (Arena arena : this.getArenas(mp)) {
            arena.setAllContainerState(ContainerState.OPEN);
        }
    }

    public class OldLobbyState {
        ContainerState pcs;
        Set<Match> running = new HashSet<Match>();

        public boolean isEmpty() {
            return this.running.isEmpty();
        }

        public void add(Match am) {
            this.running.add(am);
        }

        public boolean remove(Match am) {
            return this.running.remove(am);
        }
    }
}

