/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.lang.reflect.Field;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.Util;
import mc.alk.mc.updater.Version;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandController {
    public static CommandMap getCommandMap() {
        Class<?> clazz;
        Version version = Util.getCraftBukkitVersion();
        try {
            clazz = version.compareTo("0") == 0 || version.getVersion().equalsIgnoreCase("craftbukkit") ? Class.forName("org.bukkit.craftbukkit.CraftServer") : Class.forName("org.bukkit.craftbukkit." + version.getVersion() + ".CraftServer");
        }
        catch (ClassNotFoundException e) {
            Log.printStackTrace(e);
            return null;
        }
        return CommandController.getCommandMapFromServer(clazz);
    }

    private static CommandMap getCommandMapFromServer(Class<?> serverClass) {
        try {
            if (serverClass.isAssignableFrom(Bukkit.getServer().getClass())) {
                Field f = serverClass.getDeclaredField("commandMap");
                f.setAccessible(true);
                return (CommandMap)f.get(Bukkit.getServer());
            }
        }
        catch (SecurityException e) {
            Log.err("You will need to disable the security manager to use dynamic commands");
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return null;
    }

    public static void registerCommand(Command command) {
        CommandMap commandMap = CommandController.getCommandMap();
        if (commandMap != null) {
            commandMap.register("/", command);
        }
    }
}

