/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.HashMap;
import mc.alk.arena.competition.events.Event;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.executors.EventExecutor;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.teams.ArenaTeam;

public class EventController {
    static HashMap<String, Event> registeredEvents = new HashMap();
    static HashMap<String, EventExecutor> registeredExecutors = new HashMap();

    public static Event insideEvent(ArenaPlayer p) {
        for (Event evt : registeredEvents.values()) {
            ArenaTeam t = evt.getTeam(p);
            if (t == null) continue;
            return evt;
        }
        return null;
    }

    public static void addEvent(Event event) {
        registeredEvents.put(event.getName().toLowerCase(), event);
        registeredEvents.put(event.getCommand().toLowerCase(), event);
    }

    public void cancelAll() {
        for (Event evt : registeredEvents.values()) {
            if (evt.isClosed()) continue;
            evt.cancelEvent();
        }
    }

    public static void addEventExecutor(String name, String command, EventExecutor executor) {
        registeredExecutors.put(name.toLowerCase(), executor);
        registeredExecutors.put(command.toLowerCase(), executor);
    }

    public static EventExecutor getEventExecutor(Event event) {
        return registeredExecutors.get(event.getName().toLowerCase());
    }

    public static EventExecutor getEventExecutor(String eventType) {
        return registeredExecutors.get(eventType.toLowerCase());
    }

    public static boolean isEventType(String name) {
        return ParamController.getEventParamCopy(name) != null;
    }
}

