/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.competition.events.Event;
import mc.alk.arena.competition.match.Match;
import mc.alk.arena.controllers.EventController;
import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.events.events.EventFinishedEvent;
import mc.alk.arena.events.matches.MatchFinishedEvent;
import mc.alk.arena.executors.EventExecutor;
import mc.alk.arena.executors.TournamentExecutor;
import mc.alk.arena.objects.EventParams;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.arenas.ArenaListener;
import mc.alk.arena.objects.events.ArenaEventHandler;
import mc.alk.arena.objects.exceptions.InvalidEventException;
import mc.alk.arena.objects.exceptions.InvalidOptionException;
import mc.alk.arena.objects.options.EventOpenOptions;
import mc.alk.arena.objects.pairs.EventPair;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.TimeUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventScheduler
implements Runnable,
ArenaListener {
    int curEvent = 0;
    boolean continuous = false;
    boolean running = false;
    boolean stop = false;
    Integer currentTimer = null;
    final CopyOnWriteArrayList<EventPair> events = new CopyOnWriteArrayList();

    @Override
    public void run() {
        if (this.events.isEmpty() || this.stop) {
            return;
        }
        this.running = true;
        int index = this.curEvent % this.events.size();
        ++this.curEvent;
        this.currentTimer = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)BattleArena.getSelf(), (Runnable)new RunEvent(this, this.events.get(index)));
    }

    @ArenaEventHandler
    public void onEventFinished(EventFinishedEvent event) {
        Event e = event.getEvent();
        e.removeArenaListener(this);
        if (this.continuous) {
            if (BattleArena.getSelf().isEnabled()) {
                Scheduler.scheduleAsynchronousTask(this, 20L * (long)Defaults.TIME_BETWEEN_SCHEDULED_EVENTS);
            }
            if (Defaults.SCHEDULER_ANNOUNCE_TIMETILLNEXT) {
                MessageUtil.broadcastMessage(MessageUtil.colorChat(ChatColor.YELLOW + "Next event will start in " + TimeUtil.convertSecondsToString(Defaults.TIME_BETWEEN_SCHEDULED_EVENTS)));
            }
        } else {
            this.running = false;
        }
    }

    @ArenaEventHandler
    public void onMatchFinished(MatchFinishedEvent event) {
        if (this.continuous) {
            if (BattleArena.getSelf().isEnabled()) {
                Scheduler.scheduleAsynchronousTask(this, 20L * (long)Defaults.TIME_BETWEEN_SCHEDULED_EVENTS);
            }
            if (Defaults.SCHEDULER_ANNOUNCE_TIMETILLNEXT) {
                MessageUtil.broadcastMessage(MessageUtil.colorChat(ChatColor.YELLOW + "Next event will start in " + TimeUtil.convertSecondsToString(Defaults.TIME_BETWEEN_SCHEDULED_EVENTS)));
            }
        } else {
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        this.stop = true;
        this.running = false;
        this.continuous = false;
    }

    public List<EventPair> getEvents() {
        return this.events;
    }

    public void start() {
        this.continuous = true;
        this.stop = false;
        new Thread(this).start();
    }

    public void startNext() {
        this.continuous = false;
        if (this.currentTimer != null) {
            Bukkit.getScheduler().cancelTask(this.currentTimer.intValue());
        }
        this.stop = false;
        new Thread(this).start();
    }

    public boolean scheduleEvent(MatchParams eventParams, String[] args) {
        this.events.add(new EventPair(eventParams, args));
        return true;
    }

    public EventPair deleteEvent(int i) {
        return this.events.remove(i);
    }

    public class RunEvent
    implements Runnable {
        final EventPair eventPair;
        final EventScheduler scheduler;

        public RunEvent(EventScheduler scheduler, EventPair eventPair) {
            this.eventPair = eventPair;
            this.scheduler = scheduler;
        }

        public void run() {
            if (EventScheduler.this.stop) {
                return;
            }
            ConsoleCommandSender sender = Bukkit.getConsoleSender();
            MatchParams params = this.eventPair.getEventParams();
            Object[] args = this.eventPair.getArgs();
            boolean success = false;
            try {
                EventExecutor ee = EventController.getEventExecutor(this.eventPair.getEventParams().getName());
                if (ee != null && ee instanceof TournamentExecutor) {
                    TournamentExecutor exe = (TournamentExecutor)ee;
                    Event event = exe.openIt((CommandSender)sender, (EventParams)params, (String[])args);
                    if (event != null) {
                        event.addArenaListener(this.scheduler);
                        success = true;
                    }
                } else {
                    EventOpenOptions eoo = EventOpenOptions.parseOptions((String[])args, null, params);
                    Arena arena = eoo.getArena(params);
                    if (arena != null) {
                        Match m = BattleArena.getBAController().createAndAutoMatch(arena, eoo);
                        m.addArenaListener(this.scheduler);
                        success = true;
                    } else {
                        Log.warn("[BattleArena] scheduled command args=" + Arrays.toString(args) + " can't be started. Arena is not there or in use");
                    }
                }
            }
            catch (InvalidOptionException e) {
                Log.warn(e.getMessage());
            }
            catch (InvalidEventException e) {
                Log.warn(e.getMessage());
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
            if (!success && BattleArena.getSelf().isEnabled()) {
                Log.info("[BattleArena scheduler starting next command in " + Defaults.TIME_BETWEEN_SCHEDULED_EVENTS + " seconds");
                EventScheduler.this.currentTimer = Scheduler.scheduleAsynchronousTask(this.scheduler, 20L * (long)Defaults.TIME_BETWEEN_SCHEDULED_EVENTS);
            }
        }
    }
}

