/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.CompetitionController;
import mc.alk.arena.controllers.ParamController;
import mc.alk.arena.controllers.StateController;
import mc.alk.arena.controllers.plugins.WorldGuardController;
import mc.alk.arena.objects.ArenaClass;
import mc.alk.arena.objects.CommandLineString;
import mc.alk.arena.objects.CompetitionState;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.MatchState;
import mc.alk.arena.objects.RegisteredCompetition;
import mc.alk.arena.objects.StateGraph;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.exceptions.InvalidOptionException;
import mc.alk.arena.objects.options.AlterParamOption;
import mc.alk.arena.objects.options.StateOptions;
import mc.alk.arena.objects.options.TransitionOption;
import mc.alk.arena.objects.victoryconditions.VictoryType;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.MinMax;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;

public class ParamAlterController {
    MatchParams params;

    public ParamAlterController(MatchParams params) {
        this.params = ParamController.getMatchParams(params.getType());
    }

    private static MatchParams getOrCreateTeamParams(Integer teamIndex, MatchParams params) {
        MatchParams tp;
        Map<Integer, MatchParams> map = params.getThisTeamParams();
        if (map == null) {
            map = new HashMap<Integer, MatchParams>();
            params.setTeamParams(map);
        }
        if ((tp = map.get(teamIndex)) == null) {
            tp = new MatchParams();
            map.put(teamIndex, tp);
        }
        tp.setParent(params);
        return tp;
    }

    public static boolean setTeamParams(CommandSender sender, Integer teamIndex, MatchParams params, AlterParamOption option, Object value) throws InvalidOptionException {
        RegisteredCompetition rc = CompetitionController.getCompetition(params.getName());
        if (rc == null) {
            throw new InvalidOptionException("&cGame &6" + params.getName() + "&c not found!");
        }
        MatchParams tp = ParamAlterController.getOrCreateTeamParams(teamIndex, params);
        ParamAlterController.setOption(sender, tp, option, value);
        ParamAlterController.saveParamsAndUpdate(rc, params);
        return true;
    }

    public static boolean setGameOption(CommandSender sender, MatchParams params, Integer teamIndex, AlterParamOption option, Object value) throws InvalidOptionException {
        RegisteredCompetition rc = CompetitionController.getCompetition(params.getName());
        if (rc == null) {
            throw new InvalidOptionException("&cGame &6" + params.getName() + "&c not found!");
        }
        if (teamIndex != null) {
            MatchParams tp = ParamAlterController.getOrCreateTeamParams(teamIndex, params);
            ParamAlterController.setOption(sender, tp, option, value);
        } else {
            ParamAlterController.setOption(sender, params, option, value);
        }
        ParamAlterController.saveParamsAndUpdate(rc, params);
        return true;
    }

    public static boolean setGameOption(CommandSender sender, MatchParams params, Integer teamIndex, CompetitionState state, TransitionOption to, Object value) throws InvalidOptionException {
        RegisteredCompetition rc = CompetitionController.getCompetition(params.getName());
        if (rc == null) {
            throw new InvalidOptionException("&cGame &6" + params.getName() + "&c not found!");
        }
        if (teamIndex != null) {
            MatchParams tp = ParamAlterController.getOrCreateTeamParams(teamIndex, params);
            ParamAlterController.setOption(sender, tp, state, to, value);
        } else {
            ParamAlterController.setOption(sender, params, state, to, value);
        }
        ParamAlterController.saveParamsAndUpdate(rc, params);
        return true;
    }

    private static void saveParamsAndUpdate(RegisteredCompetition rc, MatchParams params) {
        rc.saveParams(params);
        ParamController.addMatchParams(params);
    }

    public static boolean setOption(CommandSender sender, MatchParams params, AlterParamOption option, Object value) throws IllegalStateException {
        switch (option) {
            case NLIVES: {
                params.setNLives((Integer)value);
                break;
            }
            case NTEAMS: {
                params.setNTeams((MinMax)value);
                break;
            }
            case FORCESTARTTIME: {
                params.setForceStartTime((Integer)value);
                break;
            }
            case TEAMSIZE: {
                params.setTeamSize((MinMax)value);
                break;
            }
            case PREFIX: {
                params.setPrefix((String)value);
                break;
            }
            case SIGNDISPLAYNAME: {
                params.setSignDisplayName((String)value);
                break;
            }
            case DISPLAYNAME: {
                params.setDisplayName((String)value);
                break;
            }
            case COMMAND: {
                params.setCommand((String)value);
                break;
            }
            case DATABASE: {
                params.setTableName((String)value);
                break;
            }
            case MATCHTIME: {
                params.setMatchTime((Integer)value);
                break;
            }
            case CLOSEWAITROOMWHILERUNNING: {
                params.setWaitroomClosedWhileRunning((Boolean)value);
                break;
            }
            case CANCELIFNOTENOUGHPLAYERS: {
                params.setCancelIfNotEnoughPlayers((Boolean)value);
                break;
            }
            case ALLOWEDTEAMSIZEDIFFERENCE: {
                params.setAllowedTeamSizeDifference((Integer)value);
                break;
            }
            case NCUMONCURRENTCOMPETITIONS: {
                params.setNConcurrentCompetitions((Integer)value);
                break;
            }
            case PRESTARTTIME: {
                int iv = (Integer)value;
                ParamAlterController.checkGreater(iv, 0, true);
                params.setSecondsTillMatch(iv);
                break;
            }
            case VICTORYTIME: {
                int iv = (Integer)value;
                ParamAlterController.checkGreater(iv, 1, true);
                params.setSecondsToLoot(iv);
                break;
            }
            case VICTORYCONDITION: {
                params.setVictoryCondition((VictoryType)value);
                break;
            }
            case USETRACKERMESSAGES: {
                params.setUseTrackerMessages((Boolean)value);
                break;
            }
            case RATED: {
                params.setRated((Boolean)value);
                break;
            }
        }
        switch (option) {
            case COMMAND: {
                ParamAlterController.sendMessage(sender, "&c[Info]&e This option will change after a restart");
                break;
            }
        }
        return true;
    }

    public static boolean setOption(CommandSender sender, MatchParams params, CompetitionState state, TransitionOption to, Object value) throws InvalidOptionException {
        List<Object> list;
        if (to.hasValue() && value == null) {
            throw new InvalidOptionException("Transition Option " + to + " needs a value! " + to + "=<value>");
        }
        StateGraph tops = params.getThisStateGraph();
        if (tops == null) {
            tops = new StateGraph();
        }
        if (to == TransitionOption.GIVEITEMS || to == TransitionOption.TAKEITEMS || to == TransitionOption.NEEDITEMS) {
            if (sender == null || !(sender instanceof Player)) {
                throw new InvalidOptionException("&cYou need to be in game to set this option");
            }
            value = InventoryUtil.getItemList((Player)sender);
        } else if (to == TransitionOption.ENCHANTS) {
            list = tops.hasOptionAt(state, to) ? tops.getOptions(state).getEffects() : new ArrayList();
            list.add((PotionEffect)value);
            value = list;
        } else if (to == TransitionOption.DOCOMMANDS) {
            list = tops.hasOptionAt(state, to) ? tops.getOptions(state).getDoCommands() : new ArrayList();
            list.add((CommandLineString)value);
            value = list;
        } else if (to == TransitionOption.GIVECLASS) {
            Map<Object, Object> map = tops.hasOptionAt(state, to) ? tops.getOptions(state).getClasses() : new HashMap();
            map.put(ArenaClass.DEFAULT, (ArenaClass)value);
            value = map;
        } else if (to == TransitionOption.TELEPORTTO) {
            if (sender == null || !(sender instanceof Player)) {
                throw new InvalidOptionException("&cYou need to be in game to set this option");
            }
            value = ((Player)sender).getLocation();
        }
        HashSet<TransitionOption> tpOps = new HashSet<TransitionOption>(Arrays.asList(TransitionOption.TELEPORTIN, TransitionOption.TELEPORTWAITROOM, TransitionOption.TELEPORTCOURTYARD, TransitionOption.TELEPORTLOBBY, TransitionOption.TELEPORTMAINLOBBY, TransitionOption.TELEPORTMAINWAITROOM, TransitionOption.TELEPORTSPECTATE));
        if ((state == MatchState.ONPRESTART || state == MatchState.ONSTART || state == MatchState.ONJOIN) && tpOps.contains(to)) {
            tops.removeStateOption(MatchState.ONPRESTART, to);
            tops.removeStateOption(MatchState.ONSTART, to);
            tops.removeStateOption(MatchState.ONJOIN, to);
            for (TransitionOption op : tpOps) {
                tops.removeStateOption(state, op);
            }
        }
        if (state == MatchState.DEFAULTS) {
            if (to == TransitionOption.WGNOENTER) {
                for (Arena a : BattleArena.getBAController().getArenas(params)) {
                    if (a.getWorldGuardRegion() == null) continue;
                    WorldGuardController.setFlag(a.getWorldGuardRegion(), "entry", false);
                }
            } else if (to == TransitionOption.WGNOLEAVE) {
                for (Arena a : BattleArena.getBAController().getArenas(params)) {
                    if (a.getWorldGuardRegion() == null) continue;
                    WorldGuardController.setFlag(a.getWorldGuardRegion(), "exit", false);
                }
            }
        }
        if ((state == MatchState.ONPRESTART || state == MatchState.ONJOIN) && tpOps.contains(to) && to != TransitionOption.TELEPORTIN && !tops.hasOptionAt(MatchState.ONPRESTART, TransitionOption.TELEPORTIN)) {
            tops.addStateOption(MatchState.ONSTART, TransitionOption.TELEPORTIN);
        }
        tops.addStateOption(state, to, value);
        params.setStateGraph(tops);
        return true;
    }

    public boolean deleteOption(CommandSender sender, String[] args) {
        if (args.length < 2) {
            ParamAlterController.sendMessage(sender, "&6/<game> deleteOption <option>");
            return ParamAlterController.sendMessage(sender, "&6/<game> deleteOption <stage> <option>");
        }
        RegisteredCompetition rc = CompetitionController.getCompetition(this.params.getName());
        if (rc == null) {
            return ParamAlterController.sendMessage(sender, "&cGame &6" + this.params.getName() + "&c not found!");
        }
        AlterParamOption go = AlterParamOption.fromString(args[1]);
        if (go != null) {
            try {
                this.deleteGameOption(go);
                this.params.getThisStateGraph();
                ParamAlterController.saveParamsAndUpdate(rc, this.params);
                ParamController.addMatchParams(this.params);
                ParamAlterController.sendMessage(sender, "&2Game option &6" + go.toString() + "&2 removed");
                switch (go) {
                    case COMMAND: {
                        ParamAlterController.sendMessage(sender, "&c[Info]&e This option will change after a restart");
                        break;
                    }
                }
                return true;
            }
            catch (Exception e) {
                Log.err(e.getMessage());
                ParamAlterController.sendMessage(sender, "&cCould not delete game option &6" + args[1]);
                ParamAlterController.sendMessage(sender, e.getMessage());
                return false;
            }
        }
        CompetitionState state = StateController.fromString(args[1]);
        if (state != null) {
            if (args.length < 3) {
                StateGraph tops = this.params.getThisStateGraph();
                tops.deleteOptions(state);
                return ParamAlterController.sendMessage(sender, "&2Options at &6" + state + "&2 are now empty");
            }
            String key = args[2].trim().toUpperCase();
            try {
                this.deleteTransitionOption(state, key);
                rc.saveParams(this.params);
                ParamAlterController.sendMessage(sender, "&2Game option &6" + state + " " + key + " &2 removed");
                StateGraph tops = this.params.getThisStateGraph();
                StateOptions ops = tops.getOptions(state);
                if (ops == null) {
                    ParamAlterController.sendMessage(sender, "&2Options at &6" + state + "&2 are empty");
                } else {
                    ParamAlterController.sendMessage(sender, "&2Options at &6" + state + "&2 are &6" + ops.toString());
                }
                return true;
            }
            catch (Exception e) {
                ParamAlterController.sendMessage(sender, "&cCould not remove game option " + args[1]);
                ParamAlterController.sendMessage(sender, e.getMessage());
                return false;
            }
        }
        ParamAlterController.sendMessage(sender, "&cGame option &6" + args[1] + "&c not found!");
        return false;
    }

    private boolean deleteTransitionOption(CompetitionState state, String key) throws Exception {
        TransitionOption to = TransitionOption.fromString(key);
        StateGraph tops = this.params.getThisStateGraph();
        return tops.removeStateOption(state, to);
    }

    private boolean deleteGameOption(AlterParamOption go) throws Exception {
        switch (go) {
            case NLIVES: {
                this.params.setNLives(null);
                break;
            }
            case NTEAMS: {
                this.params.setNTeams(null);
                break;
            }
            case TEAMSIZE: {
                this.params.setTeamSize(null);
                break;
            }
            case PREFIX: {
                this.params.setPrefix(null);
                break;
            }
            case SIGNDISPLAYNAME: {
                this.params.setSignDisplayName(null);
                break;
            }
            case COMMAND: {
                this.params.setCommand(null);
                break;
            }
            case MATCHTIME: {
                this.params.setMatchTime(null);
                break;
            }
            case PRESTARTTIME: {
                this.params.setSecondsTillMatch(null);
                break;
            }
            case VICTORYTIME: {
                this.params.setSecondsToLoot(null);
                break;
            }
            case VICTORYCONDITION: {
                this.params.setVictoryCondition(null);
                break;
            }
            case CLOSEWAITROOMWHILERUNNING: {
                this.params.setWaitroomClosedWhileRunning(null);
            }
            case RATED: {
                this.params.setRated(false);
                break;
            }
        }
        return true;
    }

    private static void checkGreater(int iv, int bound, boolean inclusive) throws IllegalStateException {
        if (inclusive && iv < bound) {
            throw new IllegalStateException(iv + "  must be greater or equal to " + bound);
        }
        if (iv <= bound) {
            throw new IllegalStateException(iv + "  must be greater than " + bound);
        }
    }

    private static boolean sendMessage(CommandSender sender, String msg) {
        return MessageUtil.sendMessage(sender, msg);
    }
}

