/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mc.alk.arena.Defaults;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.util.PlayerUtil;
import mc.alk.arena.util.ServerUtil;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlayerController {
    private static HashMap<UUID, ArenaPlayer> players = new HashMap();

    public static ArenaPlayer toArenaPlayer(Player player) {
        Player p2;
        ArenaPlayer ap = players.get(PlayerUtil.getID(player));
        if (Defaults.DEBUG_VIRTUAL && (p2 = ServerUtil.findPlayerExact(player.getName())) != null) {
            player = p2;
        }
        if (ap == null) {
            ap = new ArenaPlayer(player);
            players.put(ap.getID(), ap);
        } else {
            ap.setPlayer(player);
        }
        return ap;
    }

    public static ArenaPlayer toArenaPlayer(UUID id) {
        Player p2;
        ArenaPlayer ap = players.get(id);
        Player player = ServerUtil.findPlayer(id);
        if (Defaults.DEBUG_VIRTUAL && player == null && (p2 = ServerUtil.findPlayer(id)) != null) {
            player = p2;
        }
        if (ap == null) {
            ap = player == null ? new ArenaPlayer(id) : new ArenaPlayer(player);
            players.put(ap.getID(), ap);
        } else if (player != null) {
            ap.setPlayer(player);
        }
        return ap;
    }

    public static ArenaPlayer getArenaPlayer(Player player) {
        return players.get(PlayerUtil.getID(player));
    }

    public static boolean hasArenaPlayer(Player player) {
        return players.containsKey(PlayerUtil.getID(player));
    }

    public static List<ArenaPlayer> toArenaPlayerList(Collection<Player> players) {
        ArrayList<ArenaPlayer> aplayers = new ArrayList<ArenaPlayer>(players.size());
        for (Player p : players) {
            aplayers.add(PlayerController.toArenaPlayer(p));
        }
        return aplayers;
    }

    public static Set<ArenaPlayer> toArenaPlayerSet(Collection<Player> players) {
        HashSet<ArenaPlayer> aplayers = new HashSet<ArenaPlayer>(players.size());
        for (Player p : players) {
            aplayers.add(PlayerController.toArenaPlayer(p));
        }
        return aplayers;
    }

    public static Set<Player> toPlayerSet(Collection<ArenaPlayer> arenaPlayers) {
        HashSet<Player> players = new HashSet<Player>(arenaPlayers.size());
        for (ArenaPlayer ap : arenaPlayers) {
            players.add(ap.getPlayer());
        }
        return players;
    }

    public static List<Player> toPlayerList(Collection<ArenaPlayer> arenaPlayers) {
        ArrayList<Player> players = new ArrayList<Player>(arenaPlayers.size());
        for (ArenaPlayer ap : arenaPlayers) {
            players.add(ap.getPlayer());
        }
        return players;
    }

    public static List<Player> UUIDToPlayerList(Collection<UUID> uuids) {
        ArrayList<Player> players = new ArrayList<Player>(uuids.size());
        for (UUID id : uuids) {
            players.add(ServerUtil.findPlayer(id));
        }
        return players;
    }

    public static void clearArenaPlayers() {
        players.clear();
    }
}

