/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mc.alk.arena.BattleArena;
import mc.alk.arena.controllers.PlayerController;
import mc.alk.arena.controllers.PlayerStoreController;
import mc.alk.arena.controllers.Scheduler;
import mc.alk.arena.controllers.TeleportController;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.util.EffectUtil;
import mc.alk.arena.util.ExpUtil;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.MessageUtil;
import mc.alk.arena.util.PermissionsUtil;
import mc.alk.arena.util.PlayerUtil;
import mc.alk.arena.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerRestoreController {
    final UUID uuid;
    final ArenaPlayer player;
    boolean kill;
    boolean clearInventory;
    int clearWool = -1;
    Location teleportLocation;
    Location tp2;
    Location lastLoc;
    Location backLocation;
    Integer exp;
    Double health;
    Integer hunger;
    Integer magic;
    GameMode gamemode;
    InventoryUtil.PInv item;
    InventoryUtil.PInv matchItems;
    List<ItemStack> removeItems;
    Collection<PotionEffect> effects;
    String message;
    boolean deEnchant;

    public PlayerRestoreController(ArenaPlayer player) {
        this.uuid = player.getID();
        this.player = player;
    }

    public synchronized boolean handle(Player p, PlayerRespawnEvent event) {
        if (this.message != null) {
            this.handleMessage(p);
        }
        if (this.clearInventory) {
            this.handleClearInventory(p);
        }
        if (this.kill) {
            this.handleKill(p);
            return this.stillHandling();
        }
        if (this.teleportLocation != null) {
            this.handleTeleport(p, event);
        }
        if (this.gamemode != null) {
            this.handleGameMode();
        }
        if (this.exp != null) {
            this.handleExp();
        }
        if (this.health != null) {
            this.handleHealth();
        }
        if (this.hunger != null) {
            this.handleHunger();
        }
        if (this.magic != null) {
            this.handleMagic();
        }
        if (this.item != null) {
            this.handleItems();
        }
        if (this.matchItems != null) {
            this.handleMatchItems();
        }
        if (this.removeItems != null) {
            this.handleRemoveItems();
        }
        if (this.deEnchant) {
            try {
                EffectUtil.deEnchantAll(p);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HeroesController.deEnchant(p);
        }
        if (this.effects != null) {
            this.handleEffects();
        }
        return this.stillHandling();
    }

    private void handleEffects() {
        final Collection<PotionEffect> efs = this.effects;
        this.effects = null;
        Scheduler.scheduleSynchronousTask(new Runnable(){

            public void run() {
                Player pl = PlayerRestoreController.this.player.regetPlayer();
                if (pl != null) {
                    try {
                        EffectUtil.enchantPlayer(pl, efs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void handleRemoveItems() {
        final List<ItemStack> items = this.removeItems;
        this.removeItems = null;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)BattleArena.getSelf(), new Runnable(){

            public void run() {
                Player pl = PlayerRestoreController.this.player.regetPlayer();
                if (pl != null) {
                    PlayerStoreController.removeItems(BattleArena.toArenaPlayer(pl), items);
                }
            }
        });
    }

    private void handleMatchItems() {
        final InventoryUtil.PInv items = this.matchItems;
        this.matchItems = null;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)BattleArena.getSelf(), new Runnable(){

            public void run() {
                Player pl = PlayerRestoreController.this.player.regetPlayer();
                if (pl != null) {
                    ArenaPlayer ap = PlayerController.toArenaPlayer(pl);
                    PlayerStoreController.setInventory(ap, items);
                }
            }
        });
    }

    private void handleItems() {
        final InventoryUtil.PInv items = this.item;
        this.item = null;
        Scheduler.scheduleSynchronousTask(new Runnable(){

            public void run() {
                Player pl = PlayerRestoreController.this.player.regetPlayer();
                if (pl != null) {
                    ArenaPlayer ap = PlayerController.toArenaPlayer(pl);
                    PlayerStoreController.setInventory(ap, items);
                }
            }
        });
    }

    private void handleMagic() {
        final int val = this.magic;
        this.magic = null;
        Scheduler.scheduleSynchronousTask(new Runnable(){

            public void run() {
                Player pl = PlayerRestoreController.this.player.regetPlayer();
                if (pl != null) {
                    HeroesController.setMagicLevel(pl, val);
                }
            }
        });
    }

    private void handleHunger() {
        final int val = this.hunger;
        this.hunger = null;
        Scheduler.scheduleSynchronousTask(new Runnable(){

            public void run() {
                Player pl = PlayerRestoreController.this.player.regetPlayer();
                if (pl != null) {
                    BattleArena.toArenaPlayer(pl).setFoodLevel(val);
                }
            }
        });
    }

    private void handleHealth() {
        final Double val = this.health;
        this.health = null;
        Scheduler.scheduleSynchronousTask(new Runnable(){

            public void run() {
                Player pl = PlayerRestoreController.this.player.regetPlayer();
                if (pl != null) {
                    BattleArena.toArenaPlayer(pl).setHealth(val);
                }
            }
        });
    }

    private void handleExp() {
        final int val = this.exp;
        this.exp = null;
        Scheduler.scheduleSynchronousTask(new Runnable(){

            public void run() {
                Player pl = PlayerRestoreController.this.player.regetPlayer();
                if (pl != null) {
                    ExpUtil.setTotalExperience(pl, val);
                }
            }
        });
    }

    private void handleGameMode() {
        final GameMode gm = this.gamemode;
        this.gamemode = null;
        Scheduler.scheduleSynchronousTask(new Runnable(){

            public void run() {
                Player pl = PlayerRestoreController.this.player.regetPlayer();
                if (pl != null) {
                    PlayerUtil.setGameMode(pl, gm);
                }
            }
        });
    }

    private void handleTeleport(final Player p, PlayerRespawnEvent event) {
        Location loc;
        this.tp2 = loc = this.teleportLocation;
        this.teleportLocation = null;
        if (loc != null) {
            if (event == null) {
                Scheduler.scheduleSynchronousTask(new Runnable(){

                    public void run() {
                        Player pl = PlayerRestoreController.this.player.regetPlayer();
                        if (pl != null) {
                            TeleportController.teleport(pl, loc);
                        } else {
                            Util.printStackTrace();
                        }
                    }
                });
            } else {
                PermissionsUtil.givePlayerInventoryPerms(p);
                event.setRespawnLocation(loc);
                if (HeroesController.enabled()) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)BattleArena.getSelf(), new Runnable(){

                        public void run() {
                            Player pl = PlayerRestoreController.this.player.regetPlayer();
                            if (pl != null) {
                                if (pl.getLocation().getWorld().getUID() != loc.getWorld().getUID() || pl.getLocation().distanceSquared(loc) > 100.0) {
                                    TeleportController.teleport(p, loc);
                                }
                            } else {
                                Util.printStackTrace();
                            }
                        }
                    }, 2L);
                }
            }
        } else {
            Log.err(this.player.getName() + " respawn loc =null");
        }
    }

    private boolean stillHandling() {
        return this.clearInventory || this.kill || this.clearWool != -1 || this.teleportLocation != null || this.tp2 != null || this.lastLoc != null || this.exp != null || this.health != null || this.hunger != null || this.magic != null || this.gamemode != null || this.item != null || this.matchItems != null || this.removeItems != null || this.message != null || this.backLocation != null || this.effects != null;
    }

    private void handleKill(Player p) {
        MessageUtil.sendMessage((CommandSender)p, "&eYou have been killed by the Arena for not being online");
        p.setHealth(0.0);
    }

    private void handleMessage(Player p) {
        MessageUtil.sendMessage((CommandSender)p, this.message);
    }

    private void handleClearInventory(Player p) {
        Log.warn("[BattleArena] clearing inventory for quitting during a match " + PlayerUtil.getID(p));
        InventoryUtil.clearInventory(p);
    }

    public void setKill(boolean kill) {
        this.kill = kill;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setClearInventory(boolean clearInventory) {
        this.clearInventory = clearInventory;
    }

    public void setClearWool(int clearWool) {
        this.clearWool = clearWool;
    }

    public void setTp(Location tp) {
        this.teleportLocation = tp;
    }

    public void setTp2(Location tp2) {
        this.tp2 = tp2;
    }

    public void setLastLocs(Location lastLocs) {
        this.lastLoc = lastLocs;
    }

    public void addExp(Integer exp) {
        if (this.exp == null) {
            this.exp = exp;
        } else {
            PlayerRestoreController playerRestoreController = this;
            playerRestoreController.exp = playerRestoreController.exp + exp;
        }
    }

    public void deEnchant() {
        this.deEnchant = true;
    }

    public void setHealth(Double health) {
        this.health = health;
    }

    public void setHunger(Integer hunger) {
        this.hunger = hunger;
    }

    public void setMagic(Integer magic) {
        this.magic = magic;
    }

    public void setGamemode(GameMode gamemode) {
        this.gamemode = gamemode;
    }

    public void setItem(InventoryUtil.PInv item) {
        this.item = item;
    }

    public void setMatchItems(InventoryUtil.PInv matchItems) {
        this.matchItems = matchItems;
    }

    public void setRemoveItems(List<ItemStack> removeItems) {
        this.removeItems = removeItems;
    }

    public void removeMatchItems() {
        this.matchItems = null;
    }

    public void addRemoveItem(ItemStack is) {
        if (this.removeItems == null) {
            this.removeItems = new ArrayList<ItemStack>();
        }
        this.removeItems.add(is);
    }

    public void addRemoveItem(List<ItemStack> itemsToRemove) {
        if (this.removeItems == null) {
            this.removeItems = new ArrayList<ItemStack>();
        }
        this.removeItems.addAll(itemsToRemove);
    }

    public Location getTeleportLocation() {
        return this.teleportLocation;
    }

    public boolean getKill() {
        return this.kill;
    }

    public boolean getClearInventory() {
        return this.clearInventory;
    }

    public int getClearWool() {
        return this.clearWool;
    }

    public Location getTp2() {
        return this.tp2;
    }

    public Location getLastLoc() {
        return this.lastLoc;
    }

    public Integer getExp() {
        return this.exp;
    }

    public Double getHealth() {
        return this.health;
    }

    public Integer getHunger() {
        return this.hunger;
    }

    public Integer getMagic() {
        return this.magic;
    }

    public GameMode getGamemode() {
        return this.gamemode;
    }

    public InventoryUtil.PInv getItem() {
        return this.item;
    }

    public InventoryUtil.PInv getMatchItems() {
        return this.matchItems;
    }

    public List<ItemStack> getRemoveItems() {
        return this.removeItems;
    }

    public String getMessage() {
        return this.message;
    }

    public void setBackLocation(Location location) {
        this.backLocation = location;
    }

    public Location getBackLocation() {
        return this.backLocation;
    }

    public void enchant(Collection<PotionEffect> effects) {
        this.effects = effects;
    }

    public UUID getUUID() {
        return this.player.getID();
    }
}

