/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.controllers.plugins.WorldGuardController;
import mc.alk.arena.listeners.BAPlayerListener;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.PlayerSave;
import mc.alk.arena.objects.regions.WorldGuardRegion;
import mc.alk.arena.util.EffectUtil;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerStoreController {
    static final PlayerStoreController INSTANCE = new PlayerStoreController();
    final HashMap<UUID, PlayerSave> saves = new HashMap();

    public PlayerStoreController() {
    }

    public PlayerStoreController(PlayerSave save) {
        this.saves.put(save.getID(), save);
    }

    private PlayerSave getOrCreateSave(ArenaPlayer player) {
        PlayerSave save = this.saves.get(player.getID());
        if (save != null) {
            return save;
        }
        save = new PlayerSave(player);
        this.saves.put(player.getID(), save);
        return save;
    }

    public void storeAll(ArenaPlayer player) {
        this.storeEffects(player);
        this.storeExperience(player);
        this.storeFlight(player);
        this.storeGamemode(player);
        this.storeHealth(player);
        this.storeHeroClass(player);
        this.storeHunger(player);
        this.storeItems(player);
        this.storeMagic(player);
        this.storeMatchItems(player);
        this.storeScoreboard(player);
    }

    public void restoreAll(ArenaPlayer player) {
        this.restoreEffects(player);
        this.restoreExperience(player);
        this.restoreFlight(player);
        this.restoreGamemode(player);
        this.restoreHealth(player);
        this.restoreHeroClass(player);
        this.restoreHunger(player);
        this.restoreItems(player);
        this.restoreMagic(player);
        this.restoreMoney(player);
        this.restoreMatchItems(player);
        this.restoreScoreboard(player);
    }

    private PlayerSave getSave(ArenaPlayer player) {
        return this.saves.get(player.getID());
    }

    private static boolean restoreable(ArenaPlayer p) {
        return p.isOnline() && !p.isDead();
    }

    public int storeExperience(ArenaPlayer player) {
        return this.getOrCreateSave(player).storeExperience();
    }

    public void restoreExperience(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getExp() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.restoreExperience();
        } else {
            BAPlayerListener.restoreExpOnReenter(p, save.removeExperience());
        }
    }

    public void storeHealth(ArenaPlayer player) {
        this.getOrCreateSave(player).storeHealth();
    }

    public void restoreHealth(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getHealth() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.restoreHealth();
        } else {
            BAPlayerListener.restoreHealthOnReenter(p, save.removeHealth());
        }
    }

    public void storeHunger(ArenaPlayer player) {
        this.getOrCreateSave(player).storeHunger();
    }

    public void restoreHunger(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getHunger() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.restoreHunger();
        } else {
            BAPlayerListener.restoreHungerOnReenter(p, save.removeHunger());
        }
    }

    public void storeEffects(ArenaPlayer player) {
        this.getOrCreateSave(player).storeEffects();
    }

    public void restoreEffects(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getEffects() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.restoreEffects();
        } else {
            BAPlayerListener.restoreEffectsOnReenter(p, save.removeEffects());
        }
    }

    public void restoreMoney(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getMoney() == null) {
            return;
        }
        save.restoreMoney();
    }

    public void storeMagic(ArenaPlayer player) {
        this.getOrCreateSave(player).storeMagic();
    }

    public void restoreMagic(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getMagic() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.restoreMagic();
        } else {
            BAPlayerListener.restoreMagicOnReenter(p, save.removeMagic());
        }
    }

    public void storeItems(ArenaPlayer player) {
        this.getOrCreateSave(player).storeItems();
    }

    public void storeMatchItems(ArenaPlayer player) {
        this.getOrCreateSave(player).storeMatchItems();
    }

    public void clearMatchItems(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getMatchItems() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.removeMatchItems();
        }
    }

    public void restoreItems(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getItems() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.restoreItems();
        } else {
            BAPlayerListener.restoreItemsOnReenter(p, save.removeItems());
        }
    }

    public void restoreMatchItems(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getMatchItems() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.restoreMatchItems();
        } else {
            BAPlayerListener.restoreItemsOnReenter(p, save.removeMatchItems());
        }
    }

    public static void setMatchInventory(ArenaPlayer p, InventoryUtil.PInv pinv) {
        if (Defaults.DEBUG_STORAGE) {
            Log.info("restoring match items for " + p.getName() + "= " + " o=" + p.isOnline() + "  dead=" + p.isDead() + " h=" + p.getHealth() + "");
        }
        if (p.isOnline() && !p.isDead()) {
            InventoryUtil.addToInventory(p.getPlayer(), pinv);
        } else {
            BAPlayerListener.restoreItemsOnReenter(p, pinv);
        }
    }

    public static void setInventory(ArenaPlayer p, InventoryUtil.PInv pinv) {
        if (Defaults.DEBUG_STORAGE) {
            Log.info("setInventory items to " + p.getName() + "= " + " o=" + p.isOnline() + "  dead=" + p.isDead() + " h=" + p.getHealth() + "");
        }
        if (p.isOnline() && !p.isDead()) {
            InventoryUtil.addToInventory(p.getPlayer(), pinv);
        } else {
            BAPlayerListener.restoreItemsOnReenter(p, pinv);
        }
    }

    public void storeFlight(ArenaPlayer p) {
        this.getOrCreateSave(p).storeFlight();
    }

    public void restoreFlight(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getFlight() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.restoreFlight();
        }
    }

    public void storeGodmode(ArenaPlayer p) {
        this.getOrCreateSave(p).storeGodmode();
    }

    public void restoreGodmode(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getGodmode() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.restoreGodmode();
        }
    }

    public void storeGamemode(ArenaPlayer p) {
        this.getOrCreateSave(p).storeGamemode();
    }

    public void restoreGamemode(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getGamemode() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.restoreGamemode();
        } else {
            BAPlayerListener.restoreGameModeOnEnter(p, save.removeGamemode());
        }
    }

    public void clearInv(ArenaPlayer player) {
        if (player.isOnline()) {
            InventoryUtil.clearInventory(player.getPlayer());
        } else {
            BAPlayerListener.clearInventoryOnReenter(player);
        }
    }

    public static void removeItem(ArenaPlayer p, ItemStack is) {
        if (p.isOnline()) {
            InventoryUtil.removeItems(p.getInventory(), is);
        } else {
            BAPlayerListener.removeItemOnEnter(p, is);
        }
    }

    public static void removeItems(ArenaPlayer p, List<ItemStack> items) {
        if (p.isOnline()) {
            InventoryUtil.removeItems((Inventory)p.getInventory(), items);
        } else {
            BAPlayerListener.removeItemsOnEnter(p, items);
        }
    }

    public void addMember(ArenaPlayer p, WorldGuardRegion region) {
        WorldGuardController.addMember(p.getName(), region);
    }

    public void removeMember(ArenaPlayer p, WorldGuardRegion region) {
        WorldGuardController.removeMember(p.getName(), region);
    }

    public void storeHeroClass(ArenaPlayer player) {
        this.getOrCreateSave(player).storeArenaClass();
    }

    public void restoreHeroClass(ArenaPlayer p) {
        PlayerSave save = this.getSave(p);
        if (save == null || save.getArenaClass() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(p)) {
            save.restoreArenaClass();
        }
    }

    public void cancelExpLoss(ArenaPlayer p, boolean cancel) {
        if (!HeroesController.enabled()) {
            return;
        }
        HeroesController.cancelExpLoss(p.getPlayer(), cancel);
    }

    public static PlayerStoreController getPlayerStoreController() {
        return INSTANCE;
    }

    public void deEnchant(Player p) {
        try {
            EffectUtil.deEnchantAll(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HeroesController.deEnchant(p);
        if (!p.isOnline() || p.isDead()) {
            BAPlayerListener.deEnchantOnEnter(BattleArena.toArenaPlayer(p));
        }
    }

    public void storeScoreboard(ArenaPlayer player) {
        this.getOrCreateSave(player).storeScoreboard();
    }

    public void restoreScoreboard(ArenaPlayer player) {
        PlayerSave save = this.getSave(player);
        if (save == null || save.getScoreboard() == null) {
            return;
        }
        if (PlayerStoreController.restoreable(player)) {
            save.restoreScoreboard();
        }
    }
}

