/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import mc.alk.arena.controllers.MoneyController;
import mc.alk.arena.controllers.PlayerStoreController;
import mc.alk.arena.events.prizes.ArenaPrizeEvent;
import mc.alk.arena.events.prizes.Reward;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.util.EffectUtil;
import mc.alk.arena.util.ExpUtil;
import mc.alk.arena.util.InventoryUtil;
import org.bukkit.entity.Player;

public class RewardController {
    ArenaPrizeEvent event;
    PlayerStoreController psc;

    public RewardController(ArenaPrizeEvent event, PlayerStoreController playerStoreController) {
        this.event = event;
        this.psc = playerStoreController;
    }

    public void giveRewards() {
        for (ArenaTeam t : this.event.getTeams()) {
            for (ArenaPlayer player : t.getPlayers()) {
                if (t.hasLeft(player)) continue;
                Player p = player.getPlayer();
                if (this.event.getMoney() != null && MoneyController.hasEconomy()) {
                    MoneyController.add(p.getName(), this.event.getMoney());
                }
                if (!p.isOnline()) continue;
                if (this.event.getExp() != null) {
                    ExpUtil.giveExperience(p, this.event.getExp());
                }
                if (this.event.getEffects() != null) {
                    EffectUtil.enchantPlayer(p, this.event.getEffects());
                }
                if (this.event.getItems() == null) continue;
                InventoryUtil.addItemsToInventory(p, this.event.getItems(), true);
            }
            if (this.event.getRewards() == null) continue;
            for (Reward reward : this.event.getRewards()) {
                reward.reward(t);
            }
        }
    }
}

