/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import mc.alk.arena.BattleArena;
import mc.alk.arena.objects.spawns.SpawnInstance;
import mc.alk.arena.objects.spawns.TimedSpawn;
import mc.alk.arena.util.CaseInsensitiveMap;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.TimeUtil;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpawnController {
    static final boolean DEBUG_SPAWNS = false;
    static CaseInsensitiveMap<SpawnInstance> allSpawns = new CaseInsensitiveMap();
    PriorityQueue<NextSpawn> spawnQ;
    Plugin plugin;
    Map<Long, TimedSpawn> timedSpawns;
    Integer timerId;

    public SpawnController(Map<Long, TimedSpawn> spawnGroups) {
        this.timedSpawns = spawnGroups;
        this.plugin = BattleArena.getSelf();
    }

    public void stop() {
        if (this.timerId != null) {
            Bukkit.getScheduler().cancelTask(this.timerId.intValue());
            this.timerId = null;
        }
        if (this.spawnQ != null) {
            for (NextSpawn ns : this.spawnQ) {
                try {
                    ns.is.despawn();
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
        }
    }

    public void start() {
        if (this.timedSpawns != null && !this.timedSpawns.isEmpty()) {
            BattleArena plugin = BattleArena.getSelf();
            this.spawnQ = new PriorityQueue<NextSpawn>(this.timedSpawns.size(), new Comparator<NextSpawn>(){

                @Override
                public int compare(NextSpawn o1, NextSpawn o2) {
                    return o1.timeToNext.compareTo(o2.timeToNext);
                }
            });
            for (TimedSpawn is : this.timedSpawns.values()) {
                long tts = is.getFirstSpawnTime();
                if (tts == 0L) {
                    is.spawn();
                }
                if (is.getRespawnTime() <= 0L) continue;
                NextSpawn ns = new NextSpawn(is, tts);
                this.spawnQ.add(ns);
            }
            this.timerId = plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new SpawnNextEvent(0L));
        }
    }

    public static void registerSpawn(String s, SpawnInstance sg) {
        allSpawns.put(s, sg);
    }

    public static SpawnInstance getSpawnable(String name) {
        return allSpawns.get(name);
    }

    public class SpawnNextEvent
    implements Runnable {
        Long nextTimeToSpawn = null;

        public SpawnNextEvent(Long nextTimeToSpawn) {
            this.nextTimeToSpawn = nextTimeToSpawn;
        }

        public void run() {
            NextSpawn ns;
            TimeUtil.testClock();
            Iterator<NextSpawn> i$ = SpawnController.this.spawnQ.iterator();
            while (i$.hasNext()) {
                NextSpawn next;
                NextSpawn nextSpawn = next = i$.next();
                Long.valueOf(nextSpawn.timeToNext - this.nextTimeToSpawn);
                nextSpawn.timeToNext = nextSpawn.timeToNext;
            }
            boolean stop = false;
            while (!SpawnController.this.spawnQ.isEmpty() && !stop) {
                stop = SpawnController.this.spawnQ.peek().timeToNext != 0L;
                if (stop) continue;
                ns = (NextSpawn)SpawnController.this.spawnQ.remove();
                ns.is.spawn();
                ns.timeToNext = ns.is.getRespawnTime();
                if (ns.timeToNext <= 0L) continue;
                SpawnController.this.spawnQ.add(ns);
            }
            ns = SpawnController.this.spawnQ.peek();
            if (ns == null) {
                return;
            }
            this.nextTimeToSpawn = ns.timeToNext;
            SpawnController.this.timerId = Bukkit.getScheduler().scheduleSyncDelayedTask(SpawnController.this.plugin, (Runnable)new SpawnNextEvent(this.nextTimeToSpawn), this.nextTimeToSpawn * 20L);
        }
    }

    class NextSpawn {
        TimedSpawn is;
        Long timeToNext;

        NextSpawn(TimedSpawn is, Long timeToSpawn) {
            this.is = is;
            this.timeToNext = timeToSpawn;
        }
    }
}

