/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mc.alk.arena.objects.CompetitionState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateController {
    static final AtomicInteger count = new AtomicInteger(0);
    static final List<Class<? extends Enum>> enums = new ArrayList<Class<? extends Enum>>();

    public static CompetitionState[] values() {
        int size = 0;
        int i = 0;
        for (Class<? extends Enum> enumClass : enums) {
            size += enumClass.getEnumConstants().length;
        }
        CompetitionState[] states = new CompetitionState[size];
        for (Class<? extends Enum> enumClass : enums) {
            for (Enum e : enumClass.getEnumConstants()) {
                states[i++] = (CompetitionState)((Object)e);
            }
        }
        return states;
    }

    public static void register(Class<? extends Enum> enumClass) {
        if (!enums.contains(enumClass)) {
            enums.add(enumClass);
        }
    }

    public static int register(Enum en) {
        Class<?> enumClass = en.getClass();
        for (Class<? extends Enum> classes : enums) {
            if (classes.equals(enumClass)) continue;
            for (Enum e : classes.getEnumConstants()) {
                if (!e.name().equalsIgnoreCase(en.name())) continue;
                throw new IllegalStateException("You can't have multiple CompetitionStates with the same name \n" + enumClass.getSimpleName() + "." + en.name() + "  and " + e.getDeclaringClass().getSimpleName() + "." + e.name());
            }
        }
        if (!enums.contains(enumClass)) {
            enums.add(enumClass);
        }
        return count.incrementAndGet();
    }

    public static CompetitionState fromString(String arg) {
        for (Class<? extends Enum> enumClass : enums) {
            Method m = null;
            try {
                m = enumClass.getMethod("fromString", String.class);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (m == null) {
                try {
                    m = enumClass.getMethod("valueOf", String.class);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (m == null) continue;
            try {
                Object o = m.invoke(null, arg);
                if (o == null || !(o instanceof CompetitionState)) continue;
                return (CompetitionState)o;
            }
            catch (Exception e) {
            }
        }
        return null;
    }
}

