/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mc.alk.arena.controllers.plugins.HeroesController;
import mc.alk.arena.events.players.ArenaPlayerLeaveEvent;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.MatchParams;
import mc.alk.arena.objects.teams.ArenaTeam;
import mc.alk.arena.objects.teams.FormingTeam;
import mc.alk.arena.objects.teams.TeamFactory;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TeamController implements Listener
{
    INSTANCE;

    static final boolean DEBUG = false;
    final Map<UUID, ArenaTeam> selfFormedTeams = Collections.synchronizedMap(new HashMap());
    final Set<FormingTeam> formingTeams = Collections.synchronizedSet(new HashSet());

    public static ArenaTeam getTeam(ArenaPlayer player) {
        ArenaTeam at = TeamController.INSTANCE.selfFormedTeams.get(player.getID());
        if (at == null && HeroesController.enabled()) {
            return HeroesController.getTeam(player.getPlayer());
        }
        return at;
    }

    public boolean inSelfFormedTeam(ArenaPlayer player) {
        return TeamController.INSTANCE.selfFormedTeams.containsKey(player.getID()) || HeroesController.enabled() && HeroesController.getTeam(player.getPlayer()) != null;
    }

    public ArenaTeam getSelfFormedTeam(ArenaPlayer player) {
        return TeamController.getTeam(player);
    }

    public static Collection<ArenaTeam> getSelfFormedTeams() {
        return TeamController.INSTANCE.selfFormedTeams.values();
    }

    public boolean removeSelfFormedTeam(ArenaTeam team) {
        ArrayList<UUID> l = new ArrayList<UUID>();
        for (Map.Entry<UUID, ArenaTeam> entry : this.selfFormedTeams.entrySet()) {
            if (!entry.getValue().equals(team)) continue;
            l.add(entry.getKey());
        }
        for (UUID p : l) {
            this.selfFormedTeams.remove(p);
        }
        return !l.isEmpty();
    }

    public void addSelfFormedTeam(ArenaTeam team) {
        for (ArenaPlayer ap : team.getPlayers()) {
            this.selfFormedTeams.put(ap.getID(), team);
        }
    }

    private void leaveSelfTeam(ArenaPlayer p) {
        ArenaTeam t;
        if (this.inFormingTeam(p) && (t = this.getFormingTeam(p)) != null && this.formingTeams.remove(t)) {
            ((FormingTeam)t).sendMessage("&cYou're team has been disbanded as &6" + p.getDisplayName() + "&c has left minecraft");
            return;
        }
        if (this.inSelfFormedTeam(p) && (t = this.getSelfFormedTeam(p)) != null && this.removeSelfFormedTeam(t)) {
            t.sendMessage("&cYou're team has been disbanded as &6" + p.getDisplayName() + "&c has left minecraft");
        }
    }

    @EventHandler
    public void onPlayerLeave(ArenaPlayerLeaveEvent event) {
        this.leaveSelfTeam(event.getPlayer());
    }

    public boolean inFormingTeam(ArenaPlayer p) {
        for (FormingTeam ft : this.formingTeams) {
            if (!ft.hasMember(p)) continue;
            return true;
        }
        return false;
    }

    public FormingTeam getFormingTeam(ArenaPlayer p) {
        for (FormingTeam ft : this.formingTeams) {
            if (!ft.hasMember(p)) continue;
            return ft;
        }
        return null;
    }

    public void addFormingTeam(FormingTeam ft) {
        this.formingTeams.add(ft);
    }

    public boolean removeFormingTeam(FormingTeam ft) {
        return this.formingTeams.remove(ft);
    }

    public static ArenaTeam createTeam(MatchParams mp, ArenaPlayer p) {
        return TeamFactory.createCompositeTeam(-1, mp, p);
    }

    public String toString() {
        return "[TeamController]";
    }
}

