/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mc.alk.arena.BattleArena;
import mc.alk.arena.Defaults;
import mc.alk.arena.controllers.plugins.CombatTagInterface;
import mc.alk.arena.controllers.plugins.EssentialsController;
import mc.alk.arena.controllers.plugins.VanishNoPacketInterface;
import mc.alk.arena.listeners.BAPlayerListener;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.util.InventoryUtil;
import mc.alk.arena.util.Log;
import mc.alk.arena.util.PermissionsUtil;
import mc.alk.arena.util.PlayerUtil;
import mc.alk.arena.util.ServerUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeleportController
implements Listener {
    static final Set<UUID> teleporting = Collections.synchronizedSet(new HashSet());
    private static final int TELEPORT_FIX_DELAY = 15;

    public static boolean teleport(Player player, Location location) {
        return TeleportController.teleport(BattleArena.toArenaPlayer(player), location, false);
    }

    public static boolean teleport(ArenaPlayer player, Location location) {
        return TeleportController.teleport(player, location, false);
    }

    public static boolean teleport(ArenaPlayer arenaPlayer, Location location, boolean giveBypassPerms) {
        Player player = arenaPlayer.getPlayer();
        try {
            Location l;
            World w;
            Location nl;
            teleporting.add(arenaPlayer.getID());
            player.setVelocity(new Vector(0.0, Defaults.TELEPORT_Y_VELOCITY, 0.0));
            player.setFallDistance(0.0f);
            Location loc = location.clone();
            loc.setY(loc.getY() + Defaults.TELEPORT_Y_OFFSET);
            InventoryUtil.closeInventory(player);
            player.setFireTicks(0);
            arenaPlayer.despawnMobs();
            if (player.isInsideVehicle()) {
                try {
                    player.leaveVehicle();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                if (!loc.getWorld().isChunkLoaded(loc.getBlock().getChunk())) {
                    loc.getWorld().loadChunk(loc.getBlock().getChunk());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            PermissionsUtil.givePlayerInventoryPerms(player);
            if (CombatTagInterface.enabled()) {
                CombatTagInterface.untag(player);
            }
            if (giveBypassPerms && BattleArena.getSelf().isEnabled() && !Defaults.DEBUG_STRESS) {
                player.addAttachment((Plugin)BattleArena.getSelf(), "arena.teleport.bypass", true, 1);
            }
            if (!player.teleport(nl = new Location(w = Bukkit.getWorld((String)loc.getWorld().getName()), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch()), PlayerTeleportEvent.TeleportCause.PLUGIN) || Defaults.DEBUG_VIRTUAL && !player.isOnline()) {
                BAPlayerListener.teleportOnReenter(BattleArena.toArenaPlayer(player), nl, player.getLocation());
                return false;
            }
            arenaPlayer.spawnMobs();
            if (EssentialsController.enabled() && (l = BAPlayerListener.getBackLocation(player)) != null) {
                EssentialsController.setBackLocation(player.getName(), l);
            }
        }
        catch (Exception e) {
            if (!Defaults.DEBUG_VIRTUAL) {
                Log.err("[BA Error] teleporting player=" + player.getDisplayName() + " to " + location + " " + giveBypassPerms);
                Log.printStackTrace(e);
            }
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (teleporting.remove(PlayerUtil.getID(event.getPlayer()))) {
            event.setCancelled(false);
            if (Defaults.ENABLE_TELEPORT_FIX) {
                this.invisbleTeleportWorkaround(event.getPlayer());
            }
        }
    }

    private void invisbleTeleportWorkaround(final Player player) {
        final Server server = Bukkit.getServer();
        BattleArena plugin = BattleArena.getSelf();
        final int visibleDistance = server.getViewDistance() * 16;
        server.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable((Plugin)plugin){
            final /* synthetic */ Plugin val$plugin;
            {
                this.val$plugin = plugin;
            }

            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                List nearby = TeleportController.this.getPlayersWithinDistance(player, visibleDistance);
                TeleportController.this.updateEntities(player, nearby, false);
                server.getScheduler().scheduleSyncDelayedTask(this.val$plugin, new Runnable(){

                    public void run() {
                        List nearby = TeleportController.this.getPlayersWithinDistance(player, visibleDistance);
                        TeleportController.this.updateEntities(player, nearby, true);
                    }
                }, 2L);
            }
        }, 15L);
    }

    private void updateEntities(Player tpedPlayer, List<Player> players, boolean visible) {
        for (Player player : players) {
            if (!player.isOnline()) continue;
            if (VanishNoPacketInterface.isVanished(player)) {
                if (!BattleArena.inArena(player)) continue;
                VanishNoPacketInterface.toggleVanish(player);
            }
            if (visible) {
                tpedPlayer.showPlayer(player);
                player.showPlayer(tpedPlayer);
                continue;
            }
            tpedPlayer.hidePlayer(player);
            player.hidePlayer(tpedPlayer);
        }
    }

    private List<Player> getPlayersWithinDistance(Player player, int distance) {
        ArrayList<Player> res = new ArrayList<Player>();
        int d2 = distance * distance;
        UUID uid = player.getWorld().getUID();
        for (Player p : ServerUtil.getOnlinePlayers()) {
            try {
                if (p.getWorld().getUID() != uid || p == player || !(p.getLocation().distanceSquared(player.getLocation()) <= (double)d2)) continue;
                res.add(p);
            }
            catch (IllegalArgumentException e) {
                Log.info(e.getMessage());
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
        return res;
    }
}

