/*
 * Decompiled with CFR 0.152.
 */
package mc.alk.arena.controllers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mc.alk.arena.controllers.TeleportController;
import mc.alk.arena.controllers.containers.RoomContainer;
import mc.alk.arena.objects.ArenaPlayer;
import mc.alk.arena.objects.PlayerSave;
import mc.alk.arena.objects.arenas.Arena;
import mc.alk.arena.objects.spawns.SpawnLocation;

public class WatchController {
    Map<UUID, PlayerSave> watchers = new HashMap<UUID, PlayerSave>();

    public boolean watch(ArenaPlayer player, Arena arena) {
        RoomContainer rc = arena.getVisitorRoom();
        if (rc == null || rc.getSpawns() == null || rc.getSpawn(0, 0) == null) {
            return false;
        }
        SpawnLocation l = rc.getSpawn(0, 0);
        PlayerSave ps = this.watchers.get(player.getID());
        if (ps == null) {
            ps = new PlayerSave(player);
            this.watchers.put(player.getID(), ps);
            ps.setLocation(player.getLocation());
        }
        TeleportController.teleport(player, l.getLocation());
        return true;
    }

    public boolean hasWatcher(ArenaPlayer player) {
        return this.watchers.containsKey(player.getID());
    }

    public void leave(ArenaPlayer player) {
        PlayerSave ps = this.watchers.remove(player.getID());
        if (ps != null && ps.getLocation() != null) {
            TeleportController.teleport(player, ps.getLocation());
        }
    }
}

